/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManager;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerConfiguration;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.ui.views.TableView;
import org.eclipse.ptp.rm.lml_jaxb.messages.Messages;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtils {
    private static final int UNDEFINED = -1;
    private static final int COPY_BUFFER_SIZE = 65536;

    public static void callDoControl(JobStatusData job, String operation, TableView view, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(job.getRmId());
        IResourceManagerControl control = rm.getControl();
        control.control(job.getJobId(), operation, monitor);
        ActionUtils.maybeUpdateJobState(job, view, monitor);
    }

    public static boolean isAuthorised(JobStatusData status) {
        IJAXBResourceManager rm = (IJAXBResourceManager)ModelManager.getInstance().getResourceManagerFromUniqueName(status.getRmId());
        if (rm == null) {
            return false;
        }
        if (!"STARTED".equals(rm.getState())) {
            return false;
        }
        IJAXBResourceManagerConfiguration config = (IJAXBResourceManagerConfiguration)rm.getControlConfiguration();
        if (config == null) {
            return false;
        }
        String servicesId = config.getRemoteServicesId();
        String connName = config.getConnectionName();
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(servicesId);
        if (!services.isInitialized()) {
            return false;
        }
        IRemoteConnection connection = services.getConnectionManager().getConnection(connName);
        return connection != null && connection.getUsername().equals(status.getOwner());
    }

    public static void maybeUpdateJobState(JobStatusData job, TableView view, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(job.getRmId());
        if (!rm.getState().equals("STARTED")) {
            return;
        }
        IResourceManagerControl control = rm.getControl();
        IJobStatus refreshed = control.getJobStatus(job.getJobId(), true, monitor);
        job.updateState(refreshed.getState(), refreshed.getStateDetail());
        ActionUtils.maybeCheckFiles(job);
        view.refresh();
    }

    public static void readRemoteFile(String resourceManagerId, String path) {
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(resourceManagerId);
        FileReadConsoleAppender reader = new FileReadConsoleAppender(path);
        reader.control = rm.getControl();
        reader.setUser(true);
        reader.schedule();
    }

    public static void removeFiles(final List<JobStatusData> selected) {
        Job j = new Job(Messages.RemoveFiles){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(50 * selected.size()));
                for (JobStatusData status : selected) {
                    IFileStore lres;
                    String rmId = status.getRmId();
                    IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
                    IResourceManagerControl control = rm.getControl();
                    String remotePath = status.getOutputPath();
                    if (remotePath != null) {
                        try {
                            lres = ActionUtils.getRemoteFile(remotePath, control, progress);
                            if (lres != null && lres.fetchInfo(0, (IProgressMonitor)progress.newChild(25)).exists()) {
                                lres.delete(0, (IProgressMonitor)progress.newChild(25));
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    if ((remotePath = status.getErrorPath()) == null) continue;
                    try {
                        lres = ActionUtils.getRemoteFile(remotePath, control, progress);
                        if (lres == null || !lres.fetchInfo(0, (IProgressMonitor)progress.newChild(25)).exists()) continue;
                        lres.delete(0, (IProgressMonitor)progress.newChild(25));
                    }
                    catch (Throwable throwable) {}
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private static IFileStore getRemoteFile(String path, IResourceManagerControl control, SubMonitor progress) {
        IResourceManagerComponentConfiguration config = control.getControlConfiguration();
        String remoteServicesId = config.getRemoteServicesId();
        if (remoteServicesId != null) {
            if (PTPRemoteCorePlugin.getDefault() == null) {
                return null;
            }
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(remoteServicesId, (IProgressMonitor)progress.newChild(25));
            if (remoteServices == null) {
                return null;
            }
            IRemoteConnectionManager remoteConnectionManager = remoteServices.getConnectionManager();
            if (remoteConnectionManager == null) {
                return null;
            }
            String remoteConnectionName = config.getConnectionName();
            if (remoteConnectionName == null) {
                return null;
            }
            IRemoteConnection remoteConnection = remoteConnectionManager.getConnection(remoteConnectionName);
            if (remoteConnection == null) {
                return null;
            }
            IRemoteFileManager remoteFileManager = remoteServices.getFileManager(remoteConnection);
            if (remoteFileManager == null) {
                return null;
            }
            return remoteFileManager.getResource(path);
        }
        return null;
    }

    private static void maybeCheckFiles(JobStatusData job) {
        if ("JOB_OUTERR_READY".equals(job.getStateDetail())) {
            if (job.getOutputPath() != null) {
                job.setOutReady(true);
            }
            if (job.getErrorPath() != null) {
                job.setErrReady(true);
            }
        }
    }

    private ActionUtils() {
    }

    private static class FileReadConsoleAppender
    extends Job {
        private IOConsole console;
        private IOConsoleOutputStream stream;
        private IResourceManagerControl control;
        private int read = 0;

        public FileReadConsoleAppender(String path) {
            super(path);
        }

        protected IStatus run(IProgressMonitor monitor) {
            block16: {
                try {
                    this.console = new IOConsole(this.getName(), null);
                    ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
                    this.console.activate();
                    this.stream = this.console.newOutputStream();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
                    IFileStore lres = ActionUtils.getRemoteFile(this.getName(), this.control, progress);
                    if (lres == null) break block16;
                    BufferedInputStream is = new BufferedInputStream(lres.openInputStream(0, (IProgressMonitor)progress.newChild(25)));
                    byte[] buffer = new byte[65536];
                    try {
                        while (!progress.isCanceled()) {
                            try {
                                this.read = is.read(buffer, 0, 65536);
                            }
                            catch (EOFException eOFException) {
                                break;
                            }
                            if (this.read == -1) {
                                break;
                            }
                            if (progress.isCanceled()) {
                                this.read = -1;
                                break;
                            }
                            progress.worked(5);
                            this.stream.write(buffer, 0, this.read);
                        }
                    }
                    finally {
                        try {
                            if (this.stream != null) {
                                this.stream.flush();
                                this.stream.close();
                            }
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException t) {
                            t.printStackTrace();
                        }
                        monitor.done();
                    }
                }
                catch (Throwable t) {
                    if (monitor.isCanceled()) break block16;
                    return CoreExceptionUtils.getErrorStatus((String)t.getMessage(), (Throwable)t);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

