/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.parameters;

import java.util.HashMap;
import java.util.Map;

public class Parameters
implements Cloneable {
    private Map<String, Parameter> params = new HashMap<String, Parameter>();

    public Parameter addParameter(Parameter param) {
        this.params.put(param.getName(), param);
        return param;
    }

    public Parameter addParameter(String name) {
        Parameter param = new Parameter(name);
        this.params.put(name, param);
        return param;
    }

    public Parameters clone() throws CloneNotSupportedException {
        Parameters newParams = new Parameters();
        Parameter[] parameterArray = this.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            newParams.addParameter(param.clone());
            ++n2;
        }
        return newParams;
    }

    public Parameter getParameter(String name) {
        return this.params.get(name);
    }

    public int getParameterCount() {
        return this.params.size();
    }

    public Parameter[] getParameters() {
        return this.params.values().toArray(new Parameter[this.params.size()]);
    }

    public class Parameter
    implements Cloneable {
        private String name;
        private String value = "";
        private String help = "";
        private boolean readOnly = false;

        public Parameter(String name) {
            this.name = name;
        }

        public Parameter clone() throws CloneNotSupportedException {
            Parameter param = new Parameter(this.name);
            param.setValue(this.value);
            param.setHelp(this.help);
            param.setReadOnly(this.readOnly);
            return param;
        }

        public String getHelp() {
            return this.help;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setHelp(String help) {
            this.help = help;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.getName();
        }
    }
}

