/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OpenMPI130InputStream
extends FilterInputStream {
    private static final int PROLOG = 0;
    private static final int START_TAG = 1;
    private static final int XML = 2;
    private static final int EPILOG = 3;
    private int state = 0;
    private StringBuffer prolog = new StringBuffer();
    private StringBuffer epilog = new StringBuffer(6);

    protected OpenMPI130InputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int ch;
        while (this.state != 3) {
            ch = super.read();
            if (ch < 0) {
                return -1;
            }
            switch (this.state) {
                case 0: {
                    if (ch != 60) break;
                    this.state = 1;
                    this.prolog.append((char)ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case 60: {
                            this.prolog.delete(0, this.prolog.length());
                            break;
                        }
                        case 62: {
                            this.state = 2;
                            this.prolog.insert(0, "<ompi>");
                        }
                    }
                    this.prolog.append((char)ch);
                    break;
                }
                case 2: {
                    this.epilog.append((char)ch);
                    ch = this.epilog.charAt(0);
                    if (this.epilog.length() >= 6 && this.epilog.substring(this.epilog.length() - 6).equals("</map>")) {
                        this.epilog.append("</ompi>");
                        this.state = 3;
                        break;
                    }
                    if (this.prolog.length() > 0) {
                        ch = this.prolog.charAt(0);
                        this.prolog.deleteCharAt(0);
                        return ch;
                    }
                    this.epilog.deleteCharAt(0);
                    return ch;
                }
            }
        }
        if (this.prolog.length() > 0) {
            ch = this.prolog.charAt(0);
            this.prolog.deleteCharAt(0);
            return ch;
        }
        if (this.epilog.length() > 0) {
            ch = this.epilog.charAt(0);
            this.epilog.deleteCharAt(0);
            return ch;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int pos = off;
        int i = 0;
        while (i < len && this.available() > 0) {
            int ch = this.read();
            if (ch < 0) {
                return -1;
            }
            b[pos++] = (byte)(ch & 0xFF);
            ++i;
        }
        return pos - off;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.state == 0 ? 1 : this.prolog.length() + this.epilog.length();
    }
}

