/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIHostMap {
    private final List<Host> hosts = new ArrayList<Host>();
    private final Map<String, Host> hostNameToHost = new HashMap<String, Host>();
    private boolean hasErrors = false;

    protected void addHost(Host host) {
        this.hosts.add(host);
        this.hostNameToHost.put(host.getName(), host);
    }

    public Host[] getHosts() {
        return this.hosts.toArray(new Host[this.hosts.size()]);
    }

    public Iterator<Host> getHostIterator() {
        return this.hosts.listIterator();
    }

    public Host getHostByName(String name) {
        return this.hostNameToHost.get(name);
    }

    public void addDefaultHost(String name) {
        Host host = new Host(name);
        host.setNumProcessors(1);
        host.setMaxNumProcessors(0);
        this.addHost(host);
    }

    public int count() {
        return this.hosts.size();
    }

    public boolean hasParseErrors() {
        return this.hasErrors;
    }

    public void setHasParseErrors(boolean flag) {
        this.hasErrors = flag;
    }

    public static class Host {
        public static final int NO_ERRORS = 0;
        public static final int ERR_NUM_SLOTS = 2;
        public static final int ERR_MAX_NUM_SLOTS = 4;
        public static final int ERR_UNKNOWN_ATTR = 8;
        private String name = null;
        private int numProcessors = 0;
        private int maxNumProcessors = 0;
        private int errors = 0;

        public Host(String hostname) {
            this.name = hostname;
        }

        public int getNumProcessors() {
            return this.numProcessors;
        }

        public int getMaxNumProcessors() {
            return this.maxNumProcessors;
        }

        public String getName() {
            return this.name;
        }

        public int getErrors() {
            return this.errors;
        }

        public void setNumProcessors(int numProcessors) {
            this.numProcessors = numProcessors;
        }

        public void setMaxNumProcessors(int maxNumProcessors) {
            this.maxNumProcessors = maxNumProcessors;
        }

        public void addErrors(int errors) {
            this.errors |= errors;
        }
    }
}

