/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPINodeAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.IOpenMPIProcessMapParserListener;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenMPIProcessMapXml13Parser {
    private static final String rootTag = "mpirun";
    private static final String mapTag = "map";
    private static final String hostTag = "host";
    private static final String processTag = "process";
    private static final String nodeResolveTag = "noderesolve";
    private static final String stdoutTag = "stdout";
    private static final String stderrTag = "stderr";
    private static final String stddiagTag = "stddiag";
    private static final String nameAttribute = "name";
    private static final String resolvedAttribute = "resolved";
    private static final String rankAttribute = "rank";
    private static final String slotsAttribute = "slots";
    private static final String maxSlotsAttribute = "max_slots";
    protected final OpenMPIProcessMap map = new OpenMPIProcessMap();
    protected final StackContextHandler handler = new StackContextHandler(new DocumentHandler());
    protected final ListenerList listeners = new ListenerList();

    private OpenMPIProcessMapXml13Parser() {
    }

    public static void parse(InputStream is) throws IOException {
        OpenMPIProcessMapXml13Parser.parse(is, null);
    }

    public static void parse(InputStream is, IOpenMPIProcessMapParserListener listener) throws IOException {
        OpenMPIProcessMapXml13Parser parser = new OpenMPIProcessMapXml13Parser();
        if (listener != null) {
            parser.addListener(listener);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)parser.handler);
        }
        catch (ParseInterruptedException parseInterruptedException) {
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void addListener(IOpenMPIProcessMapParserListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IOpenMPIProcessMapParserListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void notifyStart() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IOpenMPIProcessMapParserListener)listener).start();
            }
            catch (Exception e) {
                OpenMPIPlugin.log(e);
            }
            ++n2;
        }
    }

    protected void notifyFinish() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IOpenMPIProcessMapParserListener)listener).finish();
            }
            catch (Exception e) {
                OpenMPIPlugin.log(e);
            }
            ++n2;
        }
    }

    protected void notifyFinishMap(AttributeManager manager) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IOpenMPIProcessMapParserListener)listener).finishMap(manager);
            }
            catch (Exception e) {
                OpenMPIPlugin.log(e);
            }
            ++n2;
        }
    }

    protected void notifyNewProcess(OpenMPIProcessMap.Process proc) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IOpenMPIProcessMapParserListener)listener).newProcess(proc);
            }
            catch (Exception e) {
                OpenMPIPlugin.log(e);
            }
            ++n2;
        }
    }

    protected void notifyStdout(OpenMPIProcessMap.Process process, String output) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IOpenMPIProcessMapParserListener)listener).stdout(process, output);
            }
            catch (Exception e) {
                OpenMPIPlugin.log(e);
            }
            ++n2;
        }
    }

    protected void notifyStderr(OpenMPIProcessMap.Process process, String output) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IOpenMPIProcessMapParserListener)listener).stderr(process, output);
            }
            catch (Exception e) {
                OpenMPIPlugin.log(e);
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("xml_sample.txt");
            OpenMPIProcessMapXml13Parser.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract class ContextHandler {
        public ContextHandler newElement(String name) throws SAXException {
            throw new UnknownElementException(name);
        }

        public void start() throws SAXException {
        }

        public void setAttribute(String name, String value) throws SAXException {
            throw new UnknownAttributeException(name);
        }

        public void prepare() throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void finish() throws SAXException {
        }
    }

    public class DocumentHandler
    extends ContextHandler {
        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.rootTag)) {
                return new RootHandler();
            }
            return super.newElement(name);
        }
    }

    public class HostHandler
    extends ContextHandler {
        private String name;
        private boolean has_num_slots = false;
        private boolean has_max_slots = false;
        private int num_slots = 0;
        private int max_slots = 0;
        private OpenMPIProcessMap.Node node;
        private List<OpenMPIProcessMap.Process> processes = new ArrayList<OpenMPIProcessMap.Process>();

        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.processTag)) {
                return new ProcessHandler(this.node);
            }
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.nodeResolveTag)) {
                return new NodeResolveHandler(this.node);
            }
            return super.newElement(name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setAttribute(String name, String value) throws SAXException {
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.nameAttribute)) {
                this.name = value;
                return;
            } else if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.slotsAttribute)) {
                try {
                    this.num_slots = Integer.parseInt(value);
                    if (this.num_slots < 0) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                    this.has_num_slots = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidIntegerAttributeException(name, value);
                }
            } else if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.maxSlotsAttribute)) {
                try {
                    this.max_slots = Integer.parseInt(value);
                    if (this.max_slots < 0) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                    if (this.max_slots == 0) return;
                    this.has_max_slots = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidIntegerAttributeException(name, value);
                }
            } else {
                super.setAttribute(name, value);
            }
        }

        public void prepare() throws SAXException {
            if (this.name == null) {
                throw new MissingAttributeException(OpenMPIProcessMapXml13Parser.nameAttribute);
            }
            if (!this.has_num_slots) {
                throw new MissingAttributeException(OpenMPIProcessMapXml13Parser.slotsAttribute);
            }
            this.node = OpenMPIProcessMapXml13Parser.this.map.getNode(this.name);
            if (this.node == null) {
                this.node = new OpenMPIProcessMap.Node(this.name);
                OpenMPIProcessMapXml13Parser.this.map.addNode(this.node);
            }
            try {
                this.node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getNumberOfNodesAttributeDefinition().create(Integer.valueOf(this.num_slots)));
            }
            catch (IllegalValueException e) {
                OpenMPIPlugin.log(e);
            }
            if (this.has_max_slots) {
                try {
                    this.node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getMaximalNumberOfNodesAttributeDefinition().create(Integer.valueOf(this.max_slots)));
                }
                catch (IllegalValueException e) {
                    OpenMPIPlugin.log(e);
                }
            }
            super.prepare();
        }

        public void finish() throws SAXException {
            assert (this.node != null);
            this.node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getOversubscribedAttributeDefinition().create(Boolean.valueOf(this.processes.size() > this.num_slots)));
            super.finish();
        }
    }

    public class InvalidIntegerAttributeException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public InvalidIntegerAttributeException(String name, String value) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_AttributeNotInteger, (Object)name, (Object)value));
        }
    }

    public class MapHandler
    extends ContextHandler {
        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.hostTag)) {
                return new HostHandler();
            }
            return super.newElement(name);
        }

        public void finish() throws SAXException {
            OpenMPIProcessMapXml13Parser.this.notifyFinishMap(OpenMPIProcessMapXml13Parser.this.map.getAttributeManager());
        }
    }

    public class MissingAttributeException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public MissingAttributeException(String name) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_MissingAttribute, (Object)name));
        }
    }

    public class NodeResolveHandler
    extends ContextHandler {
        private OpenMPIProcessMap.Node node;

        public NodeResolveHandler(OpenMPIProcessMap.Node node) {
            this.node = node;
        }

        public void setAttribute(String name, String value) throws SAXException {
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.resolvedAttribute)) {
                this.node.addResolvedName(value);
            } else {
                super.setAttribute(name, value);
            }
        }
    }

    public abstract class OutputHandler
    extends ContextHandler {
        private OpenMPIProcessMap.Process process = null;
        private StringBuffer content = new StringBuffer();

        public void setAttribute(String name, String value) throws SAXException {
            block5: {
                if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.rankAttribute)) {
                    try {
                        int rank = Integer.parseInt(value);
                        if (rank < 0) {
                            throw new InvalidIntegerAttributeException(name, value);
                        }
                        this.process = OpenMPIProcessMapXml13Parser.this.map.getProcesses().get(rank);
                        if (this.process == null) {
                            throw new InvalidIntegerAttributeException(name, value);
                        }
                        break block5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                }
                super.setAttribute(name, value);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content.append(ch, start, length);
        }

        public OpenMPIProcessMap.Process getProcess() {
            return this.process;
        }

        public String getOutput() {
            return new String(this.content);
        }
    }

    public class ParseInterruptedException
    extends SAXException {
        private static final long serialVersionUID = 1L;
    }

    public class ProcessHandler
    extends ContextHandler {
        private OpenMPIProcessMap.Node node;
        private int rank;

        public ProcessHandler(OpenMPIProcessMap.Node node) {
            this.node = node;
        }

        public void setAttribute(String name, String value) throws SAXException {
            block4: {
                if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.rankAttribute)) {
                    try {
                        this.rank = Integer.parseInt(value);
                        if (this.rank < 0) {
                            throw new InvalidIntegerAttributeException(name, value);
                        }
                        break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                }
                super.setAttribute(name, value);
            }
        }

        public void finish() throws SAXException {
            OpenMPIProcessMap.Process process = new OpenMPIProcessMap.Process(this.node, this.rank, 1);
            OpenMPIProcessMapXml13Parser.this.map.addProcess(process);
            OpenMPIProcessMapXml13Parser.this.notifyNewProcess(process);
            super.finish();
        }
    }

    public class RootHandler
    extends ContextHandler {
        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.mapTag)) {
                return new MapHandler();
            }
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.stdoutTag)) {
                return new StdoutHandler();
            }
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.stderrTag)) {
                return new StderrHandler();
            }
            if (name.equalsIgnoreCase(OpenMPIProcessMapXml13Parser.stddiagTag)) {
                return new StddiagHandler();
            }
            return super.newElement(name);
        }

        public void finish() throws SAXException {
            super.finish();
            OpenMPIProcessMapXml13Parser.this.notifyFinish();
            throw new ParseInterruptedException();
        }
    }

    private class StackContextHandler
    extends DefaultHandler {
        Stack<ContextHandler> handlers = new Stack();

        public StackContextHandler(ContextHandler documentHandler) {
            this.handlers.push(documentHandler);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            OpenMPIProcessMapXml13Parser.this.notifyStart();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            ContextHandler handler = this.handlers.peek();
            ContextHandler childHandler = null;
            if (handler != null && (childHandler = handler.newElement(name)) != null) {
                childHandler.start();
                int i = 0;
                while (i < attributes.getLength()) {
                    String attr_name = attributes.getQName(i);
                    String attr_value = attributes.getValue(i);
                    childHandler.setAttribute(attr_name, attr_value);
                    ++i;
                }
                childHandler.prepare();
            }
            this.handlers.push(childHandler);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            ContextHandler handler = this.handlers.peek();
            handler.characters(ch, start, length);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, name);
            ContextHandler handler = this.handlers.pop();
            if (handler != null) {
                handler.finish();
            }
        }

        public void error(SAXParseException e) throws SAXException {
            super.error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            super.fatalError(e);
        }
    }

    public class StddiagHandler
    extends OutputHandler {
        public void finish() throws SAXException {
            OpenMPIProcessMapXml13Parser.this.notifyStderr(this.getProcess(), this.getOutput());
        }
    }

    public class StderrHandler
    extends OutputHandler {
        public void finish() throws SAXException {
            OpenMPIProcessMapXml13Parser.this.notifyStderr(this.getProcess(), this.getOutput());
        }
    }

    public class StdoutHandler
    extends OutputHandler {
        public void finish() throws SAXException {
            OpenMPIProcessMapXml13Parser.this.notifyStdout(this.getProcess(), this.getOutput());
        }
    }

    public class UnknownAttributeException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public UnknownAttributeException(String name) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_UnknownAttribute, (Object)name));
        }
    }

    public class UnknownElementException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public UnknownElementException(String name) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_UnknownElement, (Object)name));
        }
    }
}

