/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.core.rmsystem;

import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.slurm.core.rmsystem.ISLURMResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;

public class SLURMResourceManagerConfiguration
extends AbstractRemoteResourceManagerConfiguration
implements ISLURMResourceManagerConfiguration {
    private static final String TAG_SLURMD_PATH = "slurmdPath";
    private static final String TAG_SLURMD_ARGS = "slurmdArgs";
    private static final String TAG_SLURMD_DEFAULTS = "slurmdDefaults";
    public static final String EMPTY_STRING = "";

    public SLURMResourceManagerConfiguration(String namespace, IServiceProvider provider) {
        super(namespace, provider);
        this.setDescription("SLURM Resource Manager");
    }

    public String getSlurmdArgs() {
        return this.getString(TAG_SLURMD_ARGS, EMPTY_STRING);
    }

    public String getSlurmdPath() {
        return EMPTY_STRING;
    }

    public boolean getUseDefaults() {
        return this.getBoolean(TAG_SLURMD_DEFAULTS, true);
    }

    public boolean isConfigured() {
        return true;
    }

    public boolean needsDebuggerLaunchHelp() {
        return false;
    }

    public void setDefaultNameAndDesc() {
        String name = "SLURM";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals(EMPTY_STRING)) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("SLURM Resource Manager");
    }

    public void setSlurmdArgs(String slurmdArgs) {
        this.putString(TAG_SLURMD_ARGS, slurmdArgs);
    }

    public void setSlurmdPath(String slurmdPath) {
        this.putString(TAG_SLURMD_PATH, slurmdPath);
    }

    public void setUseDefaults(boolean useDefaults) {
        this.putBoolean(TAG_SLURMD_DEFAULTS, useDefaults);
    }
}

