/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.rm.core.RMPreferenceConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractRemoteRMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
RMPreferenceConstants {
    public static final String EMPTY_STRING = "";
    protected Button fNoneButton = null;
    protected Button fPortForwardingButton = null;
    protected Button fManualButton = null;
    protected WidgetListener listener = new WidgetListener();

    public void dispose() {
        super.dispose();
    }

    public abstract String getPreferenceQualifier();

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    public boolean performOk() {
        this.savePreferences();
        return true;
    }

    public abstract void savePreferences();

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    private Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.defaultSetting();
        return composite;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected void defaultSetting() {
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected boolean isValidSetting() {
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidSetting()) {
            return;
        }
        this.setValid(true);
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                AbstractRemoteRMPreferencePage.this.updatePreferencePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractRemoteRMPreferencePage.this.updatePreferencePage();
        }
    }
}

