/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.utils;

import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;

public class DebugUtil {
    private static final String DATASOURCE_OPTION = "org.eclipse.ptp.rm.ui/debug/dataSource";
    private static final String LISTENER_OPTION = "org.eclipse.ptp.rm.core/debug/widgetListener";
    public static boolean DATASOURCE_TRACING = false;
    public static boolean LISTENER_TRACING = false;

    public static void configurePluginDebugOptions() {
        if (PTPCorePlugin.getDefault().isDebugging()) {
            String option = Platform.getDebugOption((String)DATASOURCE_OPTION);
            if (option != null) {
                DATASOURCE_TRACING = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)LISTENER_OPTION)) != null) {
                LISTENER_TRACING = option.equalsIgnoreCase("true");
            }
        }
    }

    public static void trace(boolean option, String pattern, Object ... arguments) {
        DebugUtil.trace(option, NLS.bind((String)pattern, (Object[])arguments));
    }

    public static void trace(boolean option, String message) {
        if (option) {
            System.out.println(message);
            System.out.flush();
        }
    }

    public static void error(boolean option, String pattern, Object ... arguments) {
        DebugUtil.error(option, NLS.bind((String)pattern, (Object[])arguments));
    }

    public static void error(boolean option, String message) {
        if (option) {
            System.err.println(message);
        }
    }
}

