/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.ptp.services.ui.widgets.ServiceProviderConfigurationWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ServiceProviderConfigurationDialog
extends Dialog {
    private ServiceProviderConfigurationWidget fServiceModelWidget;
    private IServiceConfiguration fConfig;
    private Control fDialogControl;
    private Point fDialogSize;
    private Text fNameText;

    public ServiceProviderConfigurationDialog(IShellProvider parentShell, IServiceConfiguration config) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fConfig = config;
    }

    public ServiceProviderConfigurationDialog(Shell parentShell, IServiceConfiguration config) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fConfig = config;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ServiceProviderConfigurationDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite textArea = new Composite(dialogArea, 0);
        GridLayout textLayout = new GridLayout(2, false);
        textLayout.marginWidth = 0;
        textArea.setLayout((Layout)textLayout);
        GridData textAreaData = new GridData(4, 4, true, false);
        textArea.setLayoutData((Object)textAreaData);
        Label nameLabel = new Label(textArea, 0);
        nameLabel.setText(Messages.ServiceProviderConfigurationDialog_0);
        this.fNameText = new Text(textArea, 2048);
        this.fNameText.setText(this.fConfig.getName());
        GridData textData = new GridData(4, 4, true, true);
        this.fNameText.setLayoutData((Object)textData);
        this.fServiceModelWidget = new ServiceProviderConfigurationWidget(dialogArea, 0);
        this.fServiceModelWidget.setServiceConfiguration(this.fConfig);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 400;
        this.fServiceModelWidget.setLayoutData(data);
        this.fServiceModelWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceProviderConfigurationDialog.this.resizeDialog();
            }
        });
        return this.fServiceModelWidget;
    }

    protected Control createContents(Composite parent) {
        this.fDialogControl = super.createContents(parent);
        this.fDialogSize = this.fDialogControl.computeSize(-1, -1);
        return this.fDialogControl;
    }

    protected void okPressed() {
        this.fServiceModelWidget.applyChangesToConfiguration();
        String name = this.fNameText.getText();
        if (!name.equals("")) {
            this.fConfig.setName(name);
        }
        super.okPressed();
    }

    private void resizeDialog() {
        Point p = this.fDialogControl.computeSize(-1, -1);
        if (p.x > this.fDialogSize.x || p.y > this.fDialogSize.y) {
            this.getShell().setSize(p);
            this.fDialogSize = p;
        }
    }
}

