/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.widgets;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceCategory;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.internal.core.ServiceConfiguration;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.ptp.services.ui.ServiceModelUIManager;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderConfigurationWidget
extends Composite {
    private static final String SERVICE_KEY = "service";
    private static final String DISABLED_KEY = "disabled";
    private static final String PROVIDER_KEY = "provider";
    private IServiceConfiguration configuration;
    private final Tree servicesTree;
    private final Button enabledCheckbox;
    private final Combo providerCombo;
    private final Composite configurationComposite;
    private final Group providerComposite;
    private final StackLayout stackLayout;
    private final Image enabledIcon;
    private final Image disabledIcon;
    private final Image configIcon;
    private final ListenerList fSelectionListeners = new ListenerList();
    private static Comparator<IServiceCategory> CATEGORY_COMPARATOR = new Comparator<IServiceCategory>(){

        @Override
        public int compare(IServiceCategory x, IServiceCategory y) {
            return x.getName().compareTo(y.getName());
        }
    };
    private static Comparator<IService> SERVICE_COMPARATOR = new Comparator<IService>(){

        @Override
        public int compare(IService x, IService y) {
            return ServiceProviderConfigurationWidget.comparePriorities(x.getPriority(), y.getPriority(), x.getName(), y.getName());
        }
    };
    private static Comparator<IServiceProviderDescriptor> PROVIDER_COMPARATOR = new Comparator<IServiceProviderDescriptor>(){

        @Override
        public int compare(IServiceProviderDescriptor x, IServiceProviderDescriptor y) {
            return ServiceProviderConfigurationWidget.comparePriorities(x.getPriority(), y.getPriority(), x.getName(), y.getName());
        }
    };

    private static int comparePriorities(Integer p1, Integer p2, String name1, String name2) {
        if (p1 == null && p2 == null) {
            return name1.compareTo(name2);
        }
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        if (p1.equals(p2)) {
            return name1.compareTo(name2);
        }
        return p1.compareTo(p2);
    }

    private static boolean filterOut(Set<String> serviceIds, Set<String> filterIds) {
        if (serviceIds.isEmpty() || filterIds.isEmpty()) {
            return false;
        }
        for (String id : serviceIds) {
            if (!filterIds.contains(id)) continue;
            return false;
        }
        return true;
    }

    public ServiceProviderConfigurationWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout bodyLayout = new GridLayout(2, false);
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        this.setLayout((Layout)bodyLayout);
        Label label = new Label((Composite)this, 0);
        GridData labelData = new GridData(4, 128, true, false);
        labelData.horizontalSpan = 2;
        label.setLayoutData((Object)labelData);
        label.setText(Messages.ServiceProviderConfigurationWidget_0);
        this.servicesTree = new Tree((Composite)this, 2052);
        GridData servicesTreeData = new GridData(4, 4, false, true);
        servicesTreeData.widthHint = 150;
        this.servicesTree.setLayoutData((Object)servicesTreeData);
        this.servicesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = ServiceProviderConfigurationWidget.this.servicesTree.getSelection();
                TreeItem item = null;
                if (items.length > 0) {
                    item = items[0];
                }
                ServiceProviderConfigurationWidget.this.displayService(item);
                ServiceProviderConfigurationWidget.this.notifySelection(e);
            }
        });
        this.providerComposite = new Group((Composite)this, 16);
        this.providerComposite.setLayout((Layout)new GridLayout(1, false));
        this.providerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite selectionComposite = new Composite((Composite)this.providerComposite, 0);
        selectionComposite.setLayout((Layout)new GridLayout(1, false));
        selectionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.enabledCheckbox = new Button(selectionComposite, 32);
        this.enabledCheckbox.setText(Messages.ServiceProviderConfigurationWidget_1);
        this.enabledCheckbox.setLayoutData((Object)new GridData());
        this.enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = ServiceProviderConfigurationWidget.this.enabledCheckbox.getSelection();
                ServiceProviderConfigurationWidget.this.changeServiceState(!checked);
            }
        });
        this.enabledCheckbox.setEnabled(false);
        Label provider = new Label(selectionComposite, 0);
        provider.setText(Messages.ServiceProviderConfigurationWidget_2);
        provider.setLayoutData((Object)new GridData());
        provider.setEnabled(false);
        this.providerCombo = new Combo(selectionComposite, 12);
        GridData providerComboData = new GridData(4, 4, true, true);
        providerComboData.widthHint = 200;
        this.providerCombo.setLayoutData((Object)providerComboData);
        this.providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServiceProviderDescriptor[] descriptors = (IServiceProviderDescriptor[])ServiceProviderConfigurationWidget.this.providerCombo.getData();
                ServiceProviderConfigurationWidget.this.selectProvider(descriptors[ServiceProviderConfigurationWidget.this.providerCombo.getSelectionIndex()]);
            }
        });
        this.providerCombo.setEnabled(false);
        Label separator = new Label(selectionComposite, 266);
        separator.setLayoutData((Object)new GridData(768));
        this.configurationComposite = new Composite((Composite)this.providerComposite, 0);
        GridData configurationCompositeData = new GridData(1808);
        configurationCompositeData.horizontalSpan = 2;
        this.configurationComposite.setLayoutData((Object)configurationCompositeData);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.configurationComposite.setLayout((Layout)this.stackLayout);
        this.enabledIcon = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/etool16/service.gif"));
        this.disabledIcon = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/etool16/service-disabled.gif"));
        this.configIcon = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/etool16/service-category.gif"));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ServiceProviderConfigurationWidget.this.enabledIcon.dispose();
                ServiceProviderConfigurationWidget.this.disabledIcon.dispose();
                ServiceProviderConfigurationWidget.this.configIcon.dispose();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public void applyChangesToConfiguration() {
        if (this.configuration == null) {
            return;
        }
        TreeItem[] treeItemArray = this.servicesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem categoryTreeItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = categoryTreeItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem serviceTreeItem = treeItemArray2[n4];
                IService service = (IService)serviceTreeItem.getData(SERVICE_KEY);
                boolean disabled = Boolean.TRUE.equals(serviceTreeItem.getData(DISABLED_KEY));
                if (disabled) {
                    this.configuration.disable(service);
                } else {
                    IServiceProviderWorkingCopy serviceProvider = (IServiceProviderWorkingCopy)serviceTreeItem.getData(PROVIDER_KEY);
                    if (serviceProvider != null) {
                        IServiceProvider current;
                        if (serviceProvider.isDirty()) {
                            serviceProvider.save();
                        }
                        if ((current = this.configuration.getServiceProvider(service)) == null || !current.getId().equals(serviceProvider.getId())) {
                            this.configuration.setServiceProvider(service, serviceProvider.getOriginal());
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IServiceConfiguration getServiceConfiguration() {
        return this.configuration;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setServiceConfiguration(IServiceConfiguration conf) {
        this.setServiceConfiguration(conf, null);
    }

    public void setServiceConfiguration(IServiceConfiguration configuration, Set<String> natureIds) {
        this.configuration = configuration;
        this.createTreeContent(natureIds);
        this.displayService(null);
    }

    private TreeItem createTreeCategory(Tree parent, IServiceCategory category) {
        TreeItem item = new TreeItem(this.servicesTree, 0);
        item.setText(category == null ? Messages.ServiceProviderConfigurationWidget_3 : category.getName());
        item.setImage(this.configIcon);
        return item;
    }

    private void createTreeContent(Set<String> filterNatureIds) {
        this.servicesTree.removeAll();
        if (this.configuration == null) {
            return;
        }
        if (filterNatureIds == null) {
            filterNatureIds = Collections.emptySet();
        }
        TreeSet<IService> defaultCategoryServices = new TreeSet<IService>(SERVICE_COMPARATOR);
        TreeMap<IServiceCategory, TreeSet<IService>> categoryServices = new TreeMap<IServiceCategory, TreeSet<IService>>(CATEGORY_COMPARATOR);
        for (IService iService : ServiceModelManager.getInstance().getServices()) {
            if (ServiceProviderConfigurationWidget.filterOut(iService.getNatures(), filterNatureIds)) continue;
            IServiceCategory category = iService.getCategory();
            if (category == null) {
                defaultCategoryServices.add(iService);
                continue;
            }
            TreeSet<IService> services = (TreeSet<IService>)categoryServices.get(category);
            if (services == null) {
                services = new TreeSet<IService>(SERVICE_COMPARATOR);
                categoryServices.put(category, services);
            }
            services.add(iService);
        }
        for (Map.Entry entry : categoryServices.entrySet()) {
            TreeItem parent = this.createTreeCategory(this.servicesTree, (IServiceCategory)entry.getKey());
            for (IService service : (SortedSet)entry.getValue()) {
                this.createTreeService(parent, service);
            }
            parent.setExpanded(true);
        }
        if (!defaultCategoryServices.isEmpty()) {
            TreeItem treeItem = this.createTreeCategory(this.servicesTree, null);
            for (IService service : defaultCategoryServices) {
                this.createTreeService(treeItem, service);
            }
            treeItem.setExpanded(true);
        }
    }

    private void createTreeService(TreeItem parent, IService service) {
        boolean disabled = this.configuration.isDisabled(service);
        TreeItem child = new TreeItem(parent, 0);
        child.setText(service.getName());
        child.setData(SERVICE_KEY, (Object)service);
        child.setData(DISABLED_KEY, (Object)disabled);
        child.setImage(disabled ? this.disabledIcon : this.enabledIcon);
    }

    private void displayService(TreeItem serviceTreeItem) {
        if (serviceTreeItem != null) {
            IService service = (IService)serviceTreeItem.getData(SERVICE_KEY);
            IServiceProvider provider = (IServiceProvider)serviceTreeItem.getData(PROVIDER_KEY);
            this.providerCombo.removeAll();
            this.enabledCheckbox.setEnabled(false);
            this.stackLayout.topControl = null;
            this.configurationComposite.layout();
            if (service == null) {
                return;
            }
            if (provider == null && !this.configuration.isDisabled(service)) {
                provider = this.configuration.getServiceProvider(service);
            }
            boolean disabled = Boolean.TRUE.equals(serviceTreeItem.getData(DISABLED_KEY));
            Set providers = service.getProviders();
            if (providers.size() != 0) {
                IServiceProviderDescriptor[] descriptors = providers.toArray(new IServiceProviderDescriptor[0]);
                Arrays.sort(descriptors, PROVIDER_COMPARATOR);
                int selection = 0;
                int i = 0;
                while (i < descriptors.length) {
                    this.providerCombo.add(descriptors[i].getName());
                    if (provider != null && provider.getId().equals(descriptors[i].getId())) {
                        selection = i;
                    }
                    ++i;
                }
                this.providerCombo.setData((Object)descriptors);
                this.providerCombo.select(selection);
                if (!disabled) {
                    this.selectProvider(descriptors[selection]);
                }
            }
            this.providerCombo.setEnabled(!disabled);
            this.enabledCheckbox.setSelection(!disabled);
            this.enabledCheckbox.setEnabled(true);
        }
    }

    private IServiceProvider getExistingProvider(String providerId, IService service) {
        IServiceProvider setProvider = this.configuration.getServiceProvider(service);
        if (setProvider != null && providerId.equals(setProvider.getId())) {
            return setProvider;
        }
        if (this.configuration instanceof ServiceConfiguration) {
            for (IServiceProvider formerProvider : ((ServiceConfiguration)this.configuration).getFormerServiceProviders(service)) {
                if (!providerId.equals(formerProvider.getId())) continue;
                return formerProvider;
            }
        }
        return null;
    }

    private void notifySelection(SelectionEvent e) {
        Event newEvent = new Event();
        newEvent.item = e.item;
        newEvent.x = e.x;
        newEvent.y = e.y;
        newEvent.width = e.width;
        newEvent.height = e.height;
        newEvent.detail = e.detail;
        newEvent.stateMask = e.stateMask;
        newEvent.text = e.text;
        newEvent.doit = e.doit;
        newEvent.widget = this;
        SelectionEvent event = new SelectionEvent(newEvent);
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SelectionListener)listener).widgetSelected(event);
            ++n2;
        }
    }

    private void selectProvider(IServiceProviderDescriptor descriptor) {
        TreeItem serviceTreeItem = this.servicesTree.getSelection()[0];
        IServiceProviderWorkingCopy newProvider = (IServiceProviderWorkingCopy)serviceTreeItem.getData(PROVIDER_KEY);
        if (newProvider == null || !newProvider.getId().equals(descriptor.getId())) {
            IService service = (IService)serviceTreeItem.getData(SERVICE_KEY);
            IServiceProvider existingProvider = this.getExistingProvider(descriptor.getId(), service);
            if (existingProvider == null) {
                existingProvider = ServiceModelManager.getInstance().getServiceProvider(descriptor);
            }
            newProvider = existingProvider.copy();
            serviceTreeItem.setData(PROVIDER_KEY, (Object)newProvider);
        }
        Composite comp = new Composite(this.configurationComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        ServiceModelUIManager uim = ServiceModelUIManager.getInstance();
        IServiceProviderContributor contributor = uim.getServiceProviderContributor(descriptor);
        if (contributor != null) {
            IWizard wizard;
            contributor.configureServiceProvider(newProvider, comp);
            if (comp.getChildren().length == 0 && (wizard = contributor.getWizard((IServiceProvider)newProvider, null)) != null) {
                Button button = new Button(comp, 8);
                button.setText(Messages.ServiceProviderConfigurationWidget_4);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        WizardDialog dialog = new WizardDialog(ServiceProviderConfigurationWidget.this.getShell(), wizard);
                        dialog.open();
                    }
                });
            }
        }
        this.stackLayout.topControl = comp;
        this.configurationComposite.layout();
    }

    protected void changeServiceState(boolean disabled) {
        TreeItem serviceTreeItem = this.servicesTree.getSelection()[0];
        serviceTreeItem.setData(DISABLED_KEY, (Object)disabled);
        serviceTreeItem.setImage(disabled ? this.disabledIcon : this.enabledIcon);
        this.displayService(serviceTreeItem);
    }
}

