/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.ui.swt;

import org.eclipse.ptp.utils.ui.messages.Messages;
import org.eclipse.ptp.utils.ui.swt.DirectoryButtonSelectionListener;
import org.eclipse.ptp.utils.ui.swt.FileButtonSelectionListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class ToolKit {
    public static Text createTextWithLabel(Composite parent, String labelString, String valueString) {
        return ToolKit.createTextWithLabel(parent, labelString, valueString, 0);
    }

    public static Text createTextWithLabel(Composite parent, String labelString, String valueString, int numberOfChars) {
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(labelString) + ":");
        Text text = new Text(parent, 2052);
        if (valueString == null) {
            valueString = "";
        }
        text.setText(valueString);
        if (numberOfChars <= 0) {
            text.setLayoutData((Object)new GridData(768));
        } else {
            GC gc = new GC((Drawable)text);
            FontMetrics fm = gc.getFontMetrics();
            int width = numberOfChars * fm.getAverageCharWidth();
            fm.getHeight();
            gc.dispose();
            GridData layout = new GridData();
            layout.widthHint = width;
            layout.minimumWidth = width;
            text.setLayoutData((Object)layout);
        }
        return text;
    }

    public static Text createPasswordWithLabel(Composite parent, String labelString, String valueString) {
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(labelString) + ":");
        Text text = new Text(parent, 0x400804);
        if (valueString == null) {
            valueString = "";
        }
        text.setText(valueString);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public static Text createShortTextRow(Composite parent, String labelString, String valueString) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.numColumns = 2;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        return ToolKit.createTextWithLabel(row, labelString, valueString);
    }

    public static Text createTextRow(Composite parent, String labelString, String valueString) {
        return ToolKit.createTextRow(parent, labelString, valueString, 0);
    }

    public static Text createTextRow(Composite parent, String labelString, String valueString, int numRows) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        Text text = null;
        if (numRows == 0) {
            text = new Text(row, 2052);
            text.setLayoutData((Object)new GridData(768));
        } else {
            text = new Text(row, 2050);
            GC gc = new GC((Drawable)text);
            FontMetrics fm = gc.getFontMetrics();
            int height = fm.getHeight() * numRows;
            gc.dispose();
            GridData layout = new GridData(768);
            layout.heightHint = height;
            layout.minimumWidth = -1;
            text.setLayoutData((Object)layout);
        }
        if (valueString == null) {
            valueString = "";
        }
        text.setText(valueString);
        return text;
    }

    public static Text createFileFieldRow(Composite parent, String labelString, String valueString, String title) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite item = new Composite(row, 0);
        item.setLayout((Layout)layout);
        item.setLayoutData((Object)new GridData(768));
        Text text = new Text(item, 2052);
        if (valueString == null) {
            valueString = "";
        }
        text.setText(valueString);
        text.setLayoutData((Object)new GridData(768));
        Button button = new Button(item, 8);
        button.setText(Messages.BrowseButtonText);
        button.addSelectionListener((SelectionListener)new FileButtonSelectionListener(text, title));
        return text;
    }

    public static Text createDirectoryFieldRow(Composite parent, String labelString, String valueString, String title, String message) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite item = new Composite(row, 0);
        item.setLayout((Layout)layout);
        item.setLayoutData((Object)new GridData(768));
        Text text = new Text(item, 2052);
        if (valueString == null) {
            valueString = "";
        }
        text.setText(valueString);
        text.setLayoutData((Object)new GridData(768));
        Button button = new Button(item, 8);
        button.setText(Messages.BrowseButtonText);
        button.addSelectionListener((SelectionListener)new DirectoryButtonSelectionListener(text, title, message));
        return text;
    }

    public static Group createGroup(Composite parent, String title) {
        return ToolKit.createGroup(parent, title, 1, false);
    }

    public static Group createGroup(Composite parent, String title, int columns, boolean equalWidth) {
        GridLayout groupLayout = new GridLayout();
        groupLayout.verticalSpacing = 3;
        groupLayout.horizontalSpacing = 3;
        groupLayout.numColumns = columns;
        groupLayout.makeColumnsEqualWidth = equalWidth;
        Group group = new Group(parent, 0);
        group.setText(title);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    public static List createListBoxRow(Composite parent, String labelString) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        List combo = new List(row, 4);
        return combo;
    }

    public static Combo createShortDropDownRow(Composite parent, String labelString) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        rowLayout.numColumns = 2;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        Combo combo = new Combo(row, 12);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    public static Label createLabelRow(Composite parent, String string) {
        return ToolKit.createLabelRow(parent, string, 1);
    }

    public static Label createLabelRow(Composite parent, String string, int colSpan) {
        Label row = new Label(parent, 0);
        row.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = colSpan;
        row.setLayoutData((Object)gridData);
        return row;
    }
}

