/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.widgets.fileuploadkit;

import java.io.IOException;
import org.eclipse.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.widgets.FileUpload;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class FileUploadLCA
extends AbstractWidgetLCA {
    public static final String PROP_FILENAME = "fileName";
    static /* synthetic */ Class class$0;

    public void readData(Widget widget) {
        FileUpload fileUpload = (FileUpload)widget;
        this.readFileName(fileUpload);
    }

    public void preserveValues(Widget widget) {
        FileUpload fileUpload = (FileUpload)widget;
        ControlLCAUtil.preserveValues((Control)fileUpload);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)fileUpload);
        adapter.preserve("text", (Object)fileUpload.getText());
        adapter.preserve("image", (Object)fileUpload.getImage());
        adapter.preserve(PROP_FILENAME, (Object)fileUpload.getFileName());
    }

    public void renderInitialization(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)fileUpload);
        writer.newWidget("org.eclipse.rwt.widgets.FileUpload");
        ControlLCAUtil.writeStyleFlags((Control)fileUpload);
    }

    public void renderChanges(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        ControlLCAUtil.writeChanges((Control)fileUpload);
        FileUploadLCA.writeText(fileUpload);
        FileUploadLCA.writeImage(fileUpload);
        FileUploadLCA.writeSubmit(fileUpload);
    }

    public void renderDispose(Widget widget) throws IOException {
        FileUpload fileUpload = (FileUpload)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)fileUpload);
        writer.dispose();
    }

    private void readFileName(FileUpload fileUpload) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.widgets.IFileUploadAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFileUploadAdapter adapter = (IFileUploadAdapter)fileUpload.getAdapter((Class)clazz);
        String fileName = WidgetLCAUtil.readPropertyValue((Widget)fileUpload, PROP_FILENAME);
        if (fileName != null) {
            adapter.setFileName(fileName == "" ? null : fileName);
            SelectionEvent event = new SelectionEvent((Widget)fileUpload, null, 13);
            event.processEvent();
        }
    }

    static void writeText(FileUpload fileUpload) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)fileUpload);
        String text = fileUpload.getText();
        if (WidgetLCAUtil.hasChanged((Widget)fileUpload, "text", text, null)) {
            writer.set("text", (text = WidgetLCAUtil.escapeText(text, true)).equals("") ? null : text);
        }
    }

    static void writeImage(FileUpload fileUpload) throws IOException {
        Image image = fileUpload.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)fileUpload, "image", image, null)) {
            String imagePath = ImageFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)fileUpload);
            Rectangle bounds = image != null ? image.getBounds() : null;
            Object[] args = new Object[]{imagePath, new Integer(bounds != null ? bounds.width : 0), new Integer(bounds != null ? bounds.height : 0)};
            writer.set("image", args);
        }
    }

    static void writeSubmit(FileUpload fileUpload) throws IOException {
        IFileUploadAdapter adapter;
        String url;
        JSWriter writer = JSWriter.getWriterFor((Widget)fileUpload);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.widgets.IFileUploadAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = (adapter = (IFileUploadAdapter)fileUpload.getAdapter((Class)clazz)).getAndResetUrl()) != null) {
            writer.call("submit", new Object[]{url});
        }
    }
}

