/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treekit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeLCA
extends AbstractWidgetLCA {
    private static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_HEADER_HEIGHT = "headerHeight";
    static final String PROP_HEADER_VISIBLE = "headerVisible";
    static final String PROP_COLUMN_COUNT = "columnCount";
    static final String PROP_TREE_COLUMN = "treeColumn";
    static final String PROP_ITEM_HEIGHT = "itemHeight";
    static final String PROP_ITEM_COUNT = "itemCount";
    static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    static final String PROP_SCROLL_LEFT = "scrollLeft";
    static final String PROP_HAS_H_SCROLL_BAR = "hasHScrollBar";
    static final String PROP_HAS_V_SCROLL_BAR = "hasVScrollBar";
    static final String PROP_ITEM_METRICS = "itemMetrics";
    static final String PROP_LINES_VISIBLE = "linesVisible";
    static final String PROP_SCROLLBARS_SELECTION_LISTENER = "scrollBarsSelectionListeners";
    static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final Integer ZERO = new Integer(0);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Tree tree = (Tree)widget;
        ControlLCAUtil.preserveValues((Control)widget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)tree);
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)tree));
        adapter.preserve(PROP_HEADER_HEIGHT, (Object)new Integer(tree.getHeaderHeight()));
        adapter.preserve(PROP_HEADER_VISIBLE, (Object)tree.getHeaderVisible());
        adapter.preserve(PROP_LINES_VISIBLE, (Object)tree.getLinesVisible());
        TreeLCA.preserveItemMetrics(tree);
        adapter.preserve(PROP_COLUMN_COUNT, (Object)new Integer(tree.getColumnCount()));
        adapter.preserve(PROP_TREE_COLUMN, (Object)TreeLCA.getTreeColumn(tree));
        adapter.preserve(PROP_ITEM_HEIGHT, (Object)new Integer(tree.getItemHeight()));
        adapter.preserve(PROP_ITEM_COUNT, (Object)new Integer(tree.getItemCount()));
        adapter.preserve(PROP_SCROLL_LEFT, (Object)TreeLCA.getScrollLeft(tree));
        adapter.preserve(PROP_TOP_ITEM_INDEX, (Object)new Integer(TreeLCA.getTopItemIndex(tree)));
        adapter.preserve(PROP_HAS_H_SCROLL_BAR, (Object)TreeLCA.hasHScrollBar(tree));
        adapter.preserve(PROP_HAS_V_SCROLL_BAR, (Object)TreeLCA.hasVScrollBar(tree));
        adapter.preserve(PROP_SCROLLBARS_SELECTION_LISTENER, (Object)TreeLCA.hasScrollBarsSelectionListener(tree));
        adapter.preserve(PROP_ENABLE_CELL_TOOLTIP, (Object)new Boolean(CellToolTipUtil.isEnabledFor((Widget)tree)));
        WidgetLCAUtil.preserveCustomVariant((Widget)tree);
    }

    public void readData(Widget widget) {
        Tree tree = (Tree)widget;
        TreeLCA.readSelection(tree);
        TreeLCA.readScrollLeft(tree);
        TreeLCA.readTopItemIndex(tree);
        TreeLCA.processWidgetSelectedEvent(tree);
        TreeLCA.processWidgetDefaultSelectedEvent(tree);
        TreeLCA.readCellToolTipTextRequested(tree);
        ControlLCAUtil.processMouseEvents((Control)tree);
        ControlLCAUtil.processKeyEvents((Control)tree);
        ControlLCAUtil.processMenuDetect((Control)tree);
        WidgetLCAUtil.processHelp((Widget)tree);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        writer.newWidget("org.eclipse.rwt.widgets.Tree");
        ControlLCAUtil.writeStyleFlags((Control)tree);
        if ((tree.getStyle() & 0x10) != 0) {
            writer.set("hasNoScroll", true);
        }
        if ((tree.getStyle() & 2) != 0) {
            writer.set("hasMultiSelection", true);
        }
        if ((tree.getStyle() & 0x10000) != 0) {
            writer.set("hasFullSelection", true);
        } else {
            Rectangle textMargin = TreeLCA.getTreeAdapter(tree).getTextMargin();
            writer.set("selectionPadding", new int[]{textMargin.x, textMargin.width - textMargin.x});
        }
        if ((tree.getStyle() & 0x20) != 0) {
            writer.set("hasCheckBoxes", true);
            writer.set("checkBoxMetrics", new Object[]{new Integer(TreeLCA.getTreeAdapter(tree).getCheckLeft()), new Integer(TreeLCA.getTreeAdapter(tree).getCheckWidth())});
        }
        if ((tree.getStyle() & 0x10000000) != 0) {
            writer.set("isVirtual", true);
        }
        TreeLCA.writeIndentionWidth(tree);
    }

    public void renderChanges(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        TreeLCA.writeItemCount(tree);
        ControlLCAUtil.writeChanges((Control)tree);
        TreeLCA.writeItemHeight(tree);
        TreeLCA.writeItemMetrics(tree);
        TreeLCA.writeColumnCount(tree);
        TreeLCA.writeLinesVisible(tree);
        TreeLCA.writeTreeColumn(tree);
        TreeLCA.writeTopItem(tree);
        TreeLCA.writeScrollBars(tree);
        TreeLCA.updateSelectionListener(tree);
        TreeLCA.writeScrollBarsSelectionListener(tree);
        TreeLCA.writeHeaderHeight(tree);
        TreeLCA.writeHeaderVisible(tree);
        TreeLCA.writeScrollLeft(tree);
        TreeLCA.writeEnableCellToolTip(tree);
        TreeLCA.writeCellToolTipText(tree);
        WidgetLCAUtil.writeCustomVariant((Widget)tree);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void doRedrawFake(Control control) {
        int evtId = 11;
        ControlEvent evt = new ControlEvent((Object)control, evtId);
        evt.processEvent();
    }

    private static void processWidgetSelectedEvent(Tree tree) {
        HttpServletRequest request = ContextProvider.getRequest();
        String eventName = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)tree, eventName)) {
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            String itemId = request.getParameter(String.valueOf(eventName) + ".item");
            Item treeItem = (Item)WidgetUtil.find((Composite)tree, (String)itemId);
            String detailStr = request.getParameter(String.valueOf(eventName) + ".detail");
            int detail = "check".equals(detailStr) ? 32 : 0;
            int eventType = 13;
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            SelectionEvent event = new SelectionEvent((Widget)tree, (Widget)treeItem, eventType, bounds, stateMask, null, true, detail);
            event.processEvent();
        }
    }

    private static void processWidgetDefaultSelectedEvent(Tree tree) {
        HttpServletRequest request = ContextProvider.getRequest();
        String eventName = "org.eclipse.swt.events.widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)tree, eventName)) {
            String itemId = request.getParameter(String.valueOf(eventName) + ".item");
            Item treeItem = (Item)WidgetUtil.find((Composite)tree, (String)itemId);
            int eventType = 14;
            SelectionEvent event = new SelectionEvent((Widget)tree, (Widget)treeItem, eventType);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }

    private static void readSelection(Tree tree) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)tree, "selection");
        if (value != null) {
            String[] values = value.split(",");
            TreeItem[] selectedItems = new TreeItem[values.length];
            boolean validItemFound = false;
            int i = 0;
            while (i < values.length) {
                selectedItems[i] = (TreeItem)WidgetUtil.find((Composite)tree, (String)values[i]);
                if (selectedItems[i] != null) {
                    validItemFound = true;
                }
                ++i;
            }
            if (!validItemFound) {
                selectedItems = new TreeItem[]{};
            }
            tree.setSelection(selectedItems);
        }
    }

    private static void readScrollLeft(Tree tree) {
        String left = WidgetLCAUtil.readPropertyValue((Widget)tree, PROP_SCROLL_LEFT);
        if (left != null) {
            int leftOffset = TreeLCA.parsePosition(left);
            ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
            treeAdapter.setScrollLeft(leftOffset);
            TreeLCA.processScrollBarSelection(tree.getHorizontalBar(), leftOffset);
        }
    }

    private static void readTopItemIndex(Tree tree) {
        String topItemIndex = WidgetLCAUtil.readPropertyValue((Widget)tree, PROP_TOP_ITEM_INDEX);
        if (topItemIndex != null) {
            ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
            int newIndex = TreeLCA.parsePosition(topItemIndex);
            int topOffset = newIndex * tree.getItemHeight();
            treeAdapter.setTopItemIndex(newIndex);
            TreeLCA.processScrollBarSelection(tree.getVerticalBar(), topOffset);
        }
    }

    private static int parsePosition(String position) {
        int result = 0;
        try {
            result = Integer.valueOf(position);
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    private static void writeItemHeight(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = new Integer(tree.getItemHeight());
        if (WidgetLCAUtil.hasChanged((Widget)tree, PROP_ITEM_HEIGHT, newValue)) {
            writer.set(PROP_ITEM_HEIGHT, PROP_ITEM_HEIGHT, newValue, new Integer(16));
        }
    }

    private static void writeItemCount(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = new Integer(tree.getItemCount());
        writer.set(PROP_ITEM_COUNT, PROP_ITEM_COUNT, newValue, ZERO);
    }

    static void writeItemMetrics(Tree tree) throws IOException {
        ItemMetrics[] itemMetrics = TreeLCA.getItemMetrics(tree);
        if (TreeLCA.hasItemMetricsChanged(tree, itemMetrics)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            int i = 0;
            while (i < itemMetrics.length) {
                Object[] args = new Object[]{new Integer(i), new Integer(itemMetrics[i].left), new Integer(itemMetrics[i].width), new Integer(itemMetrics[i].imageLeft), new Integer(itemMetrics[i].imageWidth), new Integer(itemMetrics[i].textLeft), new Integer(itemMetrics[i].textWidth)};
                writer.set(PROP_ITEM_METRICS, args);
                ++i;
            }
        }
    }

    private static void writeIndentionWidth(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
        writer.set("indentionWidth", treeAdapter.getIndentionWidth());
    }

    private static void writeHeaderHeight(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = new Integer(tree.getHeaderHeight());
        writer.set(PROP_HEADER_HEIGHT, PROP_HEADER_HEIGHT, newValue, null);
    }

    private static void writeColumnCount(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = new Integer(tree.getColumnCount());
        if (WidgetLCAUtil.hasChanged((Widget)tree, PROP_COLUMN_COUNT, newValue)) {
            writer.set(PROP_COLUMN_COUNT, PROP_COLUMN_COUNT, newValue, ZERO);
        }
    }

    private static void writeTreeColumn(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = TreeLCA.getTreeColumn(tree);
        if (WidgetLCAUtil.hasChanged((Widget)tree, PROP_TREE_COLUMN, newValue)) {
            writer.set(PROP_TREE_COLUMN, PROP_TREE_COLUMN, newValue, ZERO);
        }
    }

    private static void writeTopItem(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = new Integer(TreeLCA.getTopItemIndex(tree));
        if (WidgetLCAUtil.hasChanged((Widget)tree, PROP_TOP_ITEM_INDEX, newValue)) {
            writer.set(PROP_TOP_ITEM_INDEX, PROP_TOP_ITEM_INDEX, newValue, ZERO);
        }
    }

    private static void writeHeaderVisible(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Boolean newValue = tree.getHeaderVisible();
        writer.set(PROP_HEADER_VISIBLE, PROP_HEADER_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void writeScrollLeft(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = TreeLCA.getScrollLeft(tree);
        writer.set(PROP_SCROLL_LEFT, PROP_SCROLL_LEFT, newValue, ZERO);
    }

    private static void writeScrollBars(Tree tree) throws IOException {
        boolean hasHChanged = WidgetLCAUtil.hasChanged((Widget)tree, PROP_HAS_H_SCROLL_BAR, TreeLCA.hasHScrollBar(tree), Boolean.FALSE);
        boolean hasVChanged = WidgetLCAUtil.hasChanged((Widget)tree, PROP_HAS_V_SCROLL_BAR, TreeLCA.hasVScrollBar(tree), Boolean.FALSE);
        if (hasHChanged || hasVChanged) {
            boolean scrollX = TreeLCA.hasHScrollBar(tree);
            boolean scrollY = TreeLCA.hasVScrollBar(tree);
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            writer.set("scrollBarsVisible", new boolean[]{scrollX, scrollY});
        }
    }

    private static void writeLinesVisible(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Boolean newValue = tree.getLinesVisible();
        writer.set(PROP_LINES_VISIBLE, PROP_LINES_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void updateSelectionListener(Tree tree) throws IOException {
        String prop = PROP_SELECTION_LISTENERS;
        Boolean newValue = SelectionEvent.hasListener((Adaptable)tree);
        if (WidgetLCAUtil.hasChanged((Widget)tree, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            writer.set("hasSelectionListeners", newValue);
        }
    }

    private static void writeScrollBarsSelectionListener(Tree tree) throws IOException {
        String prop = PROP_SCROLLBARS_SELECTION_LISTENER;
        Boolean newValue = TreeLCA.hasScrollBarsSelectionListener(tree);
        if (WidgetLCAUtil.hasChanged((Widget)tree, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            writer.set("hasScrollBarsSelectionListener", newValue);
        }
    }

    private static void writeEnableCellToolTip(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        String prop = PROP_ENABLE_CELL_TOOLTIP;
        Boolean newValue = new Boolean(CellToolTipUtil.isEnabledFor((Widget)tree));
        writer.set(prop, PROP_ENABLE_CELL_TOOLTIP, newValue, Boolean.FALSE);
    }

    private static void readCellToolTipTextRequested(Tree tree) {
        ICellToolTipProvider provider;
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter((Widget)tree);
        adapter.setToolTipText(null);
        String event = "org.eclipse.swt.events.cellToolTipTextRequested";
        if (WidgetLCAUtil.wasEventSent((Widget)tree, event) && (provider = adapter.getCellToolTipProvider()) != null) {
            HttpServletRequest request = ContextProvider.getRequest();
            String cell = request.getParameter("org.eclipse.swt.events.cellToolTipTextRequested.cell");
            String[] details = cell.split(",");
            String itemId = details[0];
            int columnIndex = NumberFormatUtil.parseInt((String)details[1]);
            TreeItem item = TreeLCA.getItemById(tree.getItems(), itemId);
            if (item != null && (columnIndex == 0 || columnIndex < tree.getColumnCount())) {
                provider.getToolTipText((Item)item, columnIndex);
            }
        }
    }

    private static void writeCellToolTipText(Tree tree) throws IOException {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter((Widget)tree);
        String text = adapter.getToolTipText();
        if (text != null) {
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            writer.call("setCellToolTipText", new String[]{text});
        }
    }

    private static TreeItem getItemById(TreeItem[] items, String itemId) {
        TreeItem result = null;
        int i = 0;
        while (i < items.length && result == null) {
            if (WidgetUtil.getId((Widget)items[i]).equals(itemId)) {
                result = items[i];
            } else if (items[i].getExpanded()) {
                result = TreeLCA.getItemById(items[i].getItems(), itemId);
            }
            ++i;
        }
        return result;
    }

    private static Integer getScrollLeft(Tree tree) {
        ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
        return new Integer(treeAdapter.getScrollLeft());
    }

    private static int getTopItemIndex(Tree tree) {
        ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
        return treeAdapter.getTopItemIndex();
    }

    private static Boolean hasHScrollBar(Tree tree) {
        ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
        return treeAdapter.hasHScrollBar();
    }

    private static Boolean hasVScrollBar(Tree tree) {
        ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
        return treeAdapter.hasVScrollBar();
    }

    private static Integer getTreeColumn(Tree tree) {
        int[] values = tree.getColumnOrder();
        return new Integer(values.length > 0 ? values[0] : 0);
    }

    private static ITreeAdapter getTreeAdapter(Tree tree) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = tree.getAdapter((Class)clazz);
        return (ITreeAdapter)adapter;
    }

    private static Boolean hasScrollBarsSelectionListener(Tree tree) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = tree.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener((Adaptable)horizontalBar);
        }
        if ((verticalBar = tree.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener((Adaptable)verticalBar);
        }
        return result;
    }

    private static void processScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
            if (SelectionEvent.hasListener((Adaptable)scrollBar)) {
                int eventId = 13;
                SelectionEvent evt = new SelectionEvent((Widget)scrollBar, null, eventId);
                evt.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
                evt.processEvent();
            }
        }
    }

    static ItemMetrics[] getItemMetrics(Tree tree) {
        int columnCount = Math.max(1, tree.getColumnCount());
        ItemMetrics[] result = new ItemMetrics[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = new ItemMetrics();
            ++i;
        }
        ITreeAdapter adapter = TreeLCA.getTreeAdapter(tree);
        int i2 = 0;
        while (i2 < columnCount) {
            result[i2].left = adapter.getCellLeft(i2);
            result[i2].width = adapter.getCellWidth(i2);
            result[i2].imageLeft = result[i2].left + adapter.getImageOffset(i2);
            result[i2].imageWidth = adapter.getItemImageSize((int)i2).x;
            result[i2].textLeft = result[i2].left + adapter.getTextOffset(i2);
            result[i2].textWidth = adapter.getTextMaxWidth(i2);
            ++i2;
        }
        return result;
    }

    private static void preserveItemMetrics(Tree tree) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)tree);
        adapter.preserve(PROP_ITEM_METRICS, (Object)TreeLCA.getItemMetrics(tree));
    }

    private static boolean hasItemMetricsChanged(Tree tree, ItemMetrics[] metrics) {
        return WidgetLCAUtil.hasChanged((Widget)tree, PROP_ITEM_METRICS, metrics);
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

