/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISessionStore;

public class ContextProvider {
    private static final ThreadLocal CONTEXT_HOLDER = new ThreadLocal();
    private static final Map CONTEXT_HOLDER_FOR_BG_THREADS = new WeakHashMap();

    public static void setContext(ServiceContext context) {
        ParamCheck.notNull(context, "context");
        if (ContextProvider.getContextInternal() != null) {
            String msg = "Current thread has already a context instance buffered.";
            throw new IllegalStateException(msg);
        }
        CONTEXT_HOLDER.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContext(ServiceContext context, Thread thread) {
        ParamCheck.notNull(context, "context");
        ParamCheck.notNull(thread, "thread");
        Map map = CONTEXT_HOLDER_FOR_BG_THREADS;
        synchronized (map) {
            if (CONTEXT_HOLDER_FOR_BG_THREADS.containsKey(thread)) {
                String msg = "The given thread has already a context instance mapped.";
                throw new IllegalStateException(msg);
            }
            CONTEXT_HOLDER_FOR_BG_THREADS.put(thread, context);
        }
    }

    public static ServiceContext getContext() {
        ServiceContext result = ContextProvider.getContextInternal();
        if (result == null) {
            String msg = "No context available outside of the request service lifecycle.";
            throw new IllegalStateException(msg);
        }
        return result;
    }

    public static HttpServletRequest getRequest() {
        return ContextProvider.getContext().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ContextProvider.getContext().getResponse();
    }

    public static ISessionStore getSession() {
        ISessionStore result = ContextProvider.getContext().getSessionStore();
        if (result == null) {
            String id;
            HttpSession httpSession = ContextProvider.getRequest().getSession(true);
            result = (ISessionStore)httpSession.getAttribute(id = SessionStoreImpl.ID_SESSION_STORE);
            if (result == null) {
                result = new SessionStoreImpl(httpSession);
                result.setAttribute(SessionSingletonBase.LOCK, new Object());
            }
            ContextProvider.getContext().setSessionStore(result);
        }
        return result;
    }

    public static IServiceStateInfo getStateInfo() {
        return ContextProvider.getContext().getStateInfo();
    }

    public static void disposeContext() {
        ServiceContext context = (ServiceContext)CONTEXT_HOLDER.get();
        if (context != null && !context.isDisposed()) {
            context.dispose();
        }
        ContextProvider.releaseContextHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseContextHolder() {
        boolean result = false;
        Object object = CONTEXT_HOLDER.get();
        if (object != null) {
            CONTEXT_HOLDER.set(null);
        } else {
            Map map = CONTEXT_HOLDER_FOR_BG_THREADS;
            synchronized (map) {
                ServiceContext toRemove = ContextProvider.getMappedContext(Thread.currentThread());
                if (toRemove != null) {
                    CONTEXT_HOLDER_FOR_BG_THREADS.remove(Thread.currentThread());
                }
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeContext(Thread thread) {
        ParamCheck.notNull(thread, "thread");
        Map map = CONTEXT_HOLDER_FOR_BG_THREADS;
        synchronized (map) {
            ServiceContext toRemove = ContextProvider.getMappedContext(thread);
            if (toRemove != null) {
                CONTEXT_HOLDER_FOR_BG_THREADS.remove(thread);
                toRemove.dispose();
            }
        }
    }

    public static boolean hasContext() {
        return ContextProvider.getContextInternal() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceContext getContextInternal() {
        ServiceContext result = (ServiceContext)CONTEXT_HOLDER.get();
        if (result == null) {
            Map map = CONTEXT_HOLDER_FOR_BG_THREADS;
            synchronized (map) {
                Thread currentThread = Thread.currentThread();
                result = ContextProvider.getMappedContext(currentThread);
            }
        }
        return result;
    }

    private static ServiceContext getMappedContext(Thread thread) {
        return (ServiceContext)CONTEXT_HOLDER_FOR_BG_THREADS.get(thread);
    }
}

