/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rwt.internal.service.ServiceStateInfo;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
implements IServiceHandler {
    public static final String RWT_INITIALIZE = "rwt_initialize";
    private static final String PATTERN_RELOAD = "qx.core.Init.getInstance().getApplication().reload( \"{0}\" )";
    static final String SESSION_INITIALIZED;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SESSION_INITIALIZED = String.valueOf(clazz.getName()) + "#isSessionInitialized";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException, ServletException {
        ISessionStore iSessionStore = ContextProvider.getSession();
        synchronized (iSessionStore) {
            this.synchronizedService();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void synchronizedService() throws IOException {
        LifeCycleServiceHandler.initializeStateInfo();
        LifeCycleServiceHandler.initializeJavaScriptResponseWriter();
        RWTRequestVersionControl.beforeService();
        try {
            if (RWTRequestVersionControl.isValid() || LifeCycleServiceHandler.isSessionRestart() || ContextProvider.getRequest().getSession().isNew()) {
                LifeCycleServiceHandler.runLifeCycle();
            } else {
                LifeCycleServiceHandler.handleInvalidRequestCounter();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            RWTRequestVersionControl.afterService();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        RWTRequestVersionControl.afterService();
    }

    public static void initializeSession() {
        if (!LifeCycleServiceHandler.isSessionInitialized() && ContextProvider.getRequest().getParameter(RWT_INITIALIZE) != null) {
            ISessionStore session = ContextProvider.getSession();
            session.setAttribute(SESSION_INITIALIZED, Boolean.TRUE);
        }
    }

    private static void runLifeCycle() throws IOException {
        LifeCycleServiceHandler.checkRequest();
        LifeCycleServiceHandler.initializeSession();
        if (LifeCycleServiceHandler.isSessionInitialized()) {
            RequestParameterBuffer.merge();
            LifeCycle lifeCycle = (LifeCycle)RWTFactory.getLifeCycleFactory().getLifeCycle();
            lifeCycle.execute();
        } else {
            Map parameters = ContextProvider.getRequest().getParameterMap();
            RequestParameterBuffer.store(parameters);
            RWTFactory.getStartupPage().send();
        }
    }

    private static boolean isSessionRestart() {
        HttpServletRequest request = ContextProvider.getRequest();
        boolean startup = request.getParameter("startup") != null;
        String uiRoot = request.getParameter("uiRoot");
        HttpSession session = request.getSession();
        return !session.isNew() && !startup && uiRoot == null || startup && LifeCycleServiceHandler.isSessionInitialized();
    }

    private static void initializeStateInfo() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        if (stateInfo == null) {
            stateInfo = new ServiceStateInfo();
            ContextProvider.getContext().setStateInfo(stateInfo);
        }
    }

    private static void initializeJavaScriptResponseWriter() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        if (stateInfo.getResponseWriter() == null) {
            HttpServletResponse response = ContextProvider.getResponse();
            response.setContentType("text/javascript");
            response.setCharacterEncoding("UTF-8");
            stateInfo.setResponseWriter(new JavaScriptResponseWriter(response.getWriter()));
        }
    }

    private static void handleInvalidRequestCounter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
        String message = RWTMessages.getMessage("RWT_MultipleInstancesError");
        Object[] args = new Object[]{message};
        responseWriter.write(MessageFormat.format(PATTERN_RELOAD, args));
    }

    private static boolean isSessionInitialized() {
        ISessionStore session = ContextProvider.getSession();
        return Boolean.TRUE.equals(session.getAttribute(SESSION_INITIALIZED));
    }

    private static void checkRequest() {
        if (LifeCycleServiceHandler.isSessionRestart()) {
            LifeCycleServiceHandler.clearSessionStore();
        }
    }

    private static void clearSessionStore() {
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSession();
        sessionStore.valueUnbound(null);
        sessionStore.valueBound(null);
        sessionStore.setAttribute(SessionSingletonBase.LOCK, new Object());
    }
}

