/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.Arrays;
import org.eclipse.rwt.internal.theme.QxType;

public class QxAnimation
implements QxType {
    public Animation[] animations = new Animation[0];

    public void addAnimation(String name, int duration, String timingFunction) {
        Animation animation = new Animation(name, duration, timingFunction);
        Animation[] newAnimations = new Animation[this.animations.length + 1];
        System.arraycopy(this.animations, 0, newAnimations, 0, this.animations.length);
        newAnimations[this.animations.length] = animation;
        this.animations = newAnimations;
    }

    public String toDefaultString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.animations.length) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(this.animations[i].name);
            result.append(" ");
            result.append(this.animations[i].duration);
            result.append("ms ");
            result.append(this.animations[i].timingFunction);
            ++i;
        }
        return result.toString();
    }

    public String toString() {
        return "QxAnimation{ " + this.toDefaultString() + " }";
    }

    public static String toCamelCaseString(String string) {
        StringBuffer result = new StringBuffer();
        boolean toUpperCase = false;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch == '-') {
                toUpperCase = true;
            } else if (toUpperCase) {
                result.append(Character.toUpperCase(ch));
                toUpperCase = false;
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public int hashCode() {
        int result = 7;
        int i = 0;
        while (i < this.animations.length) {
            result += 13 * result + this.animations[i].name.hashCode();
            result += 13 * result + this.animations[i].duration;
            result += 13 * result + this.animations[i].timingFunction.hashCode();
            ++i;
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxAnimation) {
            QxAnimation other = (QxAnimation)object;
            result = Arrays.equals(this.animations, other.animations);
        }
        return result;
    }

    public static final class Animation {
        private final String[] PREDEFINED_NAMES = new String[]{"hoverIn", "hoverOut", "fadeIn", "fadeOut", "slideIn", "slideOut"};
        private final String[] PREDEFINED_TIMING_FUNCTIONS = new String[]{"ease", "linear", "ease-in", "ease-out", "ease-in-out"};
        public final String name;
        public final int duration;
        public final String timingFunction;

        private Animation(String name, int duration, String timingFunction) {
            this.checkName(name);
            this.checkTimingFunction(timingFunction);
            this.name = name;
            this.duration = duration;
            this.timingFunction = timingFunction;
        }

        private void checkName(String name) {
            boolean result = false;
            if (name == null) {
                throw new NullPointerException("null argument");
            }
            int i = 0;
            while (i < this.PREDEFINED_NAMES.length && !result) {
                if (name.equals(this.PREDEFINED_NAMES[i])) {
                    result = true;
                }
                ++i;
            }
            if (!result) {
                String msg = "Invalid value for animation name: " + name;
                throw new IllegalArgumentException(msg);
            }
        }

        private void checkTimingFunction(String timingFunction) {
            boolean result = false;
            if (timingFunction == null) {
                throw new NullPointerException("null argument");
            }
            int i = 0;
            while (i < this.PREDEFINED_TIMING_FUNCTIONS.length && !result) {
                if (timingFunction.equals(this.PREDEFINED_TIMING_FUNCTIONS[i])) {
                    result = true;
                }
                ++i;
            }
            if (!result) {
                String msg = "Invalid value for animation timing function: " + timingFunction;
                throw new IllegalArgumentException(msg);
            }
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (object == this) {
                result = true;
            } else if (object instanceof Animation) {
                Animation other = (Animation)object;
                result = this.name.equals(other.name) && this.duration == other.duration && this.timingFunction.equals(other.timingFunction);
            }
            return result;
        }
    }
}

