/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import org.eclipse.rwt.internal.theme.QxType;

public class QxFloat
implements QxType {
    private static final QxFloat ZERO = new QxFloat(0.0f);
    private static final QxFloat ONE = new QxFloat(1.0f);
    public final float value;

    public static QxFloat create(float value) {
        QxFloat result = value == 0.0f ? ZERO : (value == 1.0f ? ONE : new QxFloat(value));
        return result;
    }

    public static QxFloat valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        return QxFloat.create(Float.parseFloat(input));
    }

    private QxFloat(float value) {
        this.value = value;
    }

    public String toDefaultString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxFloat) {
            QxFloat other = (QxFloat)object;
            result = other.value == this.value;
        }
        return result;
    }

    public String toString() {
        return "QxFloat{ " + String.valueOf(this.value) + " }";
    }
}

