/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

public final class QxTheme {
    public static final int META = 1;
    public static final int ICON = 2;
    public static final int WIDGET = 3;
    public static final int APPEARANCE = 4;
    private final String id;
    private final String title;
    private final int type;
    private final String base;
    private final StringBuffer code;
    private boolean headWritten;
    private boolean tailWritten;
    private boolean valueWritten;

    public QxTheme(String id, String title, int type, String base) {
        this.id = id;
        this.title = title;
        this.type = QxTheme.checkType(type);
        this.base = base;
        this.code = new StringBuffer();
        this.headWritten = false;
        this.tailWritten = false;
        this.valueWritten = false;
    }

    public void appendValues(String values) {
        this.beforeWriteValue();
        this.code.append(values);
        this.afterWriteValue();
    }

    public void appendUri(String pathPrefix) {
        this.beforeWriteValue();
        this.code.append("    uri : \"");
        this.code.append(pathPrefix);
        this.code.append("\"");
        this.afterWriteValue();
    }

    public void appendTheme(String key, String theme) {
        this.beforeWriteValue();
        this.code.append("    \"" + key + "\" : ");
        this.code.append(theme);
        this.afterWriteValue();
    }

    public String getJsCode() {
        if (!this.headWritten) {
            this.writeHead();
        }
        if (!this.tailWritten) {
            this.writeTail();
        }
        return this.code.toString();
    }

    private void beforeWriteValue() {
        if (!this.headWritten) {
            this.writeHead();
        }
        if (this.tailWritten) {
            throw new IllegalStateException("Tail already written");
        }
        if (this.valueWritten) {
            this.code.append(",\n");
        }
    }

    private void afterWriteValue() {
        this.valueWritten = true;
    }

    private void writeHead() {
        this.code.append("/* RAP theme file generated by QxTheme. */\n");
        this.code.append("qx.Theme.define( \"" + this.id + this.getNameSuffix() + "\",\n");
        this.code.append("{\n");
        this.code.append("  title : \"" + this.title + "\",\n");
        if (this.base != null) {
            this.code.append("  extend : " + this.base + ",\n");
        }
        this.code.append("  " + this.getThemeKey() + " : {\n");
        this.headWritten = true;
    }

    private void writeTail() {
        this.code.append("\n");
        this.code.append("  }\n");
        this.code.append("} );\n");
        this.tailWritten = true;
    }

    private static int checkType(int type) {
        if (type != 1 && type != 2 && type != 3 && type != 4) {
            throw new IllegalArgumentException("illegal type");
        }
        return type;
    }

    private String getNameSuffix() {
        String result = "";
        if (this.type == 2) {
            result = "Icons";
        } else if (this.type == 3) {
            result = "Widgets";
        } else if (this.type == 4) {
            result = "Appearances";
        }
        return result;
    }

    private String getThemeKey() {
        String result = null;
        if (this.type == 1) {
            result = "meta";
        } else if (this.type == 2) {
            result = "icons";
        } else if (this.type == 3) {
            result = "widgets";
        } else if (this.type == 4) {
            result = "appearances";
        }
        return result;
    }
}

