/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.swt.widgets.Widget;

public final class ThemeAdapterManager {
    private final Map themeAdapters = new HashMap();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThemeAdapter getThemeAdapter(Widget widget) {
        IThemeAdapter result;
        Class<?> widgetClass = widget.getClass();
        Map map = this.themeAdapters;
        synchronized (map) {
            result = (IThemeAdapter)this.themeAdapters.get(widgetClass);
            if (result == null) {
                IThemeAdapter adapter = ThemeAdapterManager.findThemeAdapter(widgetClass);
                this.themeAdapters.put(widgetClass, adapter);
                result = adapter;
            }
        }
        ThemeAdapterManager.ensureThemeAdapterWasFound(widgetClass, result);
        return result;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IThemeAdapter findThemeAdapter(Class widgetClass) {
        Class<?> clazz;
        IThemeAdapter result = null;
        Class superClass = widgetClass;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                result = ThemeAdapterManager.loadThemeAdapter(superClass);
                if (result == null) {
                    superClass = superClass.getSuperclass();
                }
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (!clazz.equals(superClass) && result == null);
        return result;
    }

    private static IThemeAdapter loadThemeAdapter(Class clazz) {
        IThemeAdapter result = null;
        String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(clazz);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(variants[i]);
            buffer.append(".");
            buffer.append(className);
            buffer.append("ThemeAdapter");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            result = ThemeAdapterManager.loadThemeAdapter(classToLoad, loader);
            ++i;
        }
        return result;
    }

    private static IThemeAdapter loadThemeAdapter(String className, ClassLoader classLoader) {
        IThemeAdapter result = null;
        try {
            result = (IThemeAdapter)ClassUtil.newInstance(classLoader, className);
        }
        catch (ClassInstantiationException classInstantiationException) {}
        return result;
    }

    private static void ensureThemeAdapterWasFound(Class widgetClass, IThemeAdapter result) {
        if (result == null) {
            String msg = "Failed to obtain theme adapter for class: " + widgetClass.getName();
            throw new ThemeManagerException(msg);
        }
    }
}

