/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.delegate;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.rap.ui.internal.launch.rwt.RWTLaunchActivator;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.util.FileUtil;

class RWTLaunch {
    private static final String PREFIX;
    private static final String PORT;
    private final ILaunch launch;
    private final RWTLaunchConfig config;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rap.ui.internal.launch.rwt.delegate.RWTLaunch");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PREFIX = clazz.getName();
        PORT = String.valueOf(PREFIX) + "#port";
    }

    RWTLaunch(ILaunch launch) {
        this.launch = launch;
        this.config = new RWTLaunchConfig(launch.getLaunchConfiguration());
    }

    RWTLaunchConfig getLaunchConfig() {
        return this.config;
    }

    void setPort(int port) {
        this.launch.setAttribute(PORT, String.valueOf(port));
    }

    int getPort() {
        return Integer.valueOf(this.launch.getAttribute(PORT));
    }

    String computeBrowserUrl() {
        String port = String.valueOf(this.getPort());
        String servletName = this.config.getUseWebXml() ? this.config.getServletPath() : "rap";
        return MessageFormat.format("http://127.0.0.1:{0}/{1}", port, servletName);
    }

    void cleanUp() {
        FileUtil.delete(this.getBasePath());
    }

    File getJettyHomePath() {
        return this.getPath("jetty-home");
    }

    File getWebAppPath() {
        return this.getPath("web-app");
    }

    File getWebXmlPath() {
        return this.getPath("web-app/WEB-INF/web.xml");
    }

    private File getPath(String suffix) {
        File basePath = this.getBasePath();
        return new File(basePath, suffix);
    }

    private File getBasePath() {
        IPath stateLocation = RWTLaunchActivator.getDefault().getStateLocation();
        IPath basePath = stateLocation.append(this.config.getName());
        return basePath.toFile();
    }
}

