/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;

public final class URLBuilder {
    private static final String EMPTY = "";
    static final String SLASH = "/";
    private static final String PROTOCOL = "http";
    private static final String HOST = "127.0.0.1";
    private static final String QUERY_STARTUP = "?startup=";
    private static final String QUERY_STARTUP_TEST = "?startup=rapjunit&testentrypoint=";

    public static String getHost() {
        return HOST;
    }

    public static String fromLaunchConfig(RAPLaunchConfig config, int port, boolean testMode) throws CoreException {
        return URLBuilder.fromLaunchConfig(config, Integer.toString(port), testMode);
    }

    public static String fromLaunchConfig(RAPLaunchConfig config, String port, boolean testMode) throws CoreException {
        String path = URLBuilder.getUrlPath(config);
        String query = URLBuilder.getUrlQuery(config, testMode);
        return "http://127.0.0.1:" + port + path + query;
    }

    private static String getUrlPath(RAPLaunchConfig config) throws CoreException {
        String contextPath = URLBuilder.getContextPath(config);
        String servletName = URLBuilder.getServletName(config);
        StringBuffer buffer = new StringBuffer();
        buffer.append(SLASH);
        if (!EMPTY.equals(contextPath)) {
            buffer.append(contextPath);
            buffer.append(SLASH);
        }
        buffer.append(servletName);
        return buffer.toString();
    }

    private static String getUrlQuery(RAPLaunchConfig config, boolean testMode) throws CoreException {
        String entryPoint = config.getEntryPoint();
        String query = EMPTY;
        if (testMode) {
            query = QUERY_STARTUP_TEST + entryPoint;
        } else if (!EMPTY.equals(entryPoint)) {
            query = QUERY_STARTUP + entryPoint;
        }
        return query;
    }

    private static String getServletName(RAPLaunchConfig config) throws CoreException {
        String servletName = config.getServletName();
        return URLBuilder.stripLeadingAndTrailingSlashes(servletName);
    }

    private static String getContextPath(RAPLaunchConfig config) throws CoreException {
        String contextPath = EMPTY;
        if (config.getUseManualContextPath()) {
            contextPath = config.getContextPath();
        }
        return URLBuilder.stripLeadingAndTrailingSlashes(contextPath);
    }

    private static String stripLeadingAndTrailingSlashes(String input) {
        String result = input;
        if (result.startsWith(SLASH)) {
            result = result.substring(1);
        }
        if (result.endsWith(SLASH)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private URLBuilder() {
    }
}

