/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rephraserengine.core.preservation.MergePreservationAnalyzer;
import org.eclipse.rephraserengine.core.preservation.Messages;
import org.eclipse.rephraserengine.core.preservation.ModelDiff;
import org.eclipse.rephraserengine.core.preservation.PreservationRuleset;
import org.eclipse.rephraserengine.core.preservation.ReplacementList;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Model<A, T, R extends IVPGNode<T>> {
    private String name;
    private EclipseVPG<A, T, R> vpg;
    private List<String> files;
    private Set<String> filesWithNoEdges;
    private Collection<VPGEdge<A, T, R>> edges;

    public Model(String name, IProgressMonitor pm, int ticks, EclipseVPG<A, T, R> vpg, String ... filenames) {
        this(name, pm, ticks, vpg, Arrays.asList(filenames));
    }

    public Model(String name, IProgressMonitor pm, int ticks, EclipseVPG<A, T, R> vpg, List<String> filenames) {
        this.name = name;
        this.vpg = vpg;
        pm.subTask(String.valueOf(Messages.Model_PreparingToCompute) + name);
        this.files = vpg.sortFilesAccordingToDependencies(new ArrayList<String>(filenames));
        this.filesWithNoEdges = new TreeSet<String>();
        pm = new SubProgressMonitor(pm, ticks, 4);
        pm.beginTask(Messages.bind((String)Messages.Model_Computing, (Object)name), this.files.size());
        this.edges = new ArrayList<VPGEdge<A, T, R>>();
        for (String thisFile : this.files) {
            pm.subTask(VPG.lastSegmentOfFilename(thisFile));
            this.addEdges(thisFile, pm);
            pm.worked(1);
        }
        pm.done();
    }

    private void addEdges(String filename, IProgressMonitor pm) {
        int count = 0;
        for (VPGEdge edge : this.vpg.getAllEdgesFor(filename)) {
            this.edges.add(edge);
            ++count;
        }
        if (count == 0) {
            this.filesWithNoEdges.add(filename);
        }
    }

    List<String> getFiles() {
        return this.files;
    }

    void inormalize(ReplacementList replacements, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask(Messages.bind((String)Messages.Model_Normalizing, (Object)this.name), this.edges.size());
        Set<VPGEdge<A, T, R>> newEdges = this.createNewEdgeSet();
        for (VPGEdge<A, T, R> e : this.edges) {
            newEdges.add(e.projectInitial(replacements, this.vpg));
            pm.worked(1);
        }
        this.edges = newEdges;
        pm.done();
    }

    void dnormalize(ReplacementList replacements, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask(Messages.bind((String)Messages.Model_Normalizing, (Object)this.name), this.edges.size());
        Set<VPGEdge<A, T, R>> newEdges = this.createNewEdgeSet();
        for (VPGEdge<A, T, R> e : this.edges) {
            newEdges.add(e.projectFinal(replacements, this.vpg));
            pm.worked(1);
        }
        this.edges = newEdges;
        pm.done();
    }

    protected Set<VPGEdge<A, T, R>> createNewEdgeSet() {
        return new TreeSet<VPGEdge<A, T, R>>();
    }

    ModelDiff checkPreservation(Model<A, T, R> that, PreservationRuleset ruleset, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask(Messages.bind((String)Messages.Model_Differencing, (Object)this.name, (Object)that.name), this.edges.size() + that.edges.size());
        ModelDiff diff = new ModelDiff();
        int type = 0;
        MergePreservationAnalyzer<A, T, R> analyzer = new MergePreservationAnalyzer<A, T, R>(this.edges, that.edges, ruleset);
        while (analyzer.hasEdgesRemaining()) {
            int edgesRemainingBefore = analyzer.countEdgesRemaining();
            VPGEdge.Classification[] classificationArray = VPGEdge.Classification.values();
            int n = classificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VPGEdge.Classification classification = classificationArray[n2];
                analyzer.checkPreservation(type, classification, diff);
                ++n2;
            }
            analyzer.ensureNoEdgesRemaining(type);
            ++type;
            pm.worked(analyzer.countEdgesRemaining() - edgesRemainingBefore);
        }
        pm.done();
        return diff;
    }

    public String toString() {
        if (this.edges.size() > 100) {
            return "(Model contains more than 100 edges)";
        }
        return this.toString(null, null, null);
    }

    public String toString(String filename, String fileContents, ArrayList<Integer> lineMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.edges.size());
        sb.append(" edges\n\n");
        TreeSet<Integer> edgeTypes = new TreeSet<Integer>();
        for (VPGEdge<A, T, R> entry : this.edges) {
            edgeTypes.add(entry.getType());
        }
        Iterator<VPGEdge<A, T, R>> iterator = edgeTypes.iterator();
        while (iterator.hasNext()) {
            int edgeType = (Integer)((Object)iterator.next());
            for (VPGEdge<A, T, R> entry : this.edges) {
                if (entry.getType() != edgeType) continue;
                if (entry.getSource() == null) {
                    sb.append("(null");
                } else {
                    if (!((IVPGNode)entry.getSource()).getFilename().equals(filename)) {
                        sb.append(((IVPGNode)entry.getSource()).getFilename());
                        sb.append(':');
                    }
                    sb.append('[');
                    sb.append(String.format("%5d", ((IVPGNode)entry.getSource()).getOffset()));
                    sb.append(", ");
                    sb.append(String.format("%5d", ((IVPGNode)entry.getSource()).getEndOffset()));
                }
                sb.append(")  ===(");
                sb.append(entry.getType());
                sb.append(")==>  ");
                if (entry.getSink() == null) {
                    sb.append("(null");
                } else {
                    if (!((IVPGNode)entry.getSink()).getFilename().equals(filename)) {
                        sb.append(((IVPGNode)entry.getSink()).getFilename());
                        sb.append(':');
                    }
                    sb.append('[');
                    sb.append(String.format("%5d", ((IVPGNode)entry.getSink()).getOffset()));
                    sb.append(", ");
                    sb.append(String.format("%5d", ((IVPGNode)entry.getSink()).getEndOffset()));
                }
                sb.append(")");
                if (fileContents != null) {
                    sb.append("           [");
                    if (entry.getSource() == null || !((IVPGNode)entry.getSource()).getFilename().equals(filename)) {
                        sb.append('?');
                    } else if (((IVPGNode)entry.getSource()).getOffset() >= 0 && ((IVPGNode)entry.getSource()).getEndOffset() >= ((IVPGNode)entry.getSource()).getOffset()) {
                        sb.append(this.extractText(fileContents, (IVPGNode<?>)entry.getSource()));
                    }
                    sb.append("]");
                    if (lineMap != null) {
                        sb.append(" (Line ");
                        sb.append(this.getLine(((IVPGNode)entry.getSource()).getOffset(), lineMap));
                        sb.append(")");
                    }
                    sb.append("  ===(");
                    sb.append(this.vpg.describeEdgeType(entry.getType()));
                    sb.append(")==>  [");
                    if (entry.getSink() == null || !((IVPGNode)entry.getSink()).getFilename().equals(filename)) {
                        sb.append('?');
                    } else if (((IVPGNode)entry.getSink()).getOffset() >= 0 && ((IVPGNode)entry.getSink()).getEndOffset() >= ((IVPGNode)entry.getSink()).getOffset()) {
                        sb.append(this.extractText(fileContents, (IVPGNode<?>)entry.getSink()));
                    }
                    sb.append("]");
                    if (lineMap != null) {
                        sb.append(" (Line ");
                        sb.append(this.getLine(((IVPGNode)entry.getSink()).getOffset(), lineMap));
                        sb.append(")");
                    }
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private String extractText(String fileContents, IVPGNode<?> tokenRef) {
        String result = fileContents.substring(tokenRef.getOffset(), tokenRef.getEndOffset());
        result = result.replace("\t", "\\t");
        result = result.replace("\r", "\\r");
        if ((result = result.replace("\n", "\\n")).length() > 17) {
            result = String.valueOf(result.substring(0, 18)) + "...";
        }
        return result;
    }

    private int getLine(int offset, ArrayList<Integer> lineMap) {
        int i = 0;
        while (i < lineMap.size()) {
            if (offset < lineMap.get(i)) {
                return i + 1;
            }
            ++i;
        }
        return lineMap.size();
    }
}

