/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TokenList<T>
implements Iterable<T> {
    private T[] array = this.internalCreateTokenArray(4096);
    private int size = 0;

    protected abstract T[] createTokenArray(int var1);

    protected abstract int getStreamOffset(T var1);

    protected abstract int getLength(T var1);

    protected abstract int getLine(T var1);

    private T[] internalCreateTokenArray(int size) {
        T[] result = this.createTokenArray(size);
        if (result.length != size) {
            throw new IllegalStateException("TokenList#createTokenArray is not implemented correctly.  It was asked to create an array of length " + size + ", but it created " + "an array of length " + result.length + " instead.");
        }
        return result;
    }

    public void add(T token) {
        this.ensureCapacity();
        this.array[this.size++] = token;
    }

    private void ensureCapacity() {
        if (this.size == this.array.length) {
            this.expandArray();
        }
    }

    private void expandArray() {
        T[] newTokenArray = this.internalCreateTokenArray(this.array.length * 2);
        System.arraycopy(this.array, 0, newTokenArray, 0, this.array.length);
        this.array = newTokenArray;
    }

    public void add(int index, T token) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        this.ensureCapacity();
        int i = this.size;
        while (i >= index) {
            this.array[i + 1] = this.array[i];
            --i;
        }
        this.array[index] = token;
        ++this.size;
    }

    public boolean remove(T tokenToRemove) {
        int index = this.find(tokenToRemove);
        return index < 0 ? false : this.remove(index);
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        int i = index + 1;
        while (i < this.size) {
            this.array[i - 1] = this.array[i];
            ++i;
        }
        --this.size;
        return true;
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        return this.array[index];
    }

    public int size() {
        return this.size;
    }

    public int find(T token) {
        int i = 0;
        while (i < this.size) {
            if (this.array[i].equals(token)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public T findTokenContainingStreamOffset(int offset) {
        int low = 0;
        int high = this.size - 1;
        int mid = (high + low) / 2;
        while (low <= high) {
            int value = this.getStreamOffset(this.array[mid]);
            if (value <= offset && offset < value + this.getLength(this.array[mid])) {
                return this.array[mid];
            }
            if (offset > value) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
            mid = (high + low) / 2;
        }
        return null;
    }

    public T findStreamOffsetLength(int offset, int length) {
        int low = 0;
        int high = this.size - 1;
        int mid = (high + low) / 2;
        while (low <= high) {
            int value = this.getStreamOffset(this.array[mid]);
            if (offset > value) {
                low = mid + 1;
            } else if (offset < value) {
                high = mid - 1;
            } else {
                return this.getLength(this.array[mid]) == length ? (T)this.array[mid] : null;
            }
            mid = (high + low) / 2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public T findFirstTokenOnLine(int line) {
        index = this.findIndexOfAnyTokenOnLine(line);
        if (index >= 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            --index;
lbl5:
            // 2 sources

            ** while (index > 0 && this.getLine(this.array[index - 1]) == line)
        }
lbl6:
        // 1 sources

        return this.array[index];
    }

    public T findFirstTokenOnOrAfterLine(int line) {
        T result = this.findFirstTokenOnLine(line);
        if (result != null) {
            return result;
        }
        int index = 0;
        while (index < this.size) {
            if (this.getLine(this.array[index]) >= line) {
                return this.array[index];
            }
            ++index;
        }
        return null;
    }

    private int findIndexOfAnyTokenOnLine(int line) {
        int low = 0;
        int high = this.size - 1;
        int mid = (high + low) / 2;
        while (low <= high) {
            int value = this.getLine(this.array[mid]);
            if (line > value) {
                low = mid + 1;
            } else if (line < value) {
                high = mid - 1;
            } else {
                return mid;
            }
            mid = (high + low) / 2;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public T findLastTokenOnLine(int line) {
        index = this.findIndexOfAnyTokenOnLine(line);
        if (index >= 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            ++index;
lbl5:
            // 2 sources

            ** while (index + 1 < this.size && this.getLine(this.array[index + 1]) == line)
        }
lbl6:
        // 1 sources

        return this.array[index];
    }

    public T findLastTokenOnOrBeforeLine(int line) {
        T result = this.findLastTokenOnLine(line);
        if (result != null) {
            return result;
        }
        int index = 0;
        while (index < this.size) {
            if (this.getLine(this.array[index]) > line) {
                if (index == 0) {
                    return null;
                }
                return this.array[index - 1];
            }
            ++index;
        }
        return this.array[this.size - 1];
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TokenList.this.size;
            }

            @Override
            public T next() {
                return this.index < TokenList.this.size ? TokenList.this.array[this.index++] : null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

