/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.rephraserengine.core.util.TwoKeyTreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TwoKeyTreeMap<RowType extends Comparable<RowType>, ColType extends Comparable<ColType>, CellType extends Comparable<CellType>>
implements Iterable<CellType> {
    protected TreeMap<RowType, TreeMap<ColType, CellType>> table = new TreeMap();

    public CellType put(RowType k1, ColType k2, CellType v) {
        if (!this.table.containsKey(k1)) {
            this.table.put(k1, new TreeMap());
        }
        TreeMap<ColType, CellType> thisRow = this.table.get(k1);
        thisRow.put(k2, v);
        return v;
    }

    public CellType getEntry(RowType k1, ColType k2) {
        if (!this.table.containsKey(k1)) {
            return null;
        }
        TreeMap<ColType, CellType> thisRow = this.table.get(k1);
        if (!thisRow.containsKey(k2)) {
            return null;
        }
        return (CellType)((Comparable)thisRow.get(k2));
    }

    public TreeMap<ColType, CellType> getAllEntriesFor(RowType k1) {
        if (!this.table.containsKey(k1)) {
            return null;
        }
        return this.table.get(k1);
    }

    public Set<RowType> keySet() {
        return this.table.keySet();
    }

    public boolean containsEntry(RowType k1, ColType k2) {
        return this.getEntry(k1, k2) != null;
    }

    public void clear() {
        this.table.clear();
    }

    public void remove(RowType key) {
        this.table.remove(key);
    }

    public void remove(RowType k1, ColType k2) {
        if (this.table.containsKey(k1)) {
            this.table.get(k1).remove(k2);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (Comparable r : this.table.keySet()) {
            TreeMap<ColType, CellType> thisRow = this.table.get(r);
            if (thisRow == null) continue;
            for (Comparable c : thisRow.keySet()) {
                sb.append("   ");
                sb.append("(");
                sb.append(r);
                sb.append(", ");
                sb.append(c);
                sb.append(") ==> ");
                sb.append(thisRow.get(c));
            }
        }
        sb.append("   }");
        return sb.toString();
    }

    @Override
    public Iterator<CellType> iterator() {
        return new ValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ValueIterator
    implements Iterator<CellType> {
        protected org.eclipse.rephraserengine.core.util.TwoKeyTreeMap$ValueIterator.State currentState;
        protected Iterator<TreeMap<ColType, CellType>> rowIterator;
        protected Iterator<CellType> colIterator;
        protected final org.eclipse.rephraserengine.core.util.TwoKeyTreeMap$ValueIterator.State INITIAL = new State(){

            @Override
            CellType getNextValue() {
                ValueIterator.this.rowIterator = ((ValueIterator)ValueIterator.this).TwoKeyTreeMap.this.table.values().iterator();
                ValueIterator.this.currentState = ValueIterator.this.STARTING_NEW_ROW;
                return ValueIterator.this.currentState.getNextValue();
            }
        };
        protected final org.eclipse.rephraserengine.core.util.TwoKeyTreeMap$ValueIterator.State STARTING_NEW_ROW = new State(){

            @Override
            CellType getNextValue() {
                if (ValueIterator.this.rowIterator.hasNext()) {
                    ValueIterator.this.colIterator = ValueIterator.this.rowIterator.next().values().iterator();
                    ValueIterator.this.currentState = ValueIterator.this.WORKING_THROUGH_ROW;
                } else {
                    ValueIterator.this.currentState = ValueIterator.this.DONE;
                }
                return ValueIterator.this.currentState.getNextValue();
            }
        };
        protected final org.eclipse.rephraserengine.core.util.TwoKeyTreeMap$ValueIterator.State WORKING_THROUGH_ROW = new State(){

            @Override
            CellType getNextValue() {
                if (ValueIterator.this.colIterator.hasNext()) {
                    return (Comparable)ValueIterator.this.colIterator.next();
                }
                ValueIterator.this.currentState = ValueIterator.this.STARTING_NEW_ROW;
                return ValueIterator.this.currentState.getNextValue();
            }
        };
        protected final org.eclipse.rephraserengine.core.util.TwoKeyTreeMap$ValueIterator.State DONE = new State(){

            @Override
            CellType getNextValue() {
                return null;
            }
        };
        protected CellType nextValue;

        ValueIterator() {
            this.currentState = this.INITIAL;
            this.nextValue = this.currentState.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public CellType next() {
            Object currentValue = this.nextValue;
            this.nextValue = this.currentState.getNextValue();
            if (currentValue == null && this.nextValue == null) {
                throw new NoSuchElementException();
            }
            return currentValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected abstract class State {
            protected State() {
            }

            abstract CellType getNextValue();
        }
    }
}

