/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.riena.communication.core.zipsupport.ReusableBufferedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZippingHttpURLConnectionWrapper
extends HttpURLConnection {
    private final HttpURLConnection connection;
    private GZIPOutputStream myGZIPOutputStream;

    public GZippingHttpURLConnectionWrapper(HttpURLConnection connection) {
        super(null);
        this.connection = connection;
    }

    protected GZippingHttpURLConnectionWrapper(URL u) {
        super(null);
        this.connection = null;
        throw new UnsupportedOperationException("This is not the intended usage of the GZippingHttpURLConnectionWrapper.");
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    @Override
    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    @Override
    public void connect() throws IOException {
        this.connection.connect();
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.connection.getHeaderFieldKey(n);
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.connection.setFixedLengthStreamingMode(contentLength);
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        this.connection.setChunkedStreamingMode(chunklen);
    }

    @Override
    public String getHeaderField(int n) {
        return this.connection.getHeaderField(n);
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.connection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.connection.setRequestMethod(method);
    }

    @Override
    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        return this.connection.getHeaderFieldDate(name, defaultValue);
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.connection.getPermission();
    }

    @Override
    public InputStream getErrorStream() {
        return this.connection.getErrorStream();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.connection.getConnectTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.connection.getReadTimeout();
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public int getContentLength() {
        return this.connection.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        return this.connection.getExpiration();
    }

    @Override
    public long getDate() {
        return this.connection.getDate();
    }

    @Override
    public long getLastModified() {
        return this.connection.getLastModified();
    }

    @Override
    public String getHeaderField(String name) {
        return this.connection.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.connection.getHeaderFields();
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        return this.connection.getHeaderFieldInt(name, defaultValue);
    }

    @Override
    public Object getContent() throws IOException {
        return this.connection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.connection.getContent(classes);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ReusableBufferedInputStream zipTestInputStream = new ReusableBufferedInputStream(this.connection.getInputStream());
        if (zipTestInputStream.markSupported()) {
            zipTestInputStream.mark(20);
            int readMAGIC = zipTestInputStream.read() + zipTestInputStream.read() * 256;
            zipTestInputStream.reset();
            if (readMAGIC == 35615) {
                return new GZIPInputStream((InputStream)zipTestInputStream);
            }
        }
        return zipTestInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.myGZIPOutputStream = new GZIPOutputStream(this.connection.getOutputStream());
        return this.myGZIPOutputStream;
    }

    public GZIPOutputStream getUsedGZIPOutputStream() {
        return this.myGZIPOutputStream;
    }

    @Override
    public String toString() {
        return this.connection.toString();
    }

    @Override
    public void setDoInput(boolean doinput) {
        this.connection.setDoInput(doinput);
    }

    @Override
    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this.connection.setDoOutput(dooutput);
    }

    @Override
    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.connection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.connection.setUseCaches(usecaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.connection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.connection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.connection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.connection.addRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.connection.getRequestProperties();
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return this.connection.equals(obj);
    }
}

