/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.demo.client.model.EmailsResult;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.common.Email;
import org.eclipse.riena.demo.common.ICustomerService;
import org.eclipse.riena.demo.common.IEmailService;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;

public class AbstractEmailController
extends SubModuleController {
    protected IEmailService mailDemoService;
    protected Email selectedEmail;
    private ICustomerService customerDemoService;
    protected EmailsResult emailsResult = new EmailsResult();

    @InjectService(useRanking=true)
    public void bind(IEmailService mailDemoService) {
        this.mailDemoService = mailDemoService;
    }

    public void unbind(IEmailService mailDemoService) {
        this.mailDemoService = null;
    }

    @InjectService(useRanking=true)
    public void bind(ICustomerService customerDemoService) {
        this.customerDemoService = customerDemoService;
    }

    public void unbind(ICustomerService customerDemoService) {
        this.customerDemoService = null;
    }

    public void configureRidgets() {
        final ITableRidget emails = (ITableRidget)this.getRidget(ITableRidget.class, "emailsTable");
        final ILabelRidget emailSubject = (ILabelRidget)this.getRidget(ILabelRidget.class, "emailSubject");
        final ILabelRidget emailFrom = (ILabelRidget)this.getRidget(ILabelRidget.class, "emailFrom");
        final ILabelRidget emailTo = (ILabelRidget)this.getRidget(ILabelRidget.class, "emailTo");
        final ILabelRidget emailDate = (ILabelRidget)this.getRidget(ILabelRidget.class, "emailDate");
        final ITextRidget emailBody = (ITextRidget)this.getRidget(ITextRidget.class, "emailBody");
        emails.setComparator(3, (Comparator)new TypedComparator());
        emails.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "selection") {
                    AbstractEmailController.this.selectedEmail = (Email)emails.getSelection().get(0);
                    emailSubject.setText(AbstractEmailController.this.selectedEmail.getEmailSubject());
                    emailFrom.setText(AbstractEmailController.this.selectedEmail.getEmailFrom());
                    emailBody.setText(AbstractEmailController.this.selectedEmail.getEmailBody());
                    emailTo.setText(AbstractEmailController.this.selectedEmail.getEmailTo());
                    SimpleDateFormat formatter = new SimpleDateFormat("E dd.MM.yyyy HH:mm");
                    emailDate.setText(formatter.format(AbstractEmailController.this.selectedEmail.getEmailDate()));
                }
            }
        });
        if (((ISubModuleNode)this.getNavigationNode()).isJumpTarget()) {
            IActionRidget openCustomerAction = (IActionRidget)this.getRidget(IActionRidget.class, "openCustomer");
            openCustomerAction.setText("Back to Customer");
        }
    }

    @OnActionCallback(ridgetId="openCustomer")
    protected void openCustomer() {
        String selectedEmailAddress;
        if (((ISubModuleNode)this.getNavigationNode()).isJumpTarget()) {
            ((ISubModuleNode)this.getNavigationNode()).jumpBack();
            ((ISubModuleNode)this.getNavigationNode()).getParent().dispose();
        } else if (this.selectedEmail != null && (selectedEmailAddress = this.openCustomerWithEmailAddress()) != null) {
            Customer customer = this.customerDemoService.findCustomerWithEmailAddress(selectedEmailAddress);
            System.out.println("customer " + customer);
            if (customer != null) {
                ((ISubModuleNode)this.getNavigationNode()).navigate(new NavigationNodeId("riena.demo.client.CustomerRecord", selectedEmailAddress), new NavigationArgument((Object)customer));
            }
        }
    }

    protected String openCustomerWithEmailAddress() {
        return this.selectedEmail.getEmailFrom();
    }
}

