/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import java.util.Date;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.demo.client.model.SearchBean;
import org.eclipse.riena.demo.client.model.SearchResult;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.common.ICustomerService;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;
import org.eclipse.riena.ui.ridgets.annotation.OnDoubleClick;
import org.eclipse.riena.ui.ridgets.swt.DateColumnFormatter;

public class CustomerSearchController
extends SubModuleController {
    private ICustomerService customerDemoService;
    private final SearchBean customerSearchBean = new SearchBean();
    private final SearchResult result = new SearchResult();

    @InjectService(useRanking=true)
    public void bind(ICustomerService customerDemoService) {
        this.customerDemoService = customerDemoService;
    }

    public void unbind(ICustomerService customerDemoService) {
        this.customerDemoService = null;
    }

    public void configureRidgets() {
        ITextRidget suchName = (ITextRidget)this.getRidget(ITextRidget.class, "searchLastName");
        suchName.bindToModel((Object)this.customerSearchBean, "lastName");
        suchName.setMandatory(true);
        ((ILabelRidget)this.getRidget("hits")).bindToModel((Object)this.result, "hits");
        ITableRidget kunden = (ITableRidget)this.getRidget("result");
        String[] columnNames = new String[]{"Lastname", "Firstname", "Birthdate", "Street", "City"};
        String[] propertyNames = new String[]{"lastName", "firstName", "birthDate", "address.street", "address.city"};
        kunden.bindToModel((Object)this.result, "customers", Customer.class, propertyNames, columnNames);
        kunden.setColumnFormatter(2, (IColumnFormatter)new DateColumnFormatter("dd.MM.yyyy"){

            protected Date getDate(Object element) {
                return ((Customer)element).getBirthDate();
            }
        });
    }

    @OnActionCallback(ridgetId="search")
    protected void search() {
        this.result.setCustomers(null);
        this.getRidget("result").updateFromModel();
        this.result.setCustomers(this.customerDemoService.search(this.customerSearchBean.getLastName()));
        this.getRidget("result").updateFromModel();
        this.getRidget("hits").updateFromModel();
        this.updateAllRidgetsFromModel();
    }

    @OnActionCallback(ridgetId="new")
    protected void newCustomer() {
        ((ISubModuleNode)this.getNavigationNode()).navigate(new NavigationNodeId("riena.demo.client.CustomerRecord"));
    }

    @OnActionCallback(ridgetId="open")
    @OnDoubleClick(ridgetId="result")
    protected void openSelectedCustomer() {
        ITableRidget kunden = (ITableRidget)this.getRidget("result");
        int selectionIndex = kunden.getSelectionIndex();
        if (selectionIndex >= 0) {
            ((ISubModuleNode)this.getNavigationNode()).navigate(new NavigationNodeId("riena.demo.client.CustomerRecord", this.result.getCustomers().get(selectionIndex).getEmailAddress()), new NavigationArgument((Object)this.result.getCustomers().get(selectionIndex)));
        }
    }
}

