/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.optional.controllers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRowRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class CompositeTableSubModuleController
extends SubModuleController {
    private final List<Person> input = PersonFactory.createPersonList();

    public CompositeTableSubModuleController() {
        this(null);
    }

    public CompositeTableSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        final ICompositeTableRidget table = (ICompositeTableRidget)this.getRidget("table");
        IActionRidget buttonAdd = (IActionRidget)this.getRidget("buttonAdd");
        IActionRidget buttonDelete = (IActionRidget)this.getRidget("buttonDelete");
        IActionRidget buttonDump = (IActionRidget)this.getRidget("buttonDump");
        table.bindToModel((IObservableList)new WritableList(this.input, Person.class), Person.class, RowRidget.class);
        table.updateFromModel();
        table.setComparator(0, (Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Person p1 = (Person)o1;
                Person p2 = (Person)o2;
                int result = p1.getLastname().compareTo(p2.getLastname());
                if (result == 0) {
                    result = p1.getFirstname().compareTo(p2.getFirstname());
                }
                return result;
            }
        });
        table.setComparator(1, (Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Person p1 = (Person)o1;
                Person p2 = (Person)o2;
                return p1.getGender().compareTo(p2.getGender());
            }
        });
        table.setSortedColumn(0);
        buttonAdd.setText("&Add");
        buttonAdd.addListener(new IActionListener(){
            private int i = 0;

            public void callback() {
                ++this.i;
                Person person = new Person("Doe #" + this.i, "John");
                person.setHasCat(true);
                CompositeTableSubModuleController.this.input.add(person);
                table.updateFromModel();
                table.setSelection((Object)person);
            }
        });
        buttonDelete.setText("&Delete");
        buttonDelete.addListener(new IActionListener(){

            public void callback() {
                Person person = (Person)table.getSingleSelectionObservable().getValue();
                CompositeTableSubModuleController.this.input.remove(person);
                table.updateFromModel();
            }
        });
        buttonDump.setText("&Console dump");
        buttonDump.addListener(new IActionListener(){

            public void callback() {
                System.out.println("\nPersons:");
                for (Person p : CompositeTableSubModuleController.this.input) {
                    System.out.println(p);
                }
            }
        });
        final IObservableValue viewerSelection = table.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IRidget)buttonDelete, (IObservableValue)hasSelection);
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    public static class RowRidget
    extends AbstractCompositeRidget
    implements IRowRidget {
        private Person rowData;
        private static final String[] GENDER = new String[]{"female", "male"};

        public void setData(Object rowData) {
            this.rowData = (Person)rowData;
        }

        public void configureRidgets() {
            ITextRidget txtFirst = (ITextRidget)this.getRidget("first");
            txtFirst.bindToModel((Object)this.rowData, "firstname");
            txtFirst.updateFromModel();
            ITextRidget txtLast = (ITextRidget)this.getRidget("last");
            txtLast.bindToModel((Object)this.rowData, "lastname");
            txtLast.updateFromModel();
            ISingleChoiceRidget gender = (ISingleChoiceRidget)this.getRidget("gender");
            gender.bindToModel(Arrays.asList(GENDER), null, (Object)this.rowData, "gender");
            gender.updateFromModel();
            IMultipleChoiceRidget pets = (IMultipleChoiceRidget)this.getRidget("pets");
            pets.bindToModel(Arrays.asList(Person.Pets.values()), null, (Object)this.rowData, "pets");
            pets.updateFromModel();
        }
    }
}

