/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.optional.controllers;

import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.AttentionMarker;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRowRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class OptionalMarkerSubModuleController
extends SubModuleController {
    public void configureRidgets() {
        final ICompositeTableRidget compTable = (ICompositeTableRidget)this.getRidget(ICompositeTableRidget.class, "compTable");
        WritableList input = new WritableList(PersonFactory.createPersonList(), Person.class);
        compTable.bindToModel((IObservableList)input, Person.class, RowRidget.class);
        compTable.updateFromModel();
        final IRidget[] markables = new IRidget[]{compTable};
        final IToggleButtonRidget checkMandatory = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkMandatory");
        final IToggleButtonRidget checkError = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkError");
        IToggleButtonRidget checkDisabled = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkDisabled");
        IToggleButtonRidget checkOutput = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkOutput");
        IToggleButtonRidget checkHidden = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkHidden");
        IToggleButtonRidget checkHiddenParent = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkHiddenParent");
        checkMandatory.addListener(new IActionListener(){

            public void callback() {
                boolean isMandatory = checkMandatory.isSelected();
                IRidget[] iRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IRidget ridget = iRidgetArray[n2];
                    if (ridget instanceof IMarkableRidget) {
                        ((IMarkableRidget)ridget).setMandatory(isMandatory);
                    } else {
                        String name = ridget.getClass().getSimpleName();
                        System.out.println("No mandatory marker support on " + name);
                    }
                    ++n2;
                }
                if (isMandatory) {
                    compTable.clearSelection();
                }
            }
        });
        checkError.addListener(new IActionListener(){

            public void callback() {
                boolean isError = checkError.isSelected();
                IRidget[] iRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IRidget ridget = iRidgetArray[n2];
                    if (ridget instanceof IMarkableRidget) {
                        ((IMarkableRidget)ridget).setErrorMarked(isError);
                    }
                    ++n2;
                }
            }
        });
        checkDisabled.addListener((IActionListener)new DisabledActionListener(markables, checkDisabled));
        checkOutput.addListener((IActionListener)new OutputActionListener(markables, checkOutput));
        checkHidden.addListener((IActionListener)new HiddenActionListener(checkHidden, markables));
        checkHiddenParent.addListener((IActionListener)new HiddenParentActionListener(checkHiddenParent, markables));
        ((ISubModuleNode)this.getNavigationNode()).addSimpleListener((ISimpleNavigationNodeListener)new SimpleNavigationNodeAdapter(){

            public void afterDeactivated(INavigationNode<?> node) {
                super.afterDeactivated(node);
                Collection markers = node.getMarkersOfType(AttentionMarker.class);
                for (AttentionMarker marker : markers) {
                    node.removeMarker((IMarker)marker);
                }
            }
        });
    }

    private static final class AlwaysWrongValidator
    implements IValidator {
        private AlwaysWrongValidator() {
        }

        public IStatus validate(Object value) {
            return ValidationRuleStatus.error((boolean)false, (String)"");
        }
    }

    private static final class DisabledActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkDisabled;

        private DisabledActionListener(IRidget[] markables, IToggleButtonRidget checkDisabled) {
            this.markables = markables;
            this.checkDisabled = checkDisabled;
        }

        public void callback() {
            boolean isEnabled = !this.checkDisabled.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                ridget.setEnabled(isEnabled);
                ++n2;
            }
        }
    }

    private static final class HiddenActionListener
    implements IActionListener {
        private final IToggleButtonRidget checkHidden;
        private final IRidget[] markables;

        private HiddenActionListener(IToggleButtonRidget checkHidden, IRidget[] markables) {
            this.checkHidden = checkHidden;
            this.markables = markables;
        }

        public void callback() {
            boolean isVisible = !this.checkHidden.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                ridget.setVisible(isVisible);
                ++n2;
            }
        }
    }

    private static final class HiddenParentActionListener
    implements IActionListener {
        private final IToggleButtonRidget checkHiddenParent;
        private final IRidget[] markables;

        private HiddenParentActionListener(IToggleButtonRidget checkHiddenParent, IRidget[] markables) {
            this.checkHiddenParent = checkHiddenParent;
            this.markables = markables;
        }

        public void callback() {
            Composite parent = ((Control)this.markables[0].getUIControl()).getParent();
            boolean isVisible = !this.checkHiddenParent.isSelected();
            parent.setVisible(isVisible);
        }
    }

    private static final class OutputActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkOutput;

        private OutputActionListener(IRidget[] markables, IToggleButtonRidget checkOutput) {
            this.markables = markables;
            this.checkOutput = checkOutput;
        }

        public void callback() {
            boolean isOutput = this.checkOutput.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                if (ridget instanceof IMarkableRidget) {
                    ((IMarkableRidget)ridget).setOutputOnly(isOutput);
                } else {
                    String name = ridget.getClass().getSimpleName();
                    System.out.println("No output marker support on " + name);
                }
                ++n2;
            }
        }
    }

    public static final class RowRidget
    extends AbstractCompositeRidget
    implements IRowRidget {
        private Person rowData;

        public void setData(Object rowData) {
            this.rowData = (Person)rowData;
        }

        public void configureRidgets() {
            ITextRidget txtLast = (ITextRidget)this.getRidget("txtLast");
            txtLast.bindToModel((Object)this.rowData, "firstname");
            txtLast.updateFromModel();
            ITextRidget txtFirst = (ITextRidget)this.getRidget("txtFirst");
            txtFirst.bindToModel((Object)this.rowData, "firstname");
            txtFirst.updateFromModel();
        }
    }
}

