/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.riena.beans.common.ListBean;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.Image;

public class CompletionComboSubModuleController
extends SubModuleController {
    public void configureRidgets() {
        ListBean input = this.createInput();
        IComboRidget combo1 = this.configureCombo(input, "combo1", "selection1", "text1");
        combo1.setMarkSelectionMismatch(true);
        this.configureCombo(input, "combo2", "selection2", "text2");
        this.configureCombo(input, "combo3", "selection3", "text3");
        IComboRidget combo3 = this.configureCombo(input, "combo4", "selection4", "text4");
        combo3.setMarkSelectionMismatch(true);
        CityFormatter formatter = new CityFormatter();
        combo3.setColumnFormatter((IColumnFormatter)formatter);
        IComboRidget combo4 = this.configureCombo(input, "combo5", "selection5", "text5");
        combo4.setColumnFormatter((IColumnFormatter)formatter);
        IComboRidget combo5 = this.configureCombo(input, "combo6", "selection6", "text6");
        combo5.setColumnFormatter((IColumnFormatter)formatter);
    }

    private IComboRidget configureCombo(Object input, String comboId, String selectionId, String textId) {
        final ITextRidget selectionRidget = (ITextRidget)this.getRidget(ITextRidget.class, selectionId);
        selectionRidget.setOutputOnly(true);
        final ITextRidget textRidget = (ITextRidget)this.getRidget(ITextRidget.class, textId);
        textRidget.setOutputOnly(true);
        IComboRidget result = (IComboRidget)this.getRidget(IComboRidget.class, comboId);
        WritableValue selection = new WritableValue(){

            public void doSetValue(Object value) {
                String text = value == null ? "" : ((City)value).getName();
                selectionRidget.setText(text);
            }
        };
        result.bindToModel(input, "values", City.class, "getName", (Object)selection, "value");
        result.addPropertyChangeListener("text", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                textRidget.setText((String)evt.getNewValue());
            }
        });
        result.updateFromModel();
        return result;
    }

    private ListBean createInput() {
        ArrayList<City> values = new ArrayList<City>();
        values.add(new City("Aachen___ist___lang", Country.GERMANY));
        values.add(new City("Albi", Country.FRANCE));
        values.add(new City("Augsburg", Country.GERMANY));
        values.add(new City("Rome", Country.ITALY));
        values.add(new City("Milan", Country.ITALY));
        values.add(new City("Napoli", Country.ITALY));
        values.add(new City("Torino", Country.ITALY));
        values.add(new City("Palermo", Country.ITALY));
        values.add(new City("Genova", Country.ITALY));
        values.add(new City("Bologna", Country.ITALY));
        values.add(new City("Firenze", Country.ITALY));
        values.add(new City("Venezia", Country.ITALY));
        values.add(new City("Pisa", Country.ITALY));
        values.add(new City("Berlin", Country.GERMANY));
        values.add(new City("Hamburg", Country.GERMANY));
        values.add(new City("K\u00f6ln", Country.GERMANY));
        values.add(new City("Frankfurt am Main", Country.GERMANY));
        values.add(new City("Stuttgart", Country.GERMANY));
        values.add(new City("Dortmund", Country.GERMANY));
        values.add(new City("Essen", Country.GERMANY));
        values.add(new City("D\u00fcsseldorf", Country.GERMANY));
        values.add(new City("M\u00fcnchen", Country.GERMANY));
        values.add(new City("Mannheim", Country.GERMANY));
        values.add(new City("Paris", Country.FRANCE));
        values.add(new City("Marseille", Country.FRANCE));
        values.add(new City("Lyon", Country.FRANCE));
        values.add(new City("Toulouse", Country.FRANCE));
        values.add(new City("Nice", Country.FRANCE));
        values.add(new City("Nantes", Country.FRANCE));
        values.add(new City("Strasbourg", Country.FRANCE));
        values.add(new City("Montpellier", Country.FRANCE));
        values.add(new City("Bordeaux", Country.FRANCE));
        values.add(new City("Lille", Country.FRANCE));
        Collections.sort(values, new Comparator<City>(){

            @Override
            public int compare(City o1, City o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return new ListBean(values);
    }

    public static final class City {
        private final String name;
        private final Country country;

        City(String name, Country country) {
            this.name = name;
            this.country = country;
        }

        public String getName() {
            return this.name;
        }

        public Country getCountry() {
            return this.country;
        }
    }

    private static final class CityFormatter
    extends ColumnFormatter {
        private CityFormatter() {
        }

        public String getText(Object element) {
            return ((City)element).getName();
        }

        public Image getImage(Object element) {
            Country country = ((City)element).getCountry();
            String key = this.getImageKey(country);
            Image result = null;
            if (key != null) {
                result = ImageStore.getInstance().getImage(key);
            }
            return result;
        }

        private String getImageKey(Country country) {
            switch (country) {
                case ITALY: {
                    return "flag_italy.png";
                }
                case GERMANY: {
                    return "flag_germany.png";
                }
                case FRANCE: {
                    return "flag_france.png";
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Country {
        ITALY,
        FRANCE,
        GERMANY;

    }
}

