/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.text.NumberFormat;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.ICustomMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;

public class CustomMarkerSubModuleController
extends SubModuleController {
    private static final ICustomMarker CUSTOM_OUTPUT_MARKER = new CustomOutputMarker();
    private static final ICustomMarker CUSTOM2_OUTPUT_MARKER = new Custom2OutputMarker();
    private static final ICustomMarker CUSTOM_MANDATORY_MARKER = new CustomMandatoryMarker();
    private static final ICustomMarker CUSTOM2_MANDATORY_MARKER = new Custom2MandatoryMarker();
    private ITextRidget textName;
    private IDecimalTextRidget textPrice;
    private INumericTextRidget textAmount;

    public void configureRidgets() {
        this.textName = (ITextRidget)this.getRidget(ITextRidget.class, "textName");
        this.textName.setText("Chateau Schaedelbrummer");
        this.textPrice = (IDecimalTextRidget)this.getRidget(IDecimalTextRidget.class, "textPrice");
        this.textPrice.setGrouping(true);
        this.textPrice.setText(NumberFormat.getInstance().format(-29.99));
        this.textAmount = (INumericTextRidget)this.getRidget(INumericTextRidget.class, "textAmount");
        this.textAmount.setSigned(false);
        this.textAmount.setGrouping(true);
        this.textAmount.setText("1001");
        IRidget[] markables = new IRidget[]{this.textName, this.textPrice, this.textAmount};
        IToggleButtonRidget checkOutput = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkOutput");
        checkOutput.addListener((IActionListener)new OutputActionListener(markables, checkOutput));
        IToggleButtonRidget customCheckOutput = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "customCheckOutput");
        customCheckOutput.addListener((IActionListener)new CustomOutputActionListener(markables, customCheckOutput));
        IToggleButtonRidget custom2CheckOutput = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "custom2CheckOutput");
        custom2CheckOutput.addListener((IActionListener)new Custom2OutputActionListener(markables, custom2CheckOutput));
        IToggleButtonRidget checkMandatory = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkMandatory");
        checkMandatory.addListener((IActionListener)new MandatoryActionListener(markables, checkMandatory));
        IToggleButtonRidget customCheckMandatory = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "customCheckMandatory");
        customCheckMandatory.addListener((IActionListener)new CustomMandatoryActionListener(markables, customCheckMandatory));
        IToggleButtonRidget custom2CheckMandatory = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "custom2CheckMandatory");
        custom2CheckMandatory.addListener((IActionListener)new Custom2MandatoryActionListener(markables, custom2CheckMandatory));
    }

    private void clearContent() {
        this.textName.setText("");
        this.textPrice.setText("");
        this.textAmount.setText(null);
    }

    private static abstract class AbstractCustomActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkButton;

        protected AbstractCustomActionListener(IRidget[] markables, IToggleButtonRidget checkButton) {
            this.markables = markables;
            this.checkButton = checkButton;
        }

        protected abstract ICustomMarker getMarker();

        public void callback() {
            boolean isSelected = this.checkButton.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                if (ridget instanceof IMarkableRidget) {
                    IMarkableRidget markableRidget = (IMarkableRidget)ridget;
                    if (isSelected) {
                        markableRidget.addMarker((IMarker)this.getMarker());
                    } else {
                        markableRidget.removeMarker((IMarker)this.getMarker());
                    }
                } else {
                    String name = ridget.getClass().getSimpleName();
                    System.out.println("No output marker support on " + name);
                }
                ++n2;
            }
        }
    }

    private class Custom2MandatoryActionListener
    extends CustomMandatoryActionListener {
        protected Custom2MandatoryActionListener(IRidget[] markables, IToggleButtonRidget checkButton) {
            super(markables, checkButton);
        }

        protected ICustomMarker getMarker() {
            return CUSTOM2_MANDATORY_MARKER;
        }
    }

    private static class Custom2MandatoryMarker
    extends MandatoryMarker
    implements ICustomMarker {
        private Custom2MandatoryMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return LnfManager.getLnf().getColor("red");
        }

        public Object getForeground(IMarkable markable) {
            return null;
        }
    }

    private static class Custom2OutputActionListener
    extends CustomOutputActionListener {
        protected Custom2OutputActionListener(IRidget[] markables, IToggleButtonRidget checkButton) {
            super(markables, checkButton);
        }

        protected ICustomMarker getMarker() {
            return CUSTOM2_OUTPUT_MARKER;
        }
    }

    private static class Custom2OutputMarker
    extends OutputMarker
    implements ICustomMarker {
        private Custom2OutputMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return LnfManager.getLnf().getColor("darkGray");
        }

        public Object getForeground(IMarkable markable) {
            return LnfManager.getLnf().getColor("yellow");
        }
    }

    private class CustomMandatoryActionListener
    extends AbstractCustomActionListener {
        protected CustomMandatoryActionListener(IRidget[] markables, IToggleButtonRidget checkButton) {
            super(markables, checkButton);
        }

        protected ICustomMarker getMarker() {
            return CUSTOM_MANDATORY_MARKER;
        }

        public void callback() {
            CustomMarkerSubModuleController.this.clearContent();
            super.callback();
        }
    }

    private static class CustomMandatoryMarker
    extends MandatoryMarker
    implements ICustomMarker {
        private CustomMandatoryMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return LnfManager.getLnf().getColor("pink");
        }

        public Object getForeground(IMarkable markable) {
            return null;
        }
    }

    private static class CustomOutputActionListener
    extends AbstractCustomActionListener {
        protected CustomOutputActionListener(IRidget[] markables, IToggleButtonRidget checkButton) {
            super(markables, checkButton);
        }

        protected ICustomMarker getMarker() {
            return CUSTOM_OUTPUT_MARKER;
        }
    }

    private static class CustomOutputMarker
    extends OutputMarker
    implements ICustomMarker {
        private CustomOutputMarker() {
        }

        public Object getBackground(IMarkable markable) {
            if (markable.getMarkersOfType(MandatoryMarker.class).isEmpty()) {
                return LnfManager.getLnf().getColor("lightGray");
            }
            return LnfManager.getLnf().getColor("orange");
        }

        public Object getForeground(IMarkable markable) {
            return LnfManager.getLnf().getColor("white");
        }
    }

    private static final class MandatoryActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkMandatory;

        private MandatoryActionListener(IRidget[] markables, IToggleButtonRidget checkMandatory) {
            this.markables = markables;
            this.checkMandatory = checkMandatory;
        }

        public void callback() {
            boolean isMandatory = this.checkMandatory.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                if (ridget instanceof IMarkableRidget) {
                    ((IMarkableRidget)ridget).setMandatory(isMandatory);
                } else {
                    String name = ridget.getClass().getSimpleName();
                    System.out.println("No output marker support on " + name);
                }
                ++n2;
            }
        }
    }

    private static final class OutputActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkOutput;

        private OutputActionListener(IRidget[] markables, IToggleButtonRidget checkOutput) {
            this.markables = markables;
            this.checkOutput = checkOutput;
        }

        public void callback() {
            boolean isOutput = this.checkOutput.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                if (ridget instanceof IMarkableRidget) {
                    ((IMarkableRidget)ridget).setOutputOnly(isOutput);
                } else {
                    String name = ridget.getClass().getSimpleName();
                    System.out.println("No output marker support on " + name);
                }
                ++n2;
            }
        }
    }
}

