/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallbacks;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;

public class HelloDialogController
extends AbstractWindowController {
    private final String[] carPlates = new String[]{"JM5B0ND", "1 SPY", "MNY PNY", "BN D07", "Q RULE2", "MI64EVR"};
    private ISingleChoiceRidget compositeCarModel;
    private ISingleChoiceRidget compositeCarWarranty;
    private IMultipleChoiceRidget compositeCarPlates;
    private IMultipleChoiceRidget compositeCarExtras;
    private CarConfig carConfig;

    public void configureRidgets() {
        super.configureRidgets();
        this.getWindowRidget().setTitle("James' Car Configurator");
        this.getWindowRidget().setIcon("sample.gif");
        this.carConfig = new CarConfig();
        this.compositeCarModel = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "compositeCarModel");
        this.compositeCarModel.bindToModel((IObservableList)this.toList((Object[])CarModels.values()), BeansObservables.observeValue((Object)((Object)this.carConfig), (String)"model"));
        this.compositeCarModel.addMarker((IMarker)new MandatoryMarker());
        this.compositeCarModel.updateFromModel();
        this.compositeCarExtras = (IMultipleChoiceRidget)this.getRidget(IMultipleChoiceRidget.class, "compositeCarExtras");
        String[] labels = new String[]{"Front Machine Guns", "Self Destruct Button", "Underwater Package", "Park Distance Control System"};
        this.compositeCarExtras.bindToModel((List)this.toList((Object[])CarOptions.values()), Arrays.asList(labels), (Object)this.carConfig, "options");
        this.compositeCarExtras.updateFromModel();
        this.compositeCarWarranty = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "compositeCarWarranty");
        this.compositeCarWarranty.bindToModel((IObservableList)this.toList((Object[])CarWarranties.values()), BeansObservables.observeValue((Object)((Object)this.carConfig), (String)"warranty"));
        this.compositeCarWarranty.addMarker((IMarker)new MandatoryMarker());
        this.compositeCarWarranty.updateFromModel();
        this.compositeCarPlates = (IMultipleChoiceRidget)this.getRidget(IMultipleChoiceRidget.class, "compositeCarPlates");
        this.compositeCarPlates.bindToModel((IObservableList)this.toList(this.carPlates), PojoObservables.observeList((Object)((Object)this.carConfig), (String)"plates"));
        this.compositeCarPlates.addMarker((IMarker)new MandatoryMarker());
        this.compositeCarPlates.updateFromModel();
        ITextRidget txtPrice = (ITextRidget)this.getRidget(ITextRidget.class, "txtPrice");
        txtPrice.setOutputOnly(true);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(BeansObservables.observeValue((Object)txtPrice, (String)"text"), BeansObservables.observeValue((Object)((Object)this.carConfig), (String)"price"), null, null);
        IActionRidget buttonPreset = (IActionRidget)this.getRidget(IActionRidget.class, "buttonPreset");
        buttonPreset.setText("&Quick Config");
        IActionRidget buttonReset = (IActionRidget)this.getRidget(IActionRidget.class, "buttonReset");
        buttonReset.setText("&Reset");
    }

    public CarConfig getCarConfig() {
        return this.carConfig;
    }

    @OnActionCallback(ridgetId="buttonPreset")
    public void onPreset() {
        this.compositeCarModel.setSelection((Object)CarModels.BMW);
        this.compositeCarExtras.setSelection(Arrays.asList(CarOptions.PDCS));
        this.compositeCarWarranty.setSelection((Object)CarWarranties.EXTENDED);
        this.compositeCarPlates.setSelection(Arrays.asList(this.carPlates[0]));
    }

    @OnActionCallback(ridgetId="buttonReset")
    public void onReset() {
        this.carConfig.reset();
        this.compositeCarModel.updateFromModel();
        this.compositeCarExtras.updateFromModel();
        this.compositeCarWarranty.updateFromModel();
        this.compositeCarPlates.updateFromModel();
    }

    @OnActionCallbacks(value={@OnActionCallback(ridgetId="buttonPreset"), @OnActionCallback(ridgetId="buttonReset")})
    private void demonstrateMutlipleOnActionCallbacksAnnotation() {
        System.out.println("Demonstrate multiple @OnActionCallback annotations!");
    }

    private WritableList toList(Object[] values) {
        return new WritableList(Arrays.asList(values), Object.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CarConfig
    extends AbstractBean {
        public static final String PROP_MODEL = "model";
        public static final String PROP_OPTIONS = "options";
        public static final String PROP_WARRANTY = "warranty";
        public static final String PROP_PLATES = "plates";
        public static final String PROP_PRICE = "price";
        private CarModels model;
        private List<CarOptions> options = new ArrayList<CarOptions>();
        private CarWarranties warranty;
        private List<String> plates = new ArrayList<String>();

        public CarModels getModel() {
            return this.model;
        }

        public void setModel(CarModels model) {
            this.model = model;
            this.firePropertyChanged(PROP_MODEL, (Object)this.model, (Object)this.model);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public List<CarOptions> getOptions() {
            return Collections.unmodifiableList(this.options);
        }

        public void setOptions(List<CarOptions> options) {
            this.options = new ArrayList<CarOptions>(options);
            this.firePropertyChanged(PROP_OPTIONS, this.options, this.options);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public CarWarranties getWarranty() {
            return this.warranty;
        }

        public void setWarranty(CarWarranties warranty) {
            this.warranty = warranty;
            this.firePropertyChanged(PROP_WARRANTY, (Object)this.warranty, (Object)this.warranty);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public List<String> getPlates() {
            return Collections.unmodifiableList(this.plates);
        }

        public void setPlates(List<String> plates) {
            this.plates = new ArrayList<String>(plates);
            this.firePropertyChanged(PROP_PLATES, this.plates, this.plates);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public void reset() {
            this.setModel(null);
            this.setOptions(new ArrayList<CarOptions>());
            this.setWarranty(null);
            this.setPlates(new ArrayList<String>());
        }

        public long getPrice() {
            long price = 0L;
            if (this.model != null) {
                price += 100000L;
            }
            price += (long)this.options.size() * 25000L;
            if (this.warranty == CarWarranties.EXTENDED) {
                price += 10000L;
            }
            return price += (long)this.plates.size() * 200L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CarModels {
        ASTON_MARTIN("Aston Martin V-12 Vanquish"),
        LOTUS("Lotus Esprit Turbo"),
        BMW("BMW Z8");

        private final String label;

        private CarModels(String label) {
            Assert.isNotNull((Object)label);
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CarOptions {
        FRONT_GUNS,
        SELF_DESTRUCT,
        UNDERWATER,
        PDCS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CarWarranties {
        STANDARD,
        EXTENDED;


        public String toString() {
            char[] result = super.toString().toLowerCase().toCharArray();
            result[0] = Character.toUpperCase(result[0]);
            return String.valueOf(result);
        }
    }
}

