/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.marker.IMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.marker.MessageBoxMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.marker.TooltipMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class MessageMarkerSubModuleController
extends SubModuleController {
    private MessageBoxMessageMarkerViewer messageBoxMessageMarkerViewer;
    private IMultipleChoiceRidget activeViewers;

    public void configureRidgets() {
        super.configureRidgets();
        MessageMarkerExampleBean bean = new MessageMarkerExampleBean();
        ITextRidget alwaysMarked = (ITextRidget)this.getRidget("alwaysMarked");
        alwaysMarked.addMarker((IMarker)new ErrorMessageMarker("This textfield is inadequate in every way."));
        alwaysMarked.bindToModel((Object)bean, "alwaysMarkedText");
        alwaysMarked.updateFromModel();
        ITextRidget sometimesMarked = (ITextRidget)this.getRidget("sometimesMarked");
        sometimesMarked.addValidationRule((IValidator)new MinLength(3), ValidationTime.ON_UPDATE_TO_MODEL);
        sometimesMarked.addValidationMessage("Textfield contains less than 3 characters.");
        sometimesMarked.bindToModel((Object)bean, "sometimesMarkedText");
        sometimesMarked.updateFromModel();
        ITextRidget sometimesMarkedMultipleRules = (ITextRidget)this.getRidget("sometimesMarkedMultipleRules");
        StartsWithA startsWithA = new StartsWithA();
        EndsWithZ endsWithZ = new EndsWithZ();
        sometimesMarkedMultipleRules.addValidationRule((IValidator)startsWithA, ValidationTime.ON_UPDATE_TO_MODEL);
        sometimesMarkedMultipleRules.addValidationRule((IValidator)endsWithZ, ValidationTime.ON_UPDATE_TO_MODEL);
        sometimesMarkedMultipleRules.addValidationMessage("Text must begin with an A.", (IValidator)startsWithA);
        sometimesMarkedMultipleRules.addValidationMessage("Text must end with a Z.", (IValidator)endsWithZ);
        sometimesMarkedMultipleRules.bindToModel((Object)bean, "sometimesMarkedMultipleRulesText");
        sometimesMarkedMultipleRules.updateFromModel();
        IApplicationNode application = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        ApplicationController applicationController = (ApplicationController)application.getNavigationNodeController();
        IStatuslineRidget statuslineRidget = applicationController.getStatusline();
        StatuslineMessageMarkerViewer statuslineMessageMarkerViewer = new StatuslineMessageMarkerViewer(statuslineRidget);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)alwaysMarked);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)sometimesMarked);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)sometimesMarkedMultipleRules);
        TooltipMessageMarkerViewer tooltipMessageMarkerViewer = new TooltipMessageMarkerViewer();
        tooltipMessageMarkerViewer.addRidget((IBasicMarkableRidget)alwaysMarked);
        tooltipMessageMarkerViewer.addRidget((IBasicMarkableRidget)sometimesMarked);
        tooltipMessageMarkerViewer.addRidget((IBasicMarkableRidget)sometimesMarkedMultipleRules);
        IMessageBoxRidget messageBoxRidget = (IMessageBoxRidget)this.getRidget("messageBox");
        messageBoxRidget.setType(IMessageBoxRidget.Type.ERROR);
        messageBoxRidget.setTitle("Problems Summary");
        messageBoxRidget.setOptions(IMessageBoxRidget.OPTIONS_OK);
        this.messageBoxMessageMarkerViewer = new MessageBoxMessageMarkerViewer(messageBoxRidget);
        this.messageBoxMessageMarkerViewer.addRidget((IBasicMarkableRidget)alwaysMarked);
        this.messageBoxMessageMarkerViewer.addRidget((IBasicMarkableRidget)sometimesMarked);
        this.messageBoxMessageMarkerViewer.addRidget((IBasicMarkableRidget)sometimesMarkedMultipleRules);
        MessageMarkerViewers viewers = new MessageMarkerViewers();
        viewers.addViewer((IMessageMarkerViewer)statuslineMessageMarkerViewer, "Statusline");
        viewers.addViewer((IMessageMarkerViewer)tooltipMessageMarkerViewer, "Tooltip");
        viewers.addViewer((IMessageMarkerViewer)this.messageBoxMessageMarkerViewer, "MessageBox");
        viewers.setSelectedViewers(Arrays.asList(statuslineMessageMarkerViewer, tooltipMessageMarkerViewer));
        this.activeViewers = (IMultipleChoiceRidget)this.getRidget("activeViewers");
        this.activeViewers.bindToModel(viewers.getViewers(), viewers.getViewerLabels(), (Object)viewers, "selectedViewers");
        this.activeViewers.updateFromModel();
    }

    private static class EndsWithZ
    implements IValidator {
        private EndsWithZ() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.toLowerCase().endsWith("z")) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"Value does not end with Z.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }

    public static class MessageMarkerExampleBean {
        private String alwaysMarkedText = "Hopeless";
        private String sometimesMarkedText = "123";
        private String sometimesMarkedMultipleRulesText = "A to Z";

        public String getAlwaysMarkedText() {
            return this.alwaysMarkedText;
        }

        public void setAlwaysMarkedText(String alwaysMarkedText) {
            this.alwaysMarkedText = alwaysMarkedText;
        }

        public String getSometimesMarkedText() {
            return this.sometimesMarkedText;
        }

        public void setSometimesMarkedText(String sometimesMarkedText) {
            this.sometimesMarkedText = sometimesMarkedText;
        }

        public String getSometimesMarkedMultipleRulesText() {
            return this.sometimesMarkedMultipleRulesText;
        }

        public void setSometimesMarkedMultipleRulesText(String sometimesMarkedMultipleRulesText) {
            this.sometimesMarkedMultipleRulesText = sometimesMarkedMultipleRulesText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MessageMarkerViewers {
        private final List<IMessageMarkerViewer> viewers = new ArrayList<IMessageMarkerViewer>();
        private final List<String> viewerLabels = new ArrayList<String>();
        private List<IMessageMarkerViewer> selectedViewers = new ArrayList<IMessageMarkerViewer>();

        public void addViewer(IMessageMarkerViewer viewer, String label) {
            this.viewers.add(viewer);
            this.viewerLabels.add(label);
            this.updateViewers();
        }

        public List<IMessageMarkerViewer> getViewers() {
            return this.viewers;
        }

        public List<String> getViewerLabels() {
            return this.viewerLabels;
        }

        public List<IMessageMarkerViewer> getSelectedViewers() {
            return this.selectedViewers;
        }

        public void setSelectedViewers(List<IMessageMarkerViewer> selectedViewers) {
            this.selectedViewers = selectedViewers;
            this.updateViewers();
            if (this.selectedViewers.contains(MessageMarkerSubModuleController.this.messageBoxMessageMarkerViewer)) {
                this.selectedViewers.remove(MessageMarkerSubModuleController.this.messageBoxMessageMarkerViewer);
                MessageMarkerSubModuleController.this.activeViewers.updateFromModel();
            }
        }

        private void updateViewers() {
            for (IMessageMarkerViewer viewer : this.viewers) {
                viewer.setVisible(false);
            }
            for (IMessageMarkerViewer viewer : this.selectedViewers) {
                viewer.setVisible(true);
            }
        }
    }

    private static class StartsWithA
    implements IValidator {
        private StartsWithA() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationRuleStatus.ok();
            }
            if (value instanceof String) {
                String string = (String)value;
                if (string.toLowerCase().startsWith("a")) {
                    return ValidationRuleStatus.ok();
                }
                return ValidationRuleStatus.error((boolean)false, (String)"Value does not start with A.");
            }
            throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
        }
    }
}

