/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.common;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.riena.core.util.IOUtils;

public class LogEntryTransferObject
implements Serializable {
    private final String bundleName;
    private final String context;
    private final String exception;
    private final int level;
    private final String loggerName;
    private final String message;
    private final String threadName;
    private final long time;
    private static final long serialVersionUID = 189322808250966598L;

    private LogEntryTransferObject() {
        this.bundleName = null;
        this.context = null;
        this.exception = null;
        this.level = 0;
        this.loggerName = null;
        this.message = null;
        this.threadName = null;
        this.time = 0L;
    }

    public LogEntryTransferObject(ExtendedLogEntry logEntry) {
        Assert.isNotNull((Object)logEntry, (String)"logEntry must not be null");
        this.bundleName = logEntry.getBundle() != null ? logEntry.getBundle().getSymbolicName() : null;
        String string = this.context = logEntry.getContext() != null ? logEntry.getContext().toString() : null;
        if (logEntry.getException() != null) {
            StringWriter string2 = new StringWriter();
            PrintWriter writer = new PrintWriter(string2);
            logEntry.getException().printStackTrace(writer);
            IOUtils.close((Closeable)writer);
            this.exception = string2.toString();
        } else {
            this.exception = null;
        }
        this.level = logEntry.getLevel();
        this.loggerName = logEntry.getLoggerName();
        this.message = logEntry.getMessage();
        this.threadName = logEntry.getThreadName();
        this.time = logEntry.getTime();
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getContext() {
        return this.context;
    }

    public String getException() {
        return this.exception;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return new Date(this.time) + " " + this.loggerName + " Level: " + this.level + " [" + this.threadName + "] " + this.message + (this.exception == null ? "" : "\n" + this.exception);
    }
}

