/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNavigationHandler
extends AbstractHandler {
    AbstractNavigationHandler() {
    }

    protected final IModuleNode[] collectModules(IApplicationNode application) {
        ArrayList modules = new ArrayList();
        INavigationNode<?> subApplication = this.findActive(application.getChildren());
        if (subApplication instanceof ISubApplicationNode) {
            List groups = ((ISubApplicationNode)subApplication).getChildren();
            for (IModuleGroupNode moduleGroup : groups) {
                modules.addAll(moduleGroup.getChildren());
            }
        }
        return modules.toArray(new IModuleNode[modules.size()]);
    }

    protected final INavigationNode<?> findActive(List<INavigationNode<?>> nodes) {
        INavigationNode<?> result = null;
        Iterator<INavigationNode<?>> iter = nodes.iterator();
        while (result == null && iter.hasNext()) {
            INavigationNode<?> candidate = iter.next();
            if (!candidate.isActivated()) continue;
            result = candidate;
        }
        return result;
    }

    public final IModuleGroupNode findModuleGroup(IApplicationNode application) {
        INavigationNode<?> moduleGroup;
        IModuleGroupNode result = null;
        INavigationNode<?> subApplication = this.findActive(application.getChildren());
        if (subApplication != null && (moduleGroup = this.findActive(subApplication.getChildren())) instanceof IModuleGroupNode) {
            result = (IModuleGroupNode)moduleGroup;
        }
        return result;
    }

    public final INavigationNode<?> findNextNode(INavigationNode<?>[] nodes) {
        INavigationNode<?> result = null;
        int selectedCount = 0;
        INavigationNode<?>[] iNavigationNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationNode<?> node = iNavigationNodeArray[n2];
            if (this.isSelected(node)) {
                ++selectedCount;
            } else if (selectedCount == 1 && result == null) {
                result = node;
            }
            ++n2;
        }
        if (selectedCount == 1 && result == null && !this.isSelected(nodes[0])) {
            result = nodes[0];
        }
        return selectedCount == 1 ? result : null;
    }

    public final INavigationNode<?> findPreviousNode(INavigationNode<?>[] nodes, boolean wrap) {
        INavigationNode<?> result = null;
        int selectedCount = 0;
        int i = nodes.length - 1;
        while (i >= 0) {
            INavigationNode<?> node = nodes[i];
            if (this.isSelected(node)) {
                ++selectedCount;
            } else if (selectedCount == 1 && result == null) {
                result = node;
            }
            --i;
        }
        int lastApp = nodes.length - 1;
        if (wrap && selectedCount == 1 && result == null && !this.isSelected(nodes[lastApp])) {
            result = nodes[lastApp];
        }
        return selectedCount == 1 ? result : null;
    }

    protected boolean isSelected(INavigationNode<?> node) {
        return node.isSelected() && node.getParent().isSelected();
    }
}

