/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.AbstractNavigationHandler;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchModule
extends AbstractNavigationHandler
implements IExecutableExtension {
    private boolean toNext;
    private boolean activateSubmodule;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doSwitch(this.toNext);
        return null;
    }

    public void setActivateSubmodule(boolean activate) {
        this.activateSubmodule = activate;
    }

    public void doSwitch(boolean forward) {
        INavigationNode<?> nextModule;
        IApplicationNode application = ApplicationNodeManager.getApplicationNode();
        IModuleNode[] modules = this.collectModules(application);
        INavigationNode<?> iNavigationNode = nextModule = forward ? this.findNextNode((INavigationNode<?>[])modules) : this.findPreviousNode((INavigationNode<?>[])modules, true);
        if (nextModule != null) {
            INavigationNode<?> nextSubModule = this.findNextSubModule(forward, nextModule);
            if (nextSubModule != null) {
                nextSubModule.activate();
            } else {
                nextModule.activate();
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.toNext = "next".equalsIgnoreCase(String.valueOf(data));
    }

    private INavigationNode<?> findNextSubModule(boolean forward, INavigationNode<?> nextModule) {
        INavigationNode<?> nextSubModule = this.activateSubmodule ? this.getSubModule(nextModule, forward) : this.findActive(nextModule.getChildren());
        return nextSubModule;
    }

    private INavigationNode<?> getSubModule(INavigationNode<?> module, boolean forward) {
        INavigationNode result = null;
        List subModules = ((IModuleNode)module).getChildren();
        int subModuleCount = subModules.size();
        if (subModuleCount > 1) {
            int index = forward ? 0 : subModuleCount - 1;
            result = (INavigationNode)subModules.get(index);
        }
        return result;
    }
}

