/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationSwitcherWidget;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwitcherComposite
extends Composite {
    private final ApplicationNode node;

    public SwitcherComposite(Composite parent, ApplicationNode node) {
        super(parent, 0x20000000);
        this.node = node;
        this.init(parent);
    }

    private void init(Composite parent) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, this.getSwitchterTopMargin() + padding);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.getSwitchterHeight();
        this.setLayoutData(formData);
        this.setLayout((Layout)new FillLayout());
        SubApplicationSwitcherWidget switcher = new SubApplicationSwitcherWidget(this, 0, (IApplicationNode)this.node);
        WidgetIdentificationSupport.setDefaultIdentification((Widget)switcher);
    }

    private int getSwitchterTopMargin() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.topMargin");
        return margin;
    }

    private int getSwitchterHeight() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.height");
        return margin;
    }

    private int getShellPadding() {
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer.getCompleteBorderWidth();
    }
}

