/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.SwitchModule;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNavigationListener
extends SelectionAdapter
implements KeyListener,
FocusListener {
    private static final int KC_ARROW_DOWN = 0x1000002;
    private static final int KC_ARROW_UP = 0x1000001;
    private volatile boolean keyPressed;
    private int keyCode;
    private NodeSwitcher nodeSwitcher;
    private boolean isFirst;
    private boolean isLast;

    public ModuleNavigationListener(Tree moduleTree) {
        moduleTree.addKeyListener((KeyListener)this);
        moduleTree.addSelectionListener((SelectionListener)this);
        moduleTree.addFocusListener((FocusListener)this);
    }

    public void widgetSelected(SelectionEvent event) {
        this.cancelSwitch();
        if (!this.keyPressed) {
            this.startSwitch(this.getSelection((TypedEvent)event));
        } else {
            TreeItem item;
            Tree tree = (Tree)event.widget;
            TreeItem[] sel = tree.getSelection();
            if (sel.length > 0 && !this.isSelectable(item = sel[0])) {
                if (this.keyCode == 0x1000001 || this.keyCode == 0x1000003) {
                    item = this.findPrevious(item);
                } else if (this.keyCode == 0x1000002 || this.keyCode == 0x1000004) {
                    item = this.findNext(item);
                }
                if (item != null) {
                    item.getParent().select(item);
                }
            }
        }
    }

    public void keyPressed(KeyEvent event) {
        this.cancelSwitch();
        this.blockLetterOrDigit(event);
        this.keyPressed = true;
        this.keyCode = event.keyCode;
        TreeItem from = this.getSelection((TypedEvent)event);
        this.isFirst = this.isFirst(from);
        this.isLast = this.isLast(from);
    }

    public void keyReleased(KeyEvent event) {
        this.blockLetterOrDigit(event);
        if (event.stateMask == 0 && 0x1000001 == event.keyCode && this.isFirst) {
            this.createSwitchModuleOp().doSwitch(false);
        } else if (event.stateMask == 0 && 0x1000002 == event.keyCode && this.isLast) {
            this.createSwitchModuleOp().doSwitch(true);
        } else {
            this.startSwitch(this.getSelection((TypedEvent)event));
        }
        this.keyPressed = false;
    }

    private void blockLetterOrDigit(KeyEvent e) {
        if (Character.isLetterOrDigit(e.character) && !this.isCharacterNavigationEnabled()) {
            e.doit = false;
        }
    }

    private boolean isCharacterNavigationEnabled() {
        return LnfManager.getLnf().getBooleanSetting("navigation.charSelectionEnabled", false);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.keyPressed = false;
    }

    private void cancelSwitch() {
        if (this.nodeSwitcher != null) {
            this.nodeSwitcher.cancel();
        }
    }

    private SwitchModule createSwitchModuleOp() {
        SwitchModule result = new SwitchModule();
        result.setActivateSubmodule(true);
        return result;
    }

    private TreeItem findLast(Tree tree) {
        if (tree.isDisposed()) {
            return null;
        }
        TreeItem[] items = tree.getItems();
        return items.length > 0 ? this.findLast(items[items.length - 1]) : null;
    }

    private TreeItem findLast(TreeItem item) {
        TreeItem result = item;
        if (item.getExpanded() && item.getItemCount() > 0) {
            TreeItem last = item.getItem(item.getItemCount() - 1);
            result = this.findLast(last);
        }
        return result;
    }

    private static TreeItem findItem(TreeItem[] items, INavigationNode<?> source) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem result;
            TreeItem item = treeItemArray[n2];
            if (item.getData() == source) {
                return item;
            }
            TreeItem treeItem = result = item.getItemCount() > 0 ? ModuleNavigationListener.findItem(item.getItems(), source) : null;
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem findNext(TreeItem item) {
        TreeItem result;
        List<TreeItem> siblings = this.sequentialize(item.getParent().getItems());
        int index = siblings.indexOf(item);
        TreeItem treeItem = result = index != -1 && index < siblings.size() - 1 ? siblings.get(index + 1) : null;
        if (result != null && !this.isSelectable(result)) {
            result = this.findNext(result);
        }
        return result;
    }

    private TreeItem findPrevious(TreeItem item) {
        TreeItem result;
        List<TreeItem> siblings = this.sequentialize(item.getParent().getItems());
        int index = siblings.indexOf(item);
        TreeItem treeItem = result = index > 0 ? siblings.get(index - 1) : null;
        if (result != null && !this.isSelectable(result)) {
            result = this.findPrevious(result);
        }
        return result;
    }

    private TreeItem getSelection(TypedEvent event) {
        Tree tree = (Tree)event.widget;
        TreeItem result = null;
        if (tree.getSelectionCount() > 0) {
            result = tree.getSelection()[0];
        }
        return result;
    }

    private boolean isFirst(TreeItem item) {
        Tree tree;
        boolean result = false;
        if (item != null && (tree = item.getParent()).getItemCount() > 0) {
            result = tree.getItem(0) == item;
        }
        return result;
    }

    private boolean isLast(TreeItem item) {
        if (item == null) {
            return false;
        }
        return item == this.findLast(item.getParent());
    }

    private boolean isSelectable(TreeItem item) {
        boolean result = true;
        INavigationNode node = (INavigationNode)item.getData();
        if (node instanceof SubModuleNode) {
            result = this.isSelectableRoot((ISubModuleNode)((SubModuleNode)node));
        }
        return result;
    }

    private boolean isSelectableRoot(ISubModuleNode node) {
        if (node.isSelectable()) {
            return true;
        }
        List children = node.getChildren();
        for (ISubModuleNode child : children) {
            if (!this.isSelectableRoot(child)) continue;
            return true;
        }
        return false;
    }

    private List<TreeItem> sequentialize(TreeItem[] siblings) {
        ArrayList<TreeItem> stack = new ArrayList<TreeItem>(Arrays.asList(siblings));
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        while (!stack.isEmpty()) {
            TreeItem item = (TreeItem)stack.remove(0);
            result.add(item);
            if (!item.getExpanded()) continue;
            stack.addAll(0, Arrays.asList(item.getItems()));
        }
        return result;
    }

    private void startSwitch(TreeItem item) {
        this.cancelSwitch();
        if (item != null) {
            this.nodeSwitcher = this.createNodeSwitcher(item);
            this.nodeSwitcher.start();
        }
    }

    protected NodeSwitcher createNodeSwitcher(TreeItem item) {
        return new NodeSwitcher(item);
    }

    private static void activateNode(INavigationNode<?> node, Tree tree) {
        TreeItem item;
        INavigationNode selectedNode;
        node.setContext("fromUI", (Object)true);
        node.activate();
        if (!node.isActivated() && (selectedNode = node.getNavigationProcessor().getSelectedNode()) != null && (item = ModuleNavigationListener.findItem(tree.getItems(), selectedNode)) != null) {
            tree.setSelection(item);
        }
    }

    protected static class NodeSwitcher
    extends Thread {
        private static final int TIMEOUT_MS = RAPDetector.isRAPavailable() ? 50 : 300;
        protected final Display display;
        private final Tree tree;
        private final INavigationNode<?> node;
        private volatile boolean isCancelled;

        protected NodeSwitcher(TreeItem item) {
            this.display = item.getDisplay();
            this.tree = item.getParent();
            this.node = (INavigationNode)item.getData();
        }

        public void run() {
            try {
                NodeSwitcher.sleep(TIMEOUT_MS);
            }
            catch (InterruptedException interruptedException) {
                Nop.reason((String)"ignore");
            }
            if (!this.isCancelled) {
                this.display.syncExec(new Runnable(){

                    public void run() {
                        ModuleNavigationListener.activateNode(NodeSwitcher.this.node, NodeSwitcher.this.tree);
                    }
                });
            }
        }

        public void cancel() {
            this.isCancelled = true;
        }
    }
}

