/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleTreeItemMarkerRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.ui.core.marker.IIconizableMarker;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.ModuleTitleBar;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleView
implements INavigationNodeView<ModuleNode> {
    private static final String WINDOW_RIDGET = "windowRidget";
    private final LnFUpdater lnfUpdater = LnFUpdater.getInstance();
    private final AbstractViewBindingDelegate binding;
    private final Composite parent;
    private Composite body;
    private Tree subModuleTree;
    private ModuleNode moduleNode;
    private boolean pressed;
    private boolean hover;
    private ModuleTitleBar title;
    private BlockManager blockManager;
    private boolean doNotResize;
    private NavigationTreeObserver navigationTreeObserver;
    private final ListenerList<IComponentUpdateListener> updateListeners;
    private ModuleGroupNode moduleGroupNode;
    private Map<ISubModuleNode, Set<IMarker>> subModuleMarkerCache;
    private Listener disabledSubModuleTreeBgPainter;
    private SubModuleListener subModuleListener;
    private ModuleListener moduleListener;

    public ModuleView(Composite parent) {
        this.parent = parent;
        this.binding = this.createBinding();
        this.updateListeners = new ListenerList(IComponentUpdateListener.class);
        this.initializeSubModuleMarkerCache();
        this.buildView();
    }

    private void initializeSubModuleMarkerCache() {
        this.subModuleMarkerCache = new HashMap<ISubModuleNode, Set<IMarker>>();
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        this.updateListeners.add((Object)listener);
    }

    public void setModuleGroupNode(ModuleGroupNode moduleGroupNode) {
        this.moduleGroupNode = moduleGroupNode;
    }

    public ModuleGroupNode getModuleGroupNode() {
        return this.moduleGroupNode;
    }

    @Override
    public void bind(ModuleNode node) {
        this.moduleNode = node;
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.subModuleListener = new SubModuleListener();
        this.navigationTreeObserver.addListener((ISubModuleNodeListener)this.subModuleListener);
        this.moduleListener = new ModuleListener();
        this.navigationTreeObserver.addListener((IModuleNodeListener)this.moduleListener);
        this.navigationTreeObserver.addListenerTo((IModuleNode)this.moduleNode);
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)node.getNavigationNodeController();
            this.binding.injectRidgets(controller);
            this.binding.bind(controller);
            controller.afterBind();
        }
    }

    public void dispose() {
        if (this.subModuleListener != null) {
            this.navigationTreeObserver.removeListener((ISubModuleNodeListener)this.subModuleListener);
        }
        if (this.moduleListener != null) {
            this.navigationTreeObserver.removeListener((IModuleNodeListener)this.moduleListener);
        }
        this.subModuleMarkerCache.clear();
        this.unbind();
        SwtUtilities.dispose((Widget)this.title);
        SwtUtilities.dispose((Widget)this.getBody());
        SwtUtilities.dispose((Widget)this.getTree());
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.title.getBounds();
        if (this.getNavigationNode().isActivated()) {
            bounds.height += this.getBody().getSize().y;
        }
        return bounds;
    }

    public String getIcon() {
        if (this.getNavigationNode() == null) {
            return null;
        }
        return this.getNavigationNode().getIcon();
    }

    public String getLabel() {
        if (this.getNavigationNode() == null) {
            return null;
        }
        return this.getNavigationNode().getLabel();
    }

    @Override
    public ModuleNode getNavigationNode() {
        return this.moduleNode;
    }

    public int getOpenHeight() {
        ModuleNode navigationNode = this.getNavigationNode();
        if (navigationNode != null && navigationNode.isActivated()) {
            int depth = navigationNode.calcDepth();
            if (depth == 0) {
                return 0;
            }
            int itemHeight = this.getTree().getItemHeight();
            return depth * itemHeight + 1;
        }
        return 0;
    }

    public boolean isActivated() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isActivated();
    }

    public boolean isCloseable() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isClosable();
    }

    public boolean isHover() {
        return this.hover;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isVisible() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isVisible();
    }

    public void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }
    }

    public void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }
    }

    @Override
    public void unbind() {
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
            this.binding.unbind(controller);
        }
        this.navigationTreeObserver.removeListenerFrom((IModuleNode)this.moduleNode);
        this.moduleNode = null;
    }

    public void updateEnabled() {
        this.title.setEnabled(this.getNavigationNode().isEnabled());
        this.subModuleTree.setEnabled(this.title.isEnabled());
        this.title.redraw();
    }

    public void updateModuleView() {
        this.prepareUpdate();
        this.getParent().layout();
    }

    public void prepareUpdate() {
        boolean currentActiveState = false;
        if (this.getNavigationNode() != null) {
            currentActiveState = this.getNavigationNode().isActivated();
        }
        if (!SwtUtilities.isDisposed((Widget)this.title)) {
            this.layoutTitle();
            this.title.setWindowActive(currentActiveState);
        }
        if (!SwtUtilities.isDisposed((Widget)this.getBody())) {
            int height;
            if (this.getBody().isVisible() != currentActiveState) {
                this.getBody().setVisible(currentActiveState);
            }
            if (this.getBody().getSize().y != (height = this.getOpenHeight())) {
                FormData formData = new FormData();
                formData.top = new FormAttachment((Control)this.title);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = height;
                this.getBody().setLayoutData((Object)formData);
            }
        }
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    protected void createBodyContent(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.subModuleTree = new Tree(parent, 0x20000010);
        this.subModuleTree.setLinesVisible(false);
        RienaDefaultLnf lnf = LnfManager.getLnf();
        this.subModuleTree.setFont(lnf.getFont("SubModuleItem.font"));
        this.binding.addUIControl((Object)this.subModuleTree, "tree");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.subModuleTree.setLayoutData((Object)formData);
        this.subModuleTree.setData("kind", (Object)"navigation");
        this.addListeners();
        SWTFacade.getDefault().createSubModuleToolTip(this.subModuleTree, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((INavigationNode)element).getLabel();
            }
        });
        this.setTreeBackGround();
    }

    protected Listener createDisabledSubModuleTreeBackgroundPainter(Color disabledBackgroundColor) {
        return new DisabledSubModuleTreeBackgroundPainter(disabledBackgroundColor);
    }

    protected void fireUpdated(INavigationNode<?> node) {
        IComponentUpdateListener[] iComponentUpdateListenerArray = (IComponentUpdateListener[])this.updateListeners.getListeners();
        int n = iComponentUpdateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentUpdateListener listener = iComponentUpdateListenerArray[n2];
            listener.update(node);
            ++n2;
        }
    }

    public Composite getParent() {
        return this.parent;
    }

    protected ModuleTitleBar getTitle() {
        return this.title;
    }

    protected Tree getTree() {
        return this.subModuleTree;
    }

    protected void resize() {
        if (this.doNotResize) {
            return;
        }
        this.fireUpdated(null);
    }

    protected void setTreeBackGround() {
        this.subModuleTree.setBackground(LnfManager.getLnf().getColor("SubModuleTree.background"));
    }

    Composite getBody() {
        return this.body;
    }

    private void addListeners() {
        this.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.handleExpandCollapse(event, true);
            }
        });
        this.getTree().addListener(18, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.handleExpandCollapse(event, false);
            }
        });
        this.getTree().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ModuleView.this.getTree().redraw();
            }

            public void controlMoved(ControlEvent e) {
                Nop.reason((String)"nothing todo");
            }
        });
        Listener paintItemListener = new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.paintTreeItem(event);
            }
        };
        SWTFacade.getDefault().addPaintItemListener(this.getTree(), paintItemListener);
        SWTFacade.getDefault().attachModuleNavigationListener(this.getTree());
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Color disabledBackgroundColor = null;
        if (!lnf.getBooleanSetting("SubModuleTree.disabledBackgroundIsSWTDefault").booleanValue()) {
            disabledBackgroundColor = lnf.getColor("SubModuleTree.background");
        }
        this.disabledSubModuleTreeBgPainter = this.createDisabledSubModuleTreeBackgroundPainter(disabledBackgroundColor);
        SWTFacade.getDefault().addEraseItemListener(this.subModuleTree, this.disabledSubModuleTreeBgPainter);
    }

    private void blockView(boolean block) {
        if (this.blockManager == null) {
            this.blockManager = new BlockManager();
        }
        if (block) {
            this.blockManager.block();
        } else {
            this.blockManager.unblock();
        }
    }

    private void buildView() {
        this.title = new ModuleTitleBar(this.getParent(), 0);
        this.binding.addUIControl((Object)this.title, WINDOW_RIDGET);
        SWTFacade.getDefault().createEmbeddedTitleBarToolTip((EmbeddedTitleBar)this.title);
        this.body = new Composite(this.getParent(), 0x20000000);
        this.createBodyContent(this.body);
        this.lnfUpdater.updateUIControls(this.body, true);
    }

    private boolean clipSubModuleText(GC gc, TreeItem item) {
        boolean clipped = false;
        Rectangle treeBounds = this.getTree().getBounds();
        Rectangle itemBounds = item.getBounds();
        int maxWidth = treeBounds.width - itemBounds.x - 5;
        String longText = this.getItemText(item);
        if (longText != null) {
            String text = SwtUtilities.clipText((GC)gc, (String)longText, (int)maxWidth);
            clipped = !StringUtils.equals((CharSequence)longText, (CharSequence)text);
            boolean bl = clipped = clipped || !StringUtils.equals((CharSequence)item.getText(), (CharSequence)text);
            if (clipped) {
                item.setText(text);
            }
        }
        return clipped;
    }

    private boolean clipSubModuleTexts(GC gc, TreeItem item) {
        TreeItem[] items;
        boolean clipped = this.clipSubModuleText(gc, item);
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            if (this.clipSubModuleTexts(gc, childItem)) {
                clipped = true;
            }
            ++n2;
        }
        return clipped;
    }

    private String getItemText(TreeItem item) {
        INavigationNode node = (INavigationNode)item.getData();
        if (node != null) {
            return node.getLabel();
        }
        return item.getText();
    }

    private ModuleGroupRenderer getModuleGroupRenderer() {
        ModuleGroupRenderer renderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (renderer == null) {
            renderer = new ModuleGroupRenderer();
        }
        return renderer;
    }

    private SubModuleTreeItemMarkerRenderer getTreeItemRenderer() {
        SubModuleTreeItemMarkerRenderer renderer = (SubModuleTreeItemMarkerRenderer)LnfManager.getLnf().getRenderer("SubModuleTreeItemMarker.renderer");
        if (renderer == null) {
            renderer = new SubModuleTreeItemMarkerRenderer();
        }
        return renderer;
    }

    private void handleExpandCollapse(Event event, boolean expand) {
        if (event.item instanceof TreeItem) {
            TreeItem item = (TreeItem)event.item;
            INavigationNode node = (INavigationNode)item.getData();
            node.setExpanded(expand);
        }
        this.resize();
    }

    private void layoutTitle() {
        FormData formData = new FormData();
        int index = this.getModuleGroupNode().getIndexOfChild((INavigationNode)this.getNavigationNode());
        formData.top = index == 0 ? new FormAttachment(0, 0) : (index < 0 ? new FormAttachment(this.getModuleViewBody((IModuleNode)this.getModuleGroupNode().getChild(this.getModuleGroupNode().getChildren().size() - 1)), this.getModuleGroupRenderer().getModuleModuleGap()) : new FormAttachment(this.getModuleViewBody((IModuleNode)this.getModuleGroupNode().getChild(index - 1)), this.getModuleGroupRenderer().getModuleModuleGap()));
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.title.getSize().y;
        this.title.setLayoutData((Object)formData);
    }

    private Control getModuleViewBody(IModuleNode child) {
        for (ModuleView moduleView : this.getModuleGroupRenderer().getItems()) {
            if (moduleView.getNavigationNode() != child) continue;
            return moduleView.getBody();
        }
        return null;
    }

    private void paintTreeItem(Event event) {
        if (event.item instanceof TreeItem) {
            SubModuleTreeItemMarkerRenderer renderer = this.getTreeItemRenderer();
            renderer.setBounds(event.x, event.y, event.width, event.height);
            TreeItem item = (TreeItem)event.item;
            SubModuleNode node = (SubModuleNode)item.getData();
            if (node != null) {
                boolean deep = !item.getExpanded();
                Collection<? extends IMarker> markers = this.getAllMarkers((ISubModuleNode)node, deep);
                renderer.setMarkers(markers);
            }
            this.clipSubModuleTexts(event.gc, item);
            renderer.paint(event.gc, item);
        }
    }

    private Collection<? extends IMarker> getAllMarkers(ISubModuleNode node, boolean deep) {
        if (node == null || !node.isVisible()) {
            return Collections.emptySet();
        }
        HashSet<IMarker> markers = new HashSet<IMarker>();
        this.fillMarkers(node, deep, markers);
        return markers;
    }

    private void fillMarkers(ISubModuleNode node, boolean deep, Set<IMarker> markers) {
        if (!node.isVisible()) {
            return;
        }
        markers.addAll(Markable.getMarkersOfType((Collection)node.getMarkers(), IIconizableMarker.class));
        if (deep) {
            for (ISubModuleNode child : node.getChildren()) {
                this.fillMarkers(child, deep, markers);
            }
        }
    }

    private static TreeItem findItem(TreeItem[] items, ISubModuleNode source) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem result;
            TreeItem item = treeItemArray[n2];
            if (item.getData() == source) {
                return item;
            }
            TreeItem treeItem = result = item.getItemCount() > 0 ? ModuleView.findItem(item.getItems(), source) : null;
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private final class BlockManager {
        private Cursor titleOldCursor;
        private Cursor bodyOldCursor;
        private boolean isBlocked;

        private BlockManager() {
        }

        public void block() {
            if (!this.isBlocked) {
                this.titleOldCursor = ModuleView.this.title.getCursor();
                ModuleView.this.title.setCursor(this.getWaitCursor());
                ModuleView.this.title.setCloseable(false);
                if (this.disableTitle()) {
                    ModuleView.this.title.setEnabled(false);
                }
                this.bodyOldCursor = ModuleView.this.body.getCursor();
                ModuleView.this.body.setCursor(this.getWaitCursor());
                ModuleView.this.subModuleTree.setEnabled(false);
                this.isBlocked = true;
            }
        }

        public void unblock() {
            this.isBlocked = false;
            ModuleView.this.title.setCursor(this.titleOldCursor);
            ModuleView.this.title.setCloseable(ModuleView.this.getNavigationNode().isClosable());
            ModuleView.this.title.setEnabled(ModuleView.this.getNavigationNode().isEnabled());
            ModuleView.this.body.setCursor(this.bodyOldCursor);
            ModuleView.this.subModuleTree.setEnabled(true);
            ModuleView.this.subModuleTree.setFocus();
        }

        private boolean disableTitle() {
            ISubApplicationNode subApp = (ISubApplicationNode)ModuleView.this.getNavigationNode().getParentOfType(ISubApplicationNode.class);
            return subApp != null && subApp.isBlocked();
        }

        private Cursor getWaitCursor() {
            return ModuleView.this.parent.getDisplay().getSystemCursor(1);
        }
    }

    private class DisabledSubModuleTreeBackgroundPainter
    implements Listener {
        private final Color disabledBackgroundColor;

        public DisabledSubModuleTreeBackgroundPainter(Color disabledBackgroundColor) {
            this.disabledBackgroundColor = disabledBackgroundColor;
        }

        public void handleEvent(Event event) {
            if (!ModuleView.this.subModuleTree.isEnabled() && this.disabledBackgroundColor != null) {
                GC gc = event.gc;
                Rectangle area = ModuleView.this.subModuleTree.getClientArea();
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                gc.setBackground(this.disabledBackgroundColor);
                gc.fillRectangle(0, area.y, area.width, area.height);
                gc.setForeground(foreground);
                gc.setBackground(background);
            }
        }
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void activated(IModuleNode source) {
            super.activated((INavigationNode)source);
            ModuleView.this.updateModuleView();
        }

        public void block(IModuleNode source, boolean block) {
            ModuleView.this.blockView(block);
        }

        public void disposed(IModuleNode source) {
            super.disposed((INavigationNode)source);
            ModuleView.this.dispose();
        }

        public void markerChanged(IModuleNode source, IMarker marker) {
            super.markerChanged((INavigationNode)source, marker);
            ModuleView.this.title.setMarkers(source.getMarkers());
            ModuleView.this.updateEnabled();
        }

        public void nodeIdChange(IModuleNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            if (source.equals(ModuleView.this.getNavigationNode())) {
                SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode<?>)source, oldId, newId);
            }
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void beforeActivated(ISubModuleNode source) {
            Tree tree = ModuleView.this.getTree();
            if (tree.getSelectionCount() == 0 && tree.getItemCount() > 0) {
                TreeItem item = ModuleView.findItem(tree.getItems(), source);
                if (item == null) {
                    item = tree.getItem(0);
                }
                tree.select(item);
            }
        }

        public void activated(ISubModuleNode source) {
            ModuleView.this.doNotResize = true;
            this.updateExpanded(source);
            ModuleView.this.doNotResize = false;
            ModuleView.this.resize();
            TreeItem currentItem = ModuleView.findItem(ModuleView.this.getTree().getItems(), source);
            if (currentItem != null) {
                ModuleView.this.getTree().select(currentItem);
            }
            ModuleView.this.getTree().setFocus();
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            ModuleView.this.resize();
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            ModuleView.this.resize();
        }

        public void labelChanged(ISubModuleNode source) {
            super.labelChanged((INavigationNode)source);
            ModuleView.this.getTree().redraw();
        }

        public void markerChanged(ISubModuleNode source, IMarker marker) {
            if (this.isTreeRedrawOnMarkerChanged(source, marker)) {
                ModuleView.this.getTree().redraw();
            }
        }

        private boolean isTreeRedrawOnMarkerChanged(ISubModuleNode source, IMarker marker) {
            HashSet<IMarker> resultCache = (HashSet<IMarker>)ModuleView.this.subModuleMarkerCache.get(source);
            if (resultCache == null) {
                resultCache = new HashSet<IMarker>();
                ModuleView.this.subModuleMarkerCache.put(source, resultCache);
            }
            HashSet originalCache = new HashSet(resultCache);
            if (source.getMarkers().contains(marker)) {
                resultCache.add(marker);
            } else {
                resultCache.remove(marker);
            }
            return !resultCache.equals(originalCache);
        }

        private void updateExpanded(ISubModuleNode node) {
            INavigationNode nodeParent = node.getParent();
            if (nodeParent instanceof ISubModuleNode) {
                nodeParent.setExpanded(true);
                this.updateExpanded((ISubModuleNode)nodeParent);
            }
        }

        public void expandedChanged(ISubModuleNode source) {
            super.expandedChanged((INavigationNode)source);
            ModuleView.this.resize();
        }
    }
}

