/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.uiprocess.SwtUISynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTModuleController
extends ModuleController {
    private ITreeRidget tree;
    private static final String PROPERTY_ENABLED = "enabled";
    private static final String PROPERTY_VISIBLE = "visible";
    private static final String PROPERTY_IMAGE = "icon";
    private static final String PROPERTY_EXPANDED = "expanded";
    private final boolean showOneSubTree;
    private NavigationTreeObserver navigationTreeObserver;
    private ModuleGroupListener moduleGrouplistener;
    private IModuleGroupNode parentModuleGroup;

    public SWTModuleController(IModuleNode navigationNode) {
        super(navigationNode);
        this.addListeners();
        RienaDefaultLnf lnf = LnfManager.getLnf();
        this.showOneSubTree = lnf.getBooleanSetting("SubModuleTree.showOneSubTree", false);
    }

    public void setTree(ITreeRidget tree) {
        this.tree = tree;
    }

    public ITreeRidget getTree() {
        return this.tree;
    }

    public void afterBind() {
        super.afterBind();
        this.updateNavigationNodeMarkers();
        this.bindTree();
    }

    private void addListeners() {
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener((IModuleNodeListener)new ModuleListener());
        this.navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        this.navigationTreeObserver.addListenerTo((IModuleNode)this.getNavigationNode());
    }

    private void bindTree() {
        this.tree.setRootsVisible(false);
        Object[] roots = this.createTreeRootNodes();
        this.tree.bindToModel(roots, SubModuleNode.class, "children", "parent", "label", PROPERTY_ENABLED, PROPERTY_VISIBLE, PROPERTY_IMAGE, null, PROPERTY_EXPANDED);
        this.tree.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.selectActiveNode();
        this.tree.updateFromModel();
    }

    private IModuleNode[] createTreeRootNodes() {
        IModuleNode moduleNode = (IModuleNode)this.getNavigationNode();
        return new IModuleNode[]{moduleNode};
    }

    private void runAsync(Runnable op) {
        new SwtUISynchronizer().asyncExec(op);
    }

    private void selectActiveNode() {
        this.setSelectedNode(this.getNavigationNode());
    }

    private void showOneSubTree(ISubModuleNode activeNode) {
        if (this.isShowOneSubTree()) {
            this.collapseSibling(activeNode);
            ((IModuleNode)this.getNavigationNode()).getNavigationProcessor().markNodesToCollapse((INavigationNode)activeNode);
        }
    }

    private void collapseSibling(ISubModuleNode node) {
        INavigationNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        for (INavigationNode sibling : parent.getChildren()) {
            if (!(sibling instanceof ISubModuleNode)) continue;
            ISubModuleNode siblingSubModuleNode = (ISubModuleNode)sibling;
            if (siblingSubModuleNode != node && siblingSubModuleNode.isCloseSubTree() && siblingSubModuleNode.isExpanded()) {
                siblingSubModuleNode.setExpanded(false);
            }
            siblingSubModuleNode.setCloseSubTree(false);
            if (siblingSubModuleNode != node && !siblingSubModuleNode.isLeaf()) {
                this.collapseChildren(siblingSubModuleNode);
            }
            if (!(parent instanceof ISubModuleNode)) continue;
            this.collapseSibling((ISubModuleNode)parent);
            if (node == siblingSubModuleNode) continue;
            this.collapseChildren(siblingSubModuleNode);
        }
    }

    private void collapseChildren(ISubModuleNode node) {
        List childen = node.getChildren();
        for (ISubModuleNode child : childen) {
            if (child.isCloseSubTree() && child.isExpanded()) {
                child.setExpanded(false);
            }
            child.setCloseSubTree(false);
            this.collapseChildren(child);
        }
    }

    private void setSelectedNode(INavigationNode<?> node) {
        if (node.isActivated() && node != this.getNavigationNode()) {
            this.tree.setSelection(node);
            this.expandAllParents(node);
        }
        for (INavigationNode child : node.getChildren()) {
            this.setSelectedNode(child);
        }
    }

    private void expandAllParents(INavigationNode<?> node) {
        INavigationNode parent = node.getParent();
        while (parent instanceof SubModuleNode) {
            this.tree.expand((Object)parent);
            parent = parent.getParent();
        }
    }

    private boolean isShowOneSubTree() {
        return this.showOneSubTree;
    }

    protected void expandTree(ISubModuleNode source) {
        this.tree.expand((Object)source);
    }

    private void updateTree(ISubModuleNode source) {
        if (this.tree == null || !this.tree.isVisible()) {
            return;
        }
        if (source == null || !source.isVisible()) {
            return;
        }
        IModuleNode moduleNode = (IModuleNode)source.getParentOfType(IModuleNode.class);
        if (moduleNode != null && !moduleNode.isActivated()) {
            return;
        }
        this.tree.updateFromModel();
    }

    private class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void markerChanged(IModuleGroupNode source, IMarker marker) {
            super.markerChanged((INavigationNode)source, marker);
            if (marker instanceof DisabledMarker) {
                SWTModuleController.this.tree.updateFromModel();
            }
        }
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void childAdded(IModuleNode source, ISubModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (source.getIndexOfChild((INavigationNode)childAdded) < source.getChildren().size() - 1) {
                SWTModuleController.this.tree.updateFromModel();
                return;
            }
            SWTModuleController.this.updateTree(childAdded);
        }

        public void presentationChanged(IModuleNode source) {
            if (!((IModuleNode)SWTModuleController.this.getNavigationNode()).getNavigationNodeController().equals((Object)SWTModuleController.this)) {
                SWTModuleController.this.navigationTreeObserver.removeListenerFrom((IModuleNode)SWTModuleController.this.getNavigationNode());
            }
        }

        public void parentChanged(IModuleNode module) {
            super.parentChanged((INavigationNode)module);
            if (module.getParent() instanceof IModuleGroupNode) {
                if (SWTModuleController.this.moduleGrouplistener == null) {
                    SWTModuleController.this.moduleGrouplistener = new ModuleGroupListener();
                }
                SWTModuleController.this.parentModuleGroup = (IModuleGroupNode)module.getParent();
                SWTModuleController.this.parentModuleGroup.addListener((INavigationNodeListener)SWTModuleController.this.moduleGrouplistener);
            } else if (SWTModuleController.this.parentModuleGroup != null && SWTModuleController.this.moduleGrouplistener != null) {
                SWTModuleController.this.parentModuleGroup.removeListener((INavigationNodeListener)SWTModuleController.this.moduleGrouplistener);
                SWTModuleController.this.parentModuleGroup = null;
            }
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void afterActivated(final ISubModuleNode source) {
            SWTModuleController.this.runAsync(new Runnable(){

                public void run() {
                    SWTModuleController.this.selectActiveNode();
                    SWTModuleController.this.showOneSubTree(source);
                }
            });
        }

        public void expandedChanged(ISubModuleNode source) {
            super.expandedChanged((INavigationNode)source);
            if (SWTModuleController.this.tree != null) {
                if (source.isExpanded()) {
                    this.expandSubModuleNode(source);
                } else {
                    SWTModuleController.this.tree.collapse((Object)source);
                }
            }
        }

        protected void expandSubModuleNode(ISubModuleNode source) {
            SWTModuleController.this.expandTree(source);
            List children = source.getChildren();
            if (children.size() > 0) {
                for (ISubModuleNode child : children) {
                    if (!child.isExpanded()) continue;
                    this.expandSubModuleNode(child);
                }
            }
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            super.childRemoved((INavigationNode)source, (INavigationNode)childRemoved);
            if (SWTModuleController.this.tree != null) {
                if (source.getChildren().size() == 0) {
                    SWTModuleController.this.tree.collapse((Object)source);
                    return;
                }
                SWTModuleController.this.updateTree(childRemoved);
            }
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (source.getIndexOfChild((INavigationNode)childAdded) < source.getChildren().size() - 1) {
                SWTModuleController.this.tree.updateFromModel();
            } else {
                SWTModuleController.this.updateTree(childAdded);
            }
            if (source.getChildren().size() == 1 && source.isExpanded()) {
                SWTModuleController.this.tree.expand((Object)source);
            }
        }
    }
}

