/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.application;

import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.ui.Activator;
import org.eclipse.riena.internal.navigation.ui.filter.IUIFilterApplier;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.StartupNodeInfo;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.NavigationNodeProvider;
import org.eclipse.riena.navigation.ui.application.ProgressVisualizerLocator;
import org.eclipse.riena.navigation.ui.login.ILoginDialogViewExtension;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerLocator;
import org.eclipse.riena.ui.core.uiprocess.ProgressProviderBridge;
import org.eclipse.ui.internal.progress.ProgressManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplication
implements IApplication {
    public static final Integer EXIT_ABORT = -1;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), AbstractApplication.class);
    protected ILoginDialogViewExtension loginDialogViewExtension;

    public Object start(IApplicationContext context) throws Exception {
        Object result = this.initializePerformLogin(context);
        if (!EXIT_OK.equals(result)) {
            return this.convertLoginToApplicationResult(result);
        }
        this.initializeUI();
        IApplicationNode applicationNode = this.createModel();
        if (applicationNode == null) {
            throw new RuntimeException("Application did not return an ApplicationModel in method 'createModel' but returned NULL. Cannot continue");
        }
        this.applyUserInterfaceFilters(applicationNode);
        ApplicationNodeManager.registerApplicationNode((IApplicationNode)applicationNode);
        this.createStartupNodes(applicationNode);
        this.initializeNode(applicationNode);
        this.installProgressProviderBridge();
        return this.createView(context, applicationNode);
    }

    private void applyUserInterfaceFilters(IApplicationNode applicationNode) {
        IUIFilterApplier filter = (IUIFilterApplier)Service.get(IUIFilterApplier.class);
        if (filter != null) {
            filter.applyFilter((INavigationNode<?>)applicationNode);
        }
    }

    protected Object convertLoginToApplicationResult(Object result) {
        if (EXIT_ABORT.equals(result)) {
            return EXIT_OK;
        }
        return result;
    }

    protected void initializeUI() {
    }

    private void installProgressProviderBridge() {
        this.disableEclipseProgressManager();
        ProgressProviderBridge instance = ProgressProviderBridge.instance();
        Job.getJobManager().setProgressProvider((ProgressProvider)instance);
        instance.setVisualizerFactory((IProgressVisualizerLocator)new ProgressVisualizerLocator());
    }

    protected void disableEclipseProgressManager() {
        if (RAPDetector.isRAPavailable()) {
            return;
        }
        ProgressManager.getInstance();
        ProgressManager.shutdownProgressManager();
    }

    protected IApplicationNode createModel() {
        ApplicationNode applicationModel = new ApplicationNode(new NavigationNodeId("application"));
        return applicationModel;
    }

    protected void createStartupNodes(IApplicationNode applicationNode) {
        INavigationNodeProvider navigationNodeProvider = NavigationNodeProvider.getInstance();
        List startups = navigationNodeProvider.getSortedStartupNodeInfos();
        for (StartupNodeInfo startup : startups) {
            LOGGER.log(3, "creating " + startup.toString());
            applicationNode.create(new NavigationNodeId(startup.getId()));
        }
    }

    protected void initializeNode(IApplicationNode model) {
        this.initializeModelDefaults(model);
    }

    protected void initializeModelDefaults(IApplicationNode model) {
        this.initializeNodeDefaults(model);
    }

    protected void initializeNodeDefaults(IApplicationNode node) {
        for (ISubApplicationNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(ISubApplicationNode node) {
        for (IModuleGroupNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(IModuleGroupNode node) {
        for (IModuleNode child : node.getChildren()) {
            this.initializeNodeDefaults(child);
        }
    }

    protected void initializeNodeDefaults(IModuleNode node) {
        this.initializeNodeDefaultIcon((INavigationNode<?>)node);
    }

    protected void initializeNodeDefaultIcon(INavigationNode<?> node) {
    }

    protected abstract Object createView(IApplicationContext var1, IApplicationNode var2) throws Exception;

    protected Object initializePerformLogin(IApplicationContext context) throws Exception {
        this.initializeLoginViewDefinition();
        if (this.isDialogLogin(context)) {
            return this.performLogin(context);
        }
        return EXIT_OK;
    }

    protected boolean isDialogLogin(IApplicationContext context) {
        return this.loginDialogViewExtension != null;
    }

    protected boolean isSplashLogin(IApplicationContext context) {
        return false;
    }

    protected Object doPerformLogin(IApplicationContext context) {
        return EXIT_OK;
    }

    protected Object doPerformSplashLogin(IApplicationContext context) {
        return EXIT_OK;
    }

    protected Object performLogin(IApplicationContext context) throws Exception {
        if (this.isSplashLogin(context)) {
            return this.doPerformSplashLogin(context);
        }
        return this.doPerformLogin(context);
    }

    @InjectExtension
    public void update(ILoginDialogViewExtension[] data) {
        if (data.length > 0) {
            this.loginDialogViewExtension = data[0];
        }
    }

    protected void initializeLoginViewDefinition() {
        Wire.instance((Object)this).andStart(Activator.getDefault().getContext());
    }
}

