/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.List;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IAction;
import org.eclipse.riena.navigation.IJumpTargetListener;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationHistory;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.common.ITypecastingAdaptable;
import org.eclipse.riena.ui.core.IDisposable;
import org.eclipse.riena.ui.filter.IUIFilterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface INavigationNode<C extends INavigationNode<?>>
extends ITypecastingAdaptable,
IMarkable,
IUIFilterable,
IDisposable,
INavigationHistory {
    public static final String PROPERTY_LABEL = "label";

    public void activate();

    public void dispose();

    public void prepare();

    public void activate(INavigationContext var1);

    public void onBeforeActivate(INavigationContext var1);

    public void onAfterActivate(INavigationContext var1);

    public void dispose(INavigationContext var1);

    public void onBeforeDispose(INavigationContext var1);

    public void onAfterDispose(INavigationContext var1);

    public void deactivate(INavigationContext var1);

    public void onBeforeDeactivate(INavigationContext var1);

    public void onAfterDeactivate(INavigationContext var1);

    public void prepare(INavigationContext var1);

    public boolean allowsActivate(INavigationContext var1);

    public boolean allowsDeactivate(INavigationContext var1);

    public boolean allowsDispose(INavigationContext var1);

    public void removeChild(INavigationNode<?> var1);

    public List<C> getChildren();

    public void addChild(C var1);

    public void addChild(int var1, C var2);

    public C getChild(int var1);

    public INavigationNode<?> findNode(NavigationNodeId var1);

    public int getIndexOfChild(INavigationNode<?> var1);

    public INavigationNodeController getNavigationNodeController();

    public INavigationNodeController getNextNavigationNodeController();

    public void setNavigationNodeController(INavigationNodeController var1);

    public String getLabel();

    public void setLabel(String var1);

    public String getIcon();

    public void setIcon(String var1);

    public INavigationNode<?> getParent();

    public void setParent(INavigationNode<?> var1);

    public INavigationProcessor getNavigationProcessor();

    public void setNavigationProcessor(INavigationProcessor var1);

    public void addSimpleListener(ISimpleNavigationNodeListener var1);

    public void removeSimpleListener(ISimpleNavigationNodeListener var1);

    public boolean isExpanded();

    public void setExpanded(boolean var1);

    public boolean isLeaf();

    public IMarkable getMarkable();

    public Object getContext(String var1);

    public void setContext(String var1, Object var2);

    public void removeContext(String var1);

    public void addAction(IAction var1);

    public void removeAction(IAction var1);

    public Set<IAction> getActions();

    public Set<IAction> getAllActions();

    public State getState();

    public boolean isActivated();

    public boolean isPrepared();

    public boolean isDeactivated();

    public boolean isDisposed();

    public boolean isCreated();

    public boolean isSelected();

    public void setSelected(boolean var1);

    public <N extends INavigationNode<?>> N getParentOfType(Class<N> var1);

    public void setBlocked(boolean var1);

    public boolean isBlocked();

    public void setVisible(boolean var1);

    public boolean isVisible();

    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public NavigationNodeId getNodeId();

    public void setNodeId(NavigationNodeId var1);

    public void create(NavigationNodeId var1);

    public void create(NavigationNodeId var1, NavigationArgument var2);

    public void createAsync(NavigationNodeId var1, NavigationArgument var2);

    public void createAsync(NavigationNodeId var1);

    public void moveTo(NavigationNodeId var1);

    public void navigate(NavigationNodeId var1);

    public void navigate(NavigationNodeId var1, NavigationArgument var2);

    public void navigateBack();

    public void jump(NavigationNodeId var1);

    public void jump(NavigationNodeId var1, NavigationArgument var2);

    public void jumpBack();

    public boolean isJumpTarget();

    public void addJumpTargetListener(IJumpTargetListener var1);

    public void removeJumpTargetListener(IJumpTargetListener var1);

    public void addMarker(INavigationContext var1, IMarker var2);

    public Class<C> getValidChildType();

    public NavigationArgument getNavigationArgument();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        PREPARED,
        ACTIVATED,
        DEACTIVATED,
        DISPOSED;

    }
}

