/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.objecttransaction.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.objecttransaction.Activator;
import org.eclipse.riena.internal.objecttransaction.impl.ObjectTransactionExtractImpl;
import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.IObjectTransactionExtract;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.InvalidTransactionFailure;
import org.eclipse.riena.objecttransaction.ObjectTransactionFailure;
import org.eclipse.riena.objecttransaction.ObjectTransactionManager;
import org.eclipse.riena.objecttransaction.delta.AbstractBaseChange;
import org.eclipse.riena.objecttransaction.delta.MultipleChange;
import org.eclipse.riena.objecttransaction.delta.MultipleChangeEntry;
import org.eclipse.riena.objecttransaction.delta.SingleChange;
import org.eclipse.riena.objecttransaction.delta.TransactionDelta;
import org.eclipse.riena.objecttransaction.state.Action;
import org.eclipse.riena.objecttransaction.state.State;
import org.eclipse.riena.objecttransaction.state.StateMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTransactionImpl
implements IObjectTransaction {
    private Map<IObjectId, TransactionDelta> changesInTransaction = new HashMap<IObjectId, TransactionDelta>();
    private Map<IObjectId, ITransactedObject> involvedTransactedObjects = new HashMap<IObjectId, ITransactedObject>();
    private boolean rootTransaction = true;
    private ObjectTransactionImpl parentTransaction;
    private boolean cleanModus = false;
    private boolean invalidTransaction = false;
    private List<ITransactedObject> preRegisteredCleanObjects = null;
    private boolean strictModus = false;
    private boolean allowRegister = true;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ObjectTransactionImpl.class);

    public ObjectTransactionImpl() {
    }

    public ObjectTransactionImpl(IObjectTransaction parentTransaction) {
        this();
        this.parentTransaction = (ObjectTransactionImpl)parentTransaction;
        this.rootTransaction = false;
    }

    @Override
    public IObjectTransaction createSubObjectTransaction() {
        ObjectTransactionImpl objectTransaction = new ObjectTransactionImpl(this);
        ObjectTransactionManager.getInstance().setCurrent(objectTransaction);
        return objectTransaction;
    }

    @Override
    public void register(ITransactedObject object) {
        if (!this.allowRegister) {
            return;
        }
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isTrue((object.getObjectId() != null && !this.isRegistered(object) || object.getObjectId() == null ? 1 : 0) != 0, (String)"object cannot be registered a second time");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.keepReferenceOf(object);
        if (object.getObjectId() == null) {
            this.addPreRegisteredClean(object);
        } else {
            this.setObjectState(object, State.CLEAN);
        }
    }

    @Override
    public void registerNew(ITransactedObject object) {
        if (!this.allowRegister) {
            return;
        }
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isTrue((object.getObjectId() != null ? 1 : 0) != 0, (String)"ObjectId of Transacted Object must not be null");
        Assert.isTrue((!this.isRegistered(object) ? 1 : 0) != 0, (String)"Transacted Object must not be already registered");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.notifyObjectChange(object, Action.NEW);
    }

    @Override
    public void registerAsDeleted(ITransactedObject object) {
        if (!this.allowRegister) {
            return;
        }
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.notifyObjectChange(object, Action.DELETE);
    }

    @Override
    public void allowRegister(boolean parmAllowRegister) {
        this.allowRegister = parmAllowRegister;
    }

    @Override
    public IObjectTransactionExtract exportExtract() {
        return this.exportExtractInternal(true);
    }

    @Override
    public IObjectTransactionExtract exportOnlyModifedObjectsToExtract() {
        IObjectTransactionExtract extract = this.exportExtractInternal(false);
        TransactionDelta[] transactionDeltaArray = extract.getDeltas();
        int n = transactionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionDelta delta = transactionDeltaArray[n2];
            Collection<AbstractBaseChange> changes = delta.getChanges().values();
            for (AbstractBaseChange change : changes) {
                if (change instanceof SingleChange) {
                    SingleChange sChange = (SingleChange)change;
                    Object child = sChange.getChildObject();
                    if (child instanceof IObjectId) {
                        child = this.lookupObjectById((IObjectId)child);
                    }
                    if (!(child instanceof ITransactedObject) || extract.contains(((ITransactedObject)child).getObjectId())) continue;
                    extract.addCleanTransactedObject((ITransactedObject)child);
                    continue;
                }
                if (change instanceof MultipleChange) {
                    MultipleChange mChange = (MultipleChange)change;
                    for (MultipleChangeEntry mEntry : mChange.getEntries()) {
                        Object mChild = mEntry.getChildObject();
                        if (mChild instanceof IObjectId) {
                            mChild = this.lookupObjectById((IObjectId)mChild);
                        }
                        if (mChild instanceof ITransactedObject) {
                            if (extract.contains(((ITransactedObject)mChild).getObjectId())) continue;
                            extract.addCleanTransactedObject((ITransactedObject)mChild);
                            continue;
                        }
                        throw new ObjectTransactionFailure("non ITransactionObject in multi reference ???");
                    }
                    continue;
                }
                throw new ObjectTransactionFailure("unknown change typ (not single and not multi reference change)");
            }
            ++n2;
        }
        return extract;
    }

    private IObjectTransactionExtract exportExtractInternal(boolean exportClean) {
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        ObjectTransactionExtractImpl extract = new ObjectTransactionExtractImpl();
        try {
            for (TransactionDelta temp : this.changesInTransaction.values()) {
                if (temp.getState().equals(State.VANISHED) || !exportClean && temp.getState().equals(State.CLEAN)) continue;
                temp = (TransactionDelta)temp.clone();
                extract.addDelta(temp);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new ObjectTransactionFailure("error cloning TransactionDelta ", e);
        }
        return extract;
    }

    @Override
    public void importExtract(IObjectTransactionExtract extract) throws InvalidTransactionFailure {
        this.checkForRegisteredObjects();
        this.importExtractInternal(extract, true);
    }

    @Override
    public void importOnlyModifedObjectsFromExtract(IObjectTransactionExtract extract) throws InvalidTransactionFailure {
        this.checkForRegisteredObjects();
        TransactionDelta[] transactionDeltaArray = extract.getDeltas();
        int n = transactionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionDelta delta = transactionDeltaArray[n2];
            Collection<AbstractBaseChange> changes = delta.getChanges().values();
            for (AbstractBaseChange change : changes) {
                if (change instanceof SingleChange) {
                    SingleChange sChange = (SingleChange)change;
                    Object child = sChange.getChildObject();
                    boolean isRegistered = true;
                    if (child instanceof IObjectId) {
                        isRegistered = this.isRegistered((IObjectId)child);
                    } else if (child instanceof ITransactedObject) {
                        isRegistered = this.isRegistered((ITransactedObject)child);
                    }
                    if (isRegistered) continue;
                    throw new InvalidTransactionFailure("reference target object " + child + " must be registered before import");
                }
                if (change instanceof MultipleChange) {
                    MultipleChange mChange = (MultipleChange)change;
                    for (MultipleChangeEntry mEntry : mChange.getEntries()) {
                        Object mChild = mEntry.getChildObject();
                        boolean isRegistered = true;
                        if (mChild instanceof IObjectId) {
                            isRegistered = this.isRegistered((IObjectId)mChild);
                        } else if (mChild instanceof ITransactedObject) {
                            isRegistered = this.isRegistered((ITransactedObject)mChild);
                        } else {
                            throw new InvalidTransactionFailure("invalid object in multi-ref " + mChild);
                        }
                        if (isRegistered) continue;
                        throw new InvalidTransactionFailure("reference target object " + mChild + " must be registered before import");
                    }
                    continue;
                }
                throw new ObjectTransactionFailure("unknown change typ (not single and not multi reference change)");
            }
            ++n2;
        }
        this.importExtractInternal(extract, false);
    }

    private void checkForRegisteredObjects() throws InvalidTransactionFailure {
        Iterator<ITransactedObject> iterator;
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        if (!this.isRootTransaction()) {
            throw new InvalidTransactionFailure("object transaction must be the root transaction");
        }
        if (this.isCleanModus()) {
            throw new InvalidTransactionFailure("object transaction must NOT be in clean modus when importing");
        }
        this.checkPreRegisteredClean();
        if (this.preRegisteredCleanObjects != null && this.preRegisteredCleanObjects.size() > 0 && (iterator = this.preRegisteredCleanObjects.iterator()).hasNext()) {
            ITransactedObject object = iterator.next();
            if (object.getObjectId() != null) {
                throw new InvalidTransactionFailure("internal error, preregistered object found with ObjectId " + object);
            }
            throw new InvalidTransactionFailure("missing object id for object " + object);
        }
    }

    private void importExtractInternal(IObjectTransactionExtract extract, boolean importClean) throws InvalidTransactionFailure {
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        if (!this.isRootTransaction()) {
            throw new InvalidTransactionFailure("object transaction must be the root transaction");
        }
        if (this.isCleanModus()) {
            throw new InvalidTransactionFailure("object transaction must NOT be in clean modus when importing");
        }
        TransactionDelta[] deltas = extract.getDeltas();
        ObjectTransactionImpl tempSubTransaction = (ObjectTransactionImpl)this.createSubObjectTransaction();
        TransactionDelta[] transactionDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionDelta delta = transactionDeltaArray[n2];
            if (importClean || delta.getState() != State.CLEAN) {
                IObjectId objectId = delta.getObjectId();
                IObjectId newObjectId = null;
                String versionChange = null;
                if (delta.getSingleRefObject("sys::oldoid") != null) {
                    objectId = (IObjectId)delta.getSingleRefObject("sys::oldoid");
                    newObjectId = (IObjectId)delta.getSingleRefObject("sys::oid");
                }
                if (delta.getSingleRefObject("sys::version") != null) {
                    versionChange = (String)delta.getSingleRefObject("sys::version");
                }
                if (this.involvedTransactedObjects.get(objectId) == null) {
                    throw new ObjectTransactionFailure("ObjectIds for all imported deltas must exist in objectTransaction, not found=" + delta);
                }
                if (newObjectId != null) {
                    this.changeObjectId(objectId, newObjectId);
                    objectId = newObjectId;
                }
                if (versionChange != null) {
                    ITransactedObject transObject = this.involvedTransactedObjects.get(objectId);
                    transObject.setVersion(versionChange);
                }
                tempSubTransaction.involvedTransactedObjects.put(objectId, this.involvedTransactedObjects.get(objectId));
                tempSubTransaction.changesInTransaction.put(objectId, delta);
            }
            ++n2;
        }
        tempSubTransaction.commit();
    }

    @Override
    public boolean isRootTransaction() {
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        return this.rootTransaction;
    }

    private void setObjectState(ITransactedObject object, State state) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.keepReferenceOf(object);
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            delta = new TransactionDelta(object.getObjectId(), state, object.getVersion());
            this.changesInTransaction.put(object.getObjectId(), delta);
        } else {
            delta.setState(state);
        }
    }

    private State getObjectState(ITransactedObject object) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            if (this.parentTransaction != null) {
                return this.parentTransaction.getObjectState(object);
            }
            return null;
        }
        return delta.getState();
    }

    @Override
    public void setReference(ITransactedObject object, String refName, Object newValue) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        Assert.isTrue((!(newValue instanceof ITransactedObject) ? 1 : 0) != 0, (String)"setReference for Object must not pass a \"hidden\" ITransactedObject");
        this.checkPreRegisteredClean();
        if (!this.isCleanModus()) {
            Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        }
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        if (this.isCleanModus()) {
            return;
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            delta = new TransactionDelta(object.getObjectId(), State.CREATED, object.getVersion());
            this.changesInTransaction.put(object.getObjectId(), delta);
        } else if (delta.getState().equals(State.CLEAN)) {
            delta.setState(State.MODIFIED);
        }
        delta.setSingleRefObject(refName, newValue);
    }

    @Override
    public Object getReference(ITransactedObject object, String refName, Object defaultValue) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        Assert.isTrue((!(defaultValue instanceof ITransactedObject) ? 1 : 0) != 0, (String)"getReference for Object must not pass a \"hidden\" ITransactedObject for defaultValue");
        this.checkPreRegisteredClean();
        if (this.isCleanModus() || !this.isStrictModus() && !this.isRegistered(object)) {
            return defaultValue;
        }
        Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta != null && delta.hasSingleRefObject(refName)) {
            Object propValue = delta.getSingleRefObject(refName);
            if (propValue instanceof IObjectId) {
                return this.lookupObjectById((IObjectId)propValue);
            }
            return propValue;
        }
        if (this.parentTransaction != null) {
            return this.parentTransaction.getReference(object, refName, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public void setReference(ITransactedObject object, String relationName, ITransactedObject refObject) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        this.checkPreRegisteredClean();
        if (!this.isCleanModus()) {
            Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
            Assert.isTrue((refObject == null || refObject.getObjectId() != null && this.isRegistered(refObject) ? 1 : 0) != 0, (String)"invalid refObject");
        }
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        if (this.isCleanModus()) {
            return;
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            delta = new TransactionDelta(object.getObjectId(), State.CREATED, object.getVersion());
            this.changesInTransaction.put(object.getObjectId(), delta);
        } else if (delta.getState().equals(State.CLEAN)) {
            delta.setState(State.MODIFIED);
        }
        IObjectId id2 = null;
        if (refObject != null) {
            id2 = refObject.getObjectId();
        }
        delta.setSingleRefObject(relationName, id2);
    }

    @Override
    public ITransactedObject getReference(ITransactedObject object, String relationName, ITransactedObject defaultRefObject) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        this.checkPreRegisteredClean();
        if (this.isCleanModus() || !this.isStrictModus() && !this.isRegistered(object)) {
            return defaultRefObject;
        }
        Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        Assert.isTrue((defaultRefObject == null || defaultRefObject.getObjectId() != null && this.isRegistered(defaultRefObject) ? 1 : 0) != 0, (String)"invalid defaultRefObject (is null, has no ObjectId or is not registered)");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta != null && delta.hasSingleRefObject(relationName)) {
            Object refObject = delta.getSingleRefObject(relationName);
            if (refObject != null) {
                if (refObject instanceof IObjectId) {
                    return this.lookupObjectById((IObjectId)refObject);
                }
                throw new InvalidTransactionFailure("how did I ever get here ???");
            }
            return null;
        }
        if (this.parentTransaction != null) {
            return this.parentTransaction.getReference(object, relationName, defaultRefObject);
        }
        return defaultRefObject;
    }

    @Override
    public void addReference(ITransactedObject object, String referenceName, ITransactedObject refObject) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        this.checkPreRegisteredClean();
        if (!this.isCleanModus()) {
            Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        }
        Assert.isNotNull((Object)refObject, (String)"refObject must not be null");
        Assert.isNotNull((Object)refObject.getObjectId(), (String)"ObjectId of refObject must not be null");
        if (!this.isCleanModus()) {
            Assert.isTrue((boolean)this.isRegistered(refObject), (String)"refObject must be registered");
        }
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        if (this.isCleanModus()) {
            return;
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            delta = new TransactionDelta(object.getObjectId(), State.CREATED, object.getVersion());
            this.changesInTransaction.put(object.getObjectId(), delta);
        } else if (delta.getState().equals(State.CLEAN)) {
            delta.setState(State.MODIFIED);
        }
        delta.addMultiRefObject(referenceName, refObject.getObjectId());
    }

    @Override
    public void removeReference(ITransactedObject object, String referenceName, ITransactedObject refObject) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        this.checkPreRegisteredClean();
        if (!this.isCleanModus()) {
            Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        }
        Assert.isNotNull((Object)refObject, (String)"object must not be null");
        Assert.isNotNull((Object)refObject.getObjectId(), (String)"ObjectId of object must not be null");
        if (!this.isCleanModus() || this.isStrictModus()) {
            Assert.isTrue((boolean)this.isRegistered(refObject), (String)"refObject must be registered");
        }
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        if (this.isCleanModus()) {
            return;
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            delta = new TransactionDelta(object.getObjectId(), State.CREATED, object.getVersion());
            this.changesInTransaction.put(object.getObjectId(), delta);
        } else if (delta.getState().equals(State.CLEAN)) {
            delta.setState(State.MODIFIED);
        }
        delta.removeMultiRefObject(referenceName, refObject.getObjectId());
    }

    @Override
    public <T> Set<T> listReference(ITransactedObject object, String referenceName, Set<T> initialSet) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        this.checkPreRegisteredClean();
        if (this.isCleanModus() || !this.isStrictModus() && !this.isRegistered(object)) {
            return initialSet;
        }
        Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        LinkedHashSet<Object> newSet = initialSet == null ? new LinkedHashSet() : new LinkedHashSet<T>(initialSet);
        this.fillReference(object, referenceName, newSet);
        return newSet;
    }

    @Override
    public <T> List<T> listReference(ITransactedObject object, String referenceName, List<T> initialList) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        this.checkPreRegisteredClean();
        if (this.isCleanModus() || !this.isStrictModus() && !this.isRegistered(object)) {
            return initialList;
        }
        Assert.isTrue((boolean)this.isRegistered(object), (String)"object must be registered");
        ArrayList<Object> newList = initialList == null ? new ArrayList() : new ArrayList<T>(initialList);
        this.fillReference(object, referenceName, newList);
        return newList;
    }

    private <T> void fillReference(ITransactedObject object, String referenceName, Collection<T> initialCollection) {
        TransactionDelta delta;
        if (this.parentTransaction != null) {
            this.parentTransaction.fillReference(object, referenceName, initialCollection);
        }
        if ((delta = this.changesInTransaction.get(object.getObjectId())) != null) {
            for (AbstractBaseChange cEntry : delta.getChanges().values()) {
                if (!cEntry.getRelationName().equals(referenceName) || !(cEntry instanceof MultipleChange)) continue;
                List<MultipleChangeEntry> changes = ((MultipleChange)cEntry).getEntries();
                for (MultipleChangeEntry singleEntry : changes) {
                    ITransactedObject tObject = this.lookupObjectById((IObjectId)singleEntry.getChildObject());
                    if (singleEntry.getState().equals(State.ADDED)) {
                        initialCollection.add(tObject);
                        continue;
                    }
                    if (singleEntry.getState().equals(State.REMOVED)) {
                        initialCollection.remove(tObject);
                        continue;
                    }
                    throw new InvalidTransactionFailure("state was not ADDED or REMOVED for " + singleEntry);
                }
            }
        }
    }

    @Override
    public void setVersionUpdate(ITransactedObject object, String version) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"object ObjectId must not be null");
        Assert.isTrue((!this.isInvalid() ? 1 : 0) != 0, (String)"must not be an invalid transaction");
        Assert.isTrue((!this.isCleanModus() ? 1 : 0) != 0, (String)"must not be in clean modus");
        this.setReference(object, "sys::version", version);
        object.setVersion(version);
    }

    @Override
    public void setObjectIdUpdate(IObjectId oldObjectId, IObjectId newObjectId) {
        Assert.isTrue((oldObjectId != null && newObjectId != null ? 1 : 0) != 0, (String)"old and new ObjectId must not be null");
        Assert.isTrue((oldObjectId != newObjectId ? 1 : 0) != 0, (String)"instance of oldObjectId and newObjectId must not be the same");
        this.checkPreRegisteredClean();
        this.changeObjectId(oldObjectId, newObjectId);
    }

    private void changeObjectId(IObjectId oldObjectId, IObjectId newObjectId) {
        Assert.isNotNull((Object)oldObjectId, (String)"oldObjectId must not be null");
        Assert.isNotNull((Object)newObjectId, (String)"newObjectId must not be null");
        ITransactedObject transObject = this.lookupObjectById(oldObjectId);
        if (transObject == null) {
            throw new ObjectTransactionFailure("oldObjectId is not registered");
        }
        transObject.setObjectId(newObjectId);
        this.involvedTransactedObjects.remove(oldObjectId);
        this.involvedTransactedObjects.put(newObjectId, transObject);
        TransactionDelta delta = this.changesInTransaction.get(oldObjectId);
        if (delta != null) {
            this.changesInTransaction.remove(oldObjectId);
            this.changesInTransaction.put(newObjectId, delta);
            delta.setObjectId(newObjectId);
        }
        for (TransactionDelta delta2 : this.changesInTransaction.values()) {
            for (AbstractBaseChange cEntry : delta2.getChanges().values()) {
                if (cEntry instanceof SingleChange) {
                    Object child = ((SingleChange)cEntry).getChildObject();
                    if (!(child instanceof ITransactedObject) || !((ITransactedObject)child).getObjectId().equals(oldObjectId)) continue;
                    ((ITransactedObject)child).setObjectId(newObjectId);
                    continue;
                }
                List<MultipleChangeEntry> changes = ((MultipleChange)cEntry).getEntries();
                for (MultipleChangeEntry singleEntry : changes) {
                    if (!(singleEntry.getChildObject() instanceof ITransactedObject) || !((ITransactedObject)singleEntry.getChildObject()).getObjectId().equals(oldObjectId)) continue;
                    ((ITransactedObject)singleEntry.getChildObject()).setObjectId(newObjectId);
                }
            }
        }
        this.setReference(transObject, "sys::oid", newObjectId);
        this.setReference(transObject, "sys::oldoid", oldObjectId);
    }

    @Override
    public boolean isRegistered(ITransactedObject object) {
        boolean isRegistered;
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"object ObjectId must not be null");
        Assert.isTrue((!this.isInvalid() ? 1 : 0) != 0, (String)"must not be an invalid transaction");
        this.checkPreRegisteredClean();
        boolean bl = isRegistered = this.changesInTransaction.get(object.getObjectId()) != null;
        if (!isRegistered && this.parentTransaction != null) {
            isRegistered = this.parentTransaction.isRegistered(object);
            this.keepReferenceOf(object);
        }
        return isRegistered;
    }

    private boolean isRegistered(IObjectId object) {
        boolean isRegistered;
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isTrue((!this.isInvalid() ? 1 : 0) != 0, (String)"must not be an invalid transaction");
        this.checkPreRegisteredClean();
        boolean bl = isRegistered = this.changesInTransaction.get(object) != null;
        if (!isRegistered && this.parentTransaction != null) {
            isRegistered = this.parentTransaction.isRegistered(object);
        }
        return isRegistered;
    }

    private void notifyObjectChange(ITransactedObject object, Action action) {
        Assert.isNotNull((Object)object, (String)"object must not be null");
        Assert.isNotNull((Object)object.getObjectId(), (String)"ObjectId of object must not be null");
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.keepReferenceOf(object);
        if (this.isCleanModus()) {
            return;
        }
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            delta = new TransactionDelta(object.getObjectId(), StateMachine.initAction(action), object.getVersion());
            this.changesInTransaction.put(object.getObjectId(), delta);
        } else {
            delta.setState(StateMachine.processAction(delta.getState(), action));
        }
    }

    private void keepReferenceOf(ITransactedObject object) {
        if (object == null || object.getObjectId() == null) {
            return;
        }
        this.involvedTransactedObjects.put(object.getObjectId(), object);
    }

    private void addPreRegisteredClean(ITransactedObject object) {
        Assert.isTrue((boolean)this.isCleanModus(), (String)"can only register objects with no IObjectId in clean modus");
        Assert.isTrue((object.getObjectId() == null ? 1 : 0) != 0, (String)"can only preregister object where the IObjectId is null");
        if (this.preRegisteredCleanObjects == null) {
            this.preRegisteredCleanObjects = new ArrayList<ITransactedObject>();
        }
        this.preRegisteredCleanObjects.add(object);
    }

    private void checkPreRegisteredClean() {
        if (this.preRegisteredCleanObjects == null || this.preRegisteredCleanObjects.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.preRegisteredCleanObjects.size()) {
            ITransactedObject object = this.preRegisteredCleanObjects.get(i);
            if (object.getObjectId() != null) {
                this.preRegisteredCleanObjects.remove(object);
                this.changesInTransaction.put(object.getObjectId(), new TransactionDelta(object.getObjectId(), State.CLEAN, object.getVersion()));
                this.keepReferenceOf(object);
                --i;
            }
            ++i;
        }
    }

    @Override
    public void setCleanModus(boolean cleanModus) {
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.checkPreRegisteredClean();
        this.cleanModus = cleanModus;
        if (!cleanModus && this.preRegisteredCleanObjects != null && this.preRegisteredCleanObjects.size() > 0) {
            LOGGER.log(2, "The cleanModus is set to false in objectTransaction with the consequence that 'preregistered' object (objects with a 'null' oid) are removed and no longe registered. Your ObjectTransaction has " + this.preRegisteredCleanObjects.size() + " of such objects.");
            for (ITransactedObject transObject : this.preRegisteredCleanObjects) {
                LOGGER.log(3, "removing " + transObject);
            }
            this.preRegisteredCleanObjects = new ArrayList<ITransactedObject>();
        }
    }

    @Override
    public boolean isCleanModus() {
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        return this.cleanModus;
    }

    @Override
    public void setStrictModus(boolean strictModus) {
        this.checkPreRegisteredClean();
        this.strictModus = strictModus;
    }

    @Override
    public boolean isStrictModus() {
        return this.strictModus;
    }

    private void internalCommit() {
        for (ITransactedObject transObject : this.involvedTransactedObjects.values()) {
            if (this.parentTransaction.involvedTransactedObjects.get(transObject.getObjectId()) == null) {
                this.parentTransaction.involvedTransactedObjects.put(transObject.getObjectId(), transObject);
            }
            if (this.parentTransaction.changesInTransaction.get(transObject.getObjectId()) != null) continue;
            this.parentTransaction.changesInTransaction.put(transObject.getObjectId(), new TransactionDelta(transObject.getObjectId(), State.CLEAN, transObject.getVersion()));
        }
        for (TransactionDelta delta : this.changesInTransaction.values()) {
            ITransactedObject usedObject = this.lookupObjectById(delta.getObjectId());
            if (!this.parentTransaction.isRegistered(usedObject)) {
                this.parentTransaction.setObjectState(usedObject, this.getObjectState(usedObject));
            }
            for (AbstractBaseChange cEntry : delta.getChanges().values()) {
                if (cEntry instanceof SingleChange) {
                    this.parentTransaction.setReference(usedObject, ((SingleChange)cEntry).getRelationName(), ((SingleChange)cEntry).getChildObject());
                    continue;
                }
                List<MultipleChangeEntry> changes = ((MultipleChange)cEntry).getEntries();
                for (MultipleChangeEntry singleEntry : changes) {
                    if (singleEntry.getState().equals(State.ADDED)) {
                        this.parentTransaction.addReference(usedObject, ((MultipleChange)cEntry).getRelationName(), this.lookupObjectById((IObjectId)singleEntry.getChildObject()));
                        continue;
                    }
                    if (singleEntry.getState().equals(State.REMOVED)) {
                        this.parentTransaction.removeReference(usedObject, ((MultipleChange)cEntry).getRelationName(), this.lookupObjectById((IObjectId)singleEntry.getChildObject()));
                        continue;
                    }
                    throw new InvalidTransactionFailure("state is not ADD and not REMOVED for " + singleEntry);
                }
            }
            if (delta.getState().equals(State.CLEAN)) continue;
            this.parentTransaction.setObjectState(usedObject, StateMachine.mergeStates(this.parentTransaction.getObjectState(usedObject), delta.getState()));
        }
    }

    @Override
    public void commit() {
        Assert.isTrue((!this.isInvalid() ? 1 : 0) != 0, (String)"must not be an invalid transaction");
        Assert.isTrue((!this.isRootTransaction() ? 1 : 0) != 0, (String)"must not be root transaction to commit");
        this.internalCommit();
        this.clearChanges();
        ObjectTransactionManager.getInstance().setCurrent(this.parentTransaction);
    }

    private Method findMethod(Class<?> clazz, String name, String methodPrefix, Object arg) {
        String methodName = String.valueOf(methodPrefix) + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                Class<?>[] parmType = method.getParameterTypes();
                if (parmType.length == 1) {
                    if (arg != null && parmType[0].isAssignableFrom(arg.getClass()) || arg == null) {
                        method.setAccessible(true);
                        return method;
                    }
                } else if (parmType.length == 0 && arg == null) {
                    method.setAccessible(true);
                    return method;
                }
            }
            ++n2;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (!superClass.equals(Object.class)) {
            return this.findMethod(superClass, name, methodPrefix, arg);
        }
        throw new ObjectTransactionFailure("ITransactedObject " + clazz + " must have method " + methodName + " but lookup fails.");
    }

    @Override
    public void commitToObjects() {
        ITransactedObject usedObject;
        Assert.isTrue((!this.isInvalid() ? 1 : 0) != 0, (String)"must not be an invalid transaction");
        Assert.isTrue((boolean)this.isRootTransaction(), (String)"must be rootTransaction");
        boolean savedCleanModus = this.cleanModus;
        this.cleanModus = false;
        for (TransactionDelta delta : this.changesInTransaction.values()) {
            usedObject = this.lookupObjectById(delta.getObjectId());
            for (AbstractBaseChange cEntry : delta.getChanges().values()) {
                String refName = cEntry.getRelationName();
                if (cEntry instanceof SingleChange) {
                    try {
                        if (refName.equals("sys::oid") || refName.equals("sys::oldoid") || refName.equals("sys::version")) continue;
                        Object value = ((SingleChange)cEntry).getChildObject();
                        if (value instanceof IObjectId) {
                            value = this.lookupObjectById((IObjectId)value);
                        }
                        Method setMethod = this.findMethod(usedObject.getClass(), refName, "set", value);
                        this.cleanModus = true;
                        setMethod.invoke((Object)usedObject, value);
                        this.cleanModus = false;
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new ObjectTransactionFailure("access to field blocked field " + refName + " in object " + usedObject, e);
                    }
                    catch (InvocationTargetException e2) {
                        throw new ObjectTransactionFailure("problem while accessing field blocked field " + refName + " in object " + usedObject, e2);
                    }
                }
                try {
                    this.cleanModus = true;
                    Method addMethod = null;
                    Method removeMethod = null;
                    List<MultipleChangeEntry> changes = ((MultipleChange)cEntry).getEntries();
                    for (MultipleChangeEntry singleEntry : changes) {
                        ITransactedObject value;
                        if (singleEntry.getState().equals(State.ADDED)) {
                            value = this.lookupObjectById((IObjectId)singleEntry.getChildObject());
                            if (addMethod == null) {
                                addMethod = this.findMethod(usedObject.getClass(), refName, "add", value);
                            }
                            addMethod.invoke((Object)usedObject, value);
                            continue;
                        }
                        if (!singleEntry.getState().equals(State.REMOVED)) continue;
                        value = this.lookupObjectById((IObjectId)singleEntry.getChildObject());
                        if (removeMethod == null) {
                            removeMethod = this.findMethod(usedObject.getClass(), refName, "remove", value);
                        }
                        removeMethod.invoke((Object)usedObject, value);
                    }
                    this.cleanModus = false;
                }
                catch (IllegalAccessException e) {
                    throw new ObjectTransactionFailure("access to field blocked field " + refName + " in object " + usedObject, e);
                }
                catch (InvocationTargetException e2) {
                    throw new ObjectTransactionFailure("problem while accessing field blocked field " + refName + " in object " + usedObject, e2);
                }
            }
        }
        for (TransactionDelta delta : this.changesInTransaction.values()) {
            usedObject = this.lookupObjectById(delta.getObjectId());
            if (!delta.getState().equals(State.DELETED)) continue;
            this.involvedTransactedObjects.remove(usedObject.getObjectId());
        }
        this.cleanModus = savedCleanModus;
        this.changesInTransaction = new HashMap<IObjectId, TransactionDelta>();
        Collection<ITransactedObject> transactedObject = this.involvedTransactedObjects.values();
        if (transactedObject != null) {
            ITransactedObject[] arrayValues;
            ITransactedObject[] iTransactedObjectArray = arrayValues = transactedObject.toArray(new ITransactedObject[transactedObject.size()]);
            int n = arrayValues.length;
            int n2 = 0;
            while (n2 < n) {
                ITransactedObject object = iTransactedObjectArray[n2];
                this.setObjectState(object, State.CLEAN);
                ++n2;
            }
        }
    }

    @Override
    public void rollback() {
        if (this.isInvalid()) {
            throw new InvalidTransactionFailure("object transaction is invalid");
        }
        this.clearChanges();
        if (!this.isRootTransaction()) {
            ObjectTransactionManager.getInstance().setCurrent(this.parentTransaction);
        }
    }

    private void clearChanges() {
        this.changesInTransaction = new HashMap<IObjectId, TransactionDelta>();
        this.involvedTransactedObjects = new HashMap<IObjectId, ITransactedObject>();
    }

    @Override
    public ITransactedObject lookupObjectById(IObjectId objectId) {
        this.checkPreRegisteredClean();
        ITransactedObject tObject = this.involvedTransactedObjects.get(objectId);
        if (tObject == null && this.parentTransaction != null) {
            tObject = this.parentTransaction.lookupObjectById(objectId);
            this.keepReferenceOf(tObject);
        }
        return tObject;
    }

    @Override
    public void replaceRegisteredObject(IObjectId objectId, ITransactedObject transactedObject) {
        Assert.isTrue((boolean)objectId.equals(transactedObject.getObjectId()), (String)"oldObjectId and new transactedobject must have the an 'equal' OID");
        ITransactedObject tObject = this.involvedTransactedObjects.get(objectId);
        Assert.isTrue((transactedObject != tObject ? 1 : 0) != 0, (String)"object instances of the existing registered transacted object and the new object must not be the same or this call is meaningless");
        if (tObject != null) {
            this.involvedTransactedObjects.put(tObject.getObjectId(), transactedObject);
        }
        if (this.parentTransaction != null) {
            this.parentTransaction.replaceRegisteredObject(objectId, transactedObject);
        }
    }

    private void invalidate() {
        this.invalidTransaction = true;
    }

    @Override
    public boolean isInvalid() {
        return this.invalidTransaction;
    }

    public boolean isState(ITransactedObject object, State state) {
        TransactionDelta delta = this.changesInTransaction.get(object.getObjectId());
        if (delta == null) {
            return false;
        }
        return delta.getState().equals(state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("----------transaction----------------\n");
        if (!this.isInvalid()) {
            TransactionDelta[] transactionDeltaArray = this.exportExtract().getDeltas();
            int n = transactionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransactionDelta delta = transactionDeltaArray[n2];
                sb.append(delta);
                ++n2;
            }
        } else {
            sb.append("Transaction is invalid and cannot be displayed.");
        }
        sb.append("----------transaction----------------\n");
        return sb.toString();
    }
}

