/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class SnippetTreeRidget005 {
    public SnippetTreeRidget005(Shell shell) {
        Tree tree = new Tree((Composite)shell, 65536);
        ITreeRidget treeRidget = (ITreeRidget)SwtRidgetFactory.createRidget((Object)tree);
        WordNodeWithIcon[] roots = this.createTreeInput();
        treeRidget.bindToModel((Object[])roots, WordNodeWithIcon.class, "children", "parent", "word", null, null, "icon", "openIcon");
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = new Shell();
            shell.setLayout((Layout)new FillLayout());
            shell.setText(SnippetTreeRidget005.class.getSimpleName());
            new SnippetTreeRidget005(shell);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private WordNodeWithIcon[] createTreeInput() {
        WordNodeWithIcon root = new WordNodeWithIcon("Alphabet");
        WordNodeWithIcon node1 = new WordNodeWithIcon(root, "A-Z (English)");
        node1.setIcons("IMG_CHECKED", "IMG_UNCHECKED");
        WordNodeWithIcon nodeEye = new WordNodeWithIcon(node1, "Eye");
        nodeEye.setIcons("IMG_UNCHECKED", null);
        WordNodeWithIcon nodeBe = new WordNodeWithIcon(node1, "Be");
        nodeBe.setIcons("IMG_CHECKED", null);
        new WordNodeWithIcon(node1, "See");
        new WordNodeWithIcon(node1, "Dii");
        WordNodeWithIcon node2 = new WordNodeWithIcon(root, "A-Z (German)");
        node2.setIcons(null, "IMG_UNCHECKED");
        new WordNodeWithIcon(node2, "Ah");
        new WordNodeWithIcon(node2, "Beh");
        new WordNodeWithIcon(node2, "Zeh");
        new WordNodeWithIcon(node2, "Deh");
        WordNodeWithIcon node3 = new WordNodeWithIcon(root, "A-Z (Greek)");
        node3.setIcons("IMG_CHECKED", null);
        new WordNodeWithIcon(node3, "Alpha");
        new WordNodeWithIcon(node3, "Beta");
        new WordNodeWithIcon(node3, "Gamma");
        new WordNodeWithIcon(node3, "Delta");
        return new WordNodeWithIcon[]{root};
    }

    private class WordNodeWithIcon
    extends WordNode {
        private String icon;
        private String openIcon;

        public WordNodeWithIcon(String word) {
            super(word);
        }

        public WordNodeWithIcon(WordNodeWithIcon parent, String word) {
            super((WordNode)parent, word);
        }

        public String getIcon() {
            return this.icon;
        }

        public String getOpenIcon() {
            return this.openIcon;
        }

        public void setIcons(String icon, String openIcon) {
            this.icon = icon;
            this.openIcon = openIcon;
        }
    }
}

