/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.eclipse.riena.security.common.authorization.IPermissionCache;
import org.eclipse.riena.security.common.authorization.ISentinelService;

public class SentinelServiceImpl
implements ISentinelService {
    private IPermissionCache permCache;
    private ISubjectHolder subjectHolder;
    private IAuthorizationService authService;

    public void bind(IPermissionCache permCache) {
        this.permCache = permCache;
    }

    public void unbind(IPermissionCache permCache) {
        if (permCache == this.permCache) {
            this.permCache = null;
        }
    }

    public void bind(ISubjectHolder subjectHolder) {
        this.subjectHolder = subjectHolder;
    }

    public void unbind(ISubjectHolder subjectHolder) {
        if (subjectHolder == this.subjectHolder) {
            this.subjectHolder = null;
        }
    }

    public void bind(IAuthorizationService authService) {
        this.authService = authService;
    }

    public void unbind(IAuthorizationService authService) {
        if (authService == this.authService) {
            this.authService = null;
        }
    }

    public boolean checkAccess(Permission permission) {
        Subject subject = this.getSubjectHolder().getSubject();
        if (subject != null) {
            Permissions permissions = this.getPermissions(subject);
            boolean result = permissions.implies(permission);
            return result;
        }
        return false;
    }

    protected IPermissionCache getPermissionCache() {
        return this.permCache;
    }

    protected ISubjectHolder getSubjectHolder() {
        return this.subjectHolder;
    }

    private Permissions getPermissions(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Permissions allPerms = new Permissions();
        ArrayList<Principal> missingPrincipals = new ArrayList<Principal>();
        IPermissionCache thePermCache = this.getPermissionCache();
        for (Principal principal : principals) {
            Permissions perms = thePermCache.getPermissions(principal);
            if (perms == null) {
                missingPrincipals.add(principal);
                continue;
            }
            Enumeration<Permission> permEnum = perms.elements();
            while (permEnum.hasMoreElements()) {
                allPerms.add(permEnum.nextElement());
            }
        }
        if (missingPrincipals.size() > 0) {
            Permissions[] permissionsArray = this.authService.getPermissions(missingPrincipals.toArray(new Principal[missingPrincipals.size()]));
            int i = 0;
            while (i < missingPrincipals.size()) {
                thePermCache.putPermissions((Principal)missingPrincipals.get(i), permissionsArray[i]);
                Enumeration<Permission> permEnum = permissionsArray[i].elements();
                while (permEnum.hasMoreElements()) {
                    allPerms.add(permEnum.nextElement());
                }
                ++i;
            }
        }
        return allPerms;
    }
}

