/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.client.controller.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.SingleChoiceRidget;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class ChoiceSubModuleController
extends SubModuleController {
    private final CarConfig carConfig = new CarConfig();
    private final String[] additionalColors = new String[]{"white", "silver", "gray", "yellow"};
    private final String[] carPlates = new String[]{"JM5B0ND", "1 SPY", "MNY PNY", "BN D07", "Q RULE2", "MI64EVR"};

    public ChoiceSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public CarConfig getCarConfig() {
        return this.carConfig;
    }

    public void configureRidgets() {
        final SingleChoiceRidget compositeCarModel = (SingleChoiceRidget)this.getRidget(SingleChoiceRidget.class, "compositeCarModel");
        compositeCarModel.bindToModel((IObservableList)this.toList((Object[])CarModels.values()), BeansObservables.observeValue((Object)((Object)this.carConfig), (String)"model"));
        compositeCarModel.addMarker((IMarker)new MandatoryMarker());
        compositeCarModel.updateFromModel();
        final IMultipleChoiceRidget compositeCarExtras = (IMultipleChoiceRidget)this.getRidget(IMultipleChoiceRidget.class, "compositeCarExtras");
        String[] labels = new String[]{"Front Machine Guns", "Self Destruct Button", "Underwater Package", "Park Distance Control System"};
        compositeCarExtras.bindToModel((List)this.toList((Object[])CarOptions.values()), Arrays.asList(labels), (Object)this.carConfig, "options");
        compositeCarExtras.updateFromModel();
        final ISingleChoiceRidget compositeCarWarranty = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "compositeCarWarranty");
        compositeCarWarranty.bindToModel((IObservableList)this.toList((Object[])CarWarranties.values()), BeansObservables.observeValue((Object)((Object)this.carConfig), (String)"warranty"));
        compositeCarWarranty.addMarker((IMarker)new MandatoryMarker());
        compositeCarWarranty.updateFromModel();
        final IMultipleChoiceRidget compositeCarPlates = (IMultipleChoiceRidget)this.getRidget(IMultipleChoiceRidget.class, "compositeCarPlates");
        compositeCarPlates.bindToModel((IObservableList)this.toList(this.carPlates), PojoObservables.observeList((Object)((Object)this.carConfig), (String)"plates"));
        compositeCarPlates.addMarker((IMarker)new MandatoryMarker());
        compositeCarPlates.updateFromModel();
        final ISingleChoiceRidget compositeColor = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "compositeColor");
        compositeColor.bindToModel((Object)this.carConfig, "colors", (Object)this.carConfig, "color");
        compositeColor.updateFromModel();
        final ISingleChoiceRidget compositeSunroof = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "compositeSunroof");
        Object[] roofLabels = new String[]{"yes", "no"};
        compositeSunroof.bindToModel((List)this.toList(new Boolean[]{true, false}), (List)this.toList(roofLabels), (Object)this.carConfig, "sunroof");
        compositeSunroof.updateFromModel();
        ITextRidget txtPrice = (ITextRidget)this.getRidget(ITextRidget.class, "txtPrice");
        txtPrice.setOutputOnly(true);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(BeansObservables.observeValue((Object)txtPrice, (String)"text"), BeansObservables.observeValue((Object)((Object)this.carConfig), (String)"price"), null, null);
        IActionRidget buttonPreset = (IActionRidget)this.getRidget(IActionRidget.class, "buttonPreset");
        buttonPreset.setText("&Quick Config");
        buttonPreset.addListener(new IActionListener(){

            public void callback() {
                compositeCarModel.setSelection((Object)CarModels.BMW);
                compositeCarExtras.setSelection(Arrays.asList(CarOptions.PDCS));
                compositeCarWarranty.setSelection((Object)CarWarranties.EXTENDED);
                compositeCarPlates.setSelection(Arrays.asList(ChoiceSubModuleController.this.carPlates[0]));
            }
        });
        IActionRidget buttonReset = (IActionRidget)this.getRidget(IActionRidget.class, "buttonReset");
        buttonReset.setText("&Reset");
        buttonReset.addListener(new IActionListener(){

            public void callback() {
                ChoiceSubModuleController.this.carConfig.reset();
                compositeCarModel.updateFromModel();
                compositeCarExtras.updateFromModel();
                compositeCarWarranty.updateFromModel();
                compositeCarPlates.updateFromModel();
                compositeSunroof.updateFromModel();
                compositeColor.updateFromModel();
            }
        });
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new SubModuleNodeListener(){

            public void beforeActivated(ISubModuleNode source) {
                String[] stringArray = ChoiceSubModuleController.this.additionalColors;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String color = stringArray[n2];
                    if (!ChoiceSubModuleController.this.carConfig.getColors().contains(color)) {
                        ChoiceSubModuleController.this.carConfig.addColor(color);
                        compositeColor.updateFromModel();
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    private WritableList toList(Object[] values) {
        return new WritableList(Arrays.asList(values), Object.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CarConfig
    extends AbstractBean {
        public static final String PROP_MODEL = "model";
        public static final String PROP_OPTIONS = "options";
        public static final String PROP_WARRANTY = "warranty";
        public static final String PROP_PLATES = "plates";
        public static final String PROP_PRICE = "price";
        public static final String PROP_COLOR = "color";
        public static final String PROP_SUNROOF = "sunroof";
        private CarModels model;
        private List<CarOptions> options = new ArrayList<CarOptions>();
        private CarWarranties warranty;
        private List<String> plates = new ArrayList<String>();
        private final List<String> colors = new ArrayList<String>();
        private String color;
        private boolean sunroof;

        public CarConfig() {
            this.addColor("red");
            this.addColor("black");
            this.addColor("blue");
            this.setColor(this.getColors().get(0));
            this.setSunroof(false);
        }

        public void addColor(String color) {
            this.getColors().add(color);
        }

        public CarModels getModel() {
            return this.model;
        }

        public void setModel(CarModels model) {
            this.model = model;
            this.firePropertyChanged(PROP_MODEL, (Object)this.model, (Object)this.model);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public List<CarOptions> getOptions() {
            return Collections.unmodifiableList(this.options);
        }

        public void setOptions(List<CarOptions> options) {
            this.options = new ArrayList<CarOptions>(options);
            this.firePropertyChanged(PROP_OPTIONS, this.options, this.options);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public CarWarranties getWarranty() {
            return this.warranty;
        }

        public void setWarranty(CarWarranties warranty) {
            this.warranty = warranty;
            this.firePropertyChanged(PROP_WARRANTY, (Object)this.warranty, (Object)this.warranty);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public List<String> getPlates() {
            return Collections.unmodifiableList(this.plates);
        }

        public void setPlates(List<String> plates) {
            this.plates = new ArrayList<String>(plates);
            this.firePropertyChanged(PROP_PLATES, this.plates, this.plates);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public void reset() {
            this.setModel(null);
            this.setOptions(new ArrayList<CarOptions>());
            this.setWarranty(null);
            this.setPlates(new ArrayList<String>());
            this.setColor(this.getColors().get(0));
            this.setSunroof(false);
        }

        public long getPrice() {
            long price = 0L;
            if (this.model != null) {
                price += 100000L;
            }
            price += (long)this.options.size() * 25000L;
            if (this.warranty == CarWarranties.EXTENDED) {
                price += 10000L;
            }
            if (this.isSunroof()) {
                price += 899L;
            }
            return price += (long)this.plates.size() * 200L;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public List<String> getColors() {
            return this.colors;
        }

        public void setSunroof(boolean sunroof) {
            this.sunroof = sunroof;
            this.firePropertyChanged(PROP_SUNROOF, this.sunroof, this.sunroof);
            this.firePropertyChanged(PROP_PRICE, null, this.getPrice());
        }

        public boolean isSunroof() {
            return this.sunroof;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CarModels {
        ASTON_MARTIN("Aston Martin V-12 Vanquish"),
        LOTUS("Lotus Esprit Turbo"),
        BMW("BMW Z8");

        private String label;

        private CarModels(String label) {
            Assert.isNotNull((Object)label);
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CarOptions {
        FRONT_GUNS,
        SELF_DESTRUCT,
        UNDERWATER,
        PDCS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CarWarranties {
        STANDARD,
        EXTENDED;


        public String toString() {
            char[] result = super.toString().toLowerCase().toCharArray();
            result[0] = Character.toUpperCase(result[0]);
            return String.valueOf(result);
        }
    }
}

