/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.client.controller.test;

import java.util.ArrayList;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationSubModuleController
extends SubModuleController {
    private IActionRidget addSubModuleToModuleBtn;
    private IActionRidget addSubModuleToSelfBtn;
    private IActionRidget removeSubModuleBtn;
    private IActionRidget addModuleBtn;
    private IActionRidget addModuleGroupBtn;
    private static int nodeCount = 0;

    public NavigationSubModuleController() {
        this(null);
    }

    public NavigationSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        this.addSubModuleToModuleBtn = (IActionRidget)this.getRidget(IActionRidget.class, "addSubModuleToModuleBtn");
        this.addSubModuleToModuleBtn.setText("Add Sub-Module to &Root");
        this.addSubModuleToModuleBtn.addListener(new IActionListener(){

            public void callback() {
                StringBuilder stringBuilder = new StringBuilder("Node ");
                int n = nodeCount;
                nodeCount = n + 1;
                ISubModuleNode newNode = NavigationSubModuleController.this.createSubModuleNode(stringBuilder.append(String.valueOf(n)).toString());
                IModuleNode parent = (IModuleNode)NavigationSubModuleController.this.getParentNodeOfType(NavigationSubModuleController.this.getNavigationNode(), IModuleNode.class);
                parent.setNodeId(new NavigationNodeId("org.eclipse.riena.example.navigate.root"));
                parent.addChild((INavigationNode)newNode);
                NavigationSubModuleController.this.showStatusLineMessage("Sub-Module was added!");
            }
        });
        this.addSubModuleToSelfBtn = (IActionRidget)this.getRidget(IActionRidget.class, "addSubModuleToSelfBtn");
        this.addSubModuleToSelfBtn.setText("Add S&ub-Module this Node");
        this.addSubModuleToSelfBtn.addListener(new IActionListener(){

            public void callback() {
                ISubModuleNode navigationNode = (ISubModuleNode)NavigationSubModuleController.this.getNavigationNode();
                StringBuilder stringBuilder = new StringBuilder("Node ");
                int n = nodeCount;
                nodeCount = n + 1;
                ISubModuleNode subModule = NavigationSubModuleController.this.createSubModuleNode(stringBuilder.append(String.valueOf(n)).toString());
                navigationNode.addChild((INavigationNode)subModule);
                subModule.activate();
                NavigationSubModuleController.this.showStatusLineMessage("Sub-Module was added!");
            }
        });
        this.removeSubModuleBtn = (IActionRidget)this.getRidget(IActionRidget.class, "removeSubModuleBtn");
        this.removeSubModuleBtn.setText("Remove all children");
        this.removeSubModuleBtn.addListener(new IActionListener(){

            public void callback() {
                ISubModuleNode navigationNode = (ISubModuleNode)NavigationSubModuleController.this.getNavigationNode();
                ArrayList children = new ArrayList(navigationNode.getChildren());
                for (ISubModuleNode child : children) {
                    child.dispose();
                }
                if (children.size() > 0) {
                    NavigationSubModuleController.this.showStatusLineMessage("All children removed!");
                }
            }
        });
        this.addModuleBtn = (IActionRidget)this.getRidget(IActionRidget.class, "addModuleBtn");
        this.addModuleBtn.setText("Add &Module");
        this.addModuleBtn.addListener(new IActionListener(){

            public void callback() {
                IModuleGroupNode parent = (IModuleGroupNode)NavigationSubModuleController.this.getParentNodeOfType(NavigationSubModuleController.this.getNavigationNode(), IModuleGroupNode.class);
                parent.addChild((INavigationNode)NavigationSubModuleController.this.createModuleNode());
                NavigationSubModuleController.this.showStatusLineMessage("Module was added!");
            }
        });
        this.addModuleGroupBtn = (IActionRidget)this.getRidget(IActionRidget.class, "addModuleGroupBtn");
        this.addModuleGroupBtn.setText("Add Module-&Group");
        this.addModuleGroupBtn.addListener(new IActionListener(){

            public void callback() {
                ISubApplicationNode parent = (ISubApplicationNode)NavigationSubModuleController.this.getParentNodeOfType(NavigationSubModuleController.this.getNavigationNode(), ISubApplicationNode.class);
                parent.addChild((INavigationNode)NavigationSubModuleController.this.createModuleGroupNode());
                NavigationSubModuleController.this.showStatusLineMessage("Module-Group was added!");
            }
        });
    }

    private void showStatusLineMessage(String text) {
        if (!RienaStatus.isTest()) {
            this.getApplicationController().getStatusline().setMessage(text);
        }
    }

    private <N extends INavigationNode<?>> N getParentNodeOfType(INavigationNode<?> node, Class<N> clazz) {
        return (N)node.getParentOfType(clazz);
    }

    private IModuleGroupNode createModuleGroupNode() {
        NavigationNodeId nodeId = new NavigationNodeId("moduleGroup", Integer.toString(++nodeCount));
        ModuleGroupNode newModuleGroupNode = new ModuleGroupNode(nodeId);
        newModuleGroupNode.setLabel("ModuleGroup");
        IModuleNode newModuleNode = this.createModuleNode();
        newModuleGroupNode.addChild((INavigationNode)newModuleNode);
        return newModuleGroupNode;
    }

    private IModuleNode createModuleNode() {
        NavigationNodeId nodeId = new NavigationNodeId("module", Integer.toString(++nodeCount));
        ModuleNode newModuleNode = new ModuleNode(nodeId, "Module");
        ISubModuleNode newSubModuleNode = this.createSubModuleNode("SubModule");
        newModuleNode.addChild((INavigationNode)newSubModuleNode);
        return newModuleNode;
    }

    private ISubModuleNode createSubModuleNode(String label) {
        SubModuleNode newSubModuleNode = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.example.navigation", Integer.toString(nodeCount)), label);
        return newSubModuleNode;
    }

    private ApplicationController getApplicationController() {
        return (ApplicationController)((IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class)).getNavigationNodeController();
    }
}

