/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.TestClientObject;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.ManualTestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.tests.ITestObjectsOverRemoteService;

@ManualTestCase
public class ObjectsOverRemoteServiceTest
extends RienaTestCase {
    private ITestObjectsOverRemoteService testObjectTypesService;
    private IRemoteServiceRegistration regTestObjectTypesService;

    protected void setUp() throws Exception {
        super.setUp();
        this.regTestObjectTypesService = Register.remoteProxy(ITestObjectsOverRemoteService.class).usingUrl("http://localhost:8080/hessian/TestObjectTypesWS").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.testObjectTypesService = (ITestObjectsOverRemoteService)Service.get(ITestObjectsOverRemoteService.class);
    }

    protected void tearDown() throws Exception {
        this.regTestObjectTypesService.unregister();
        this.testObjectTypesService = null;
        super.tearDown();
    }

    public void testRegularObject() {
        Object object = this.testObjectTypesService.returnObject(0);
        ObjectsOverRemoteServiceTest.assertNotNull((Object)object);
    }

    public void testRegularMap() {
        Map object = this.testObjectTypesService.returnMap(0);
        ObjectsOverRemoteServiceTest.assertNotNull((Object)object);
        ObjectsOverRemoteServiceTest.assertTrue((boolean)(object instanceof Map));
        Map map = object;
        ObjectsOverRemoteServiceTest.assertEquals((int)map.keySet().size(), (int)1);
        ObjectsOverRemoteServiceTest.assertTrue((boolean)(map.keySet().toArray()[0] instanceof String));
        ObjectsOverRemoteServiceTest.assertTrue((boolean)(map.values().toArray()[0] instanceof String));
    }

    public void testInvalidObject() {
        try {
            this.testObjectTypesService.returnObject(1);
        }
        catch (Exception e) {
            ObjectsOverRemoteServiceTest.assertTrue((boolean)(e instanceof RuntimeException));
            return;
        }
        ObjectsOverRemoteServiceTest.fail((String)"should never get here");
    }

    public void testInvalidMap() {
        try {
            this.testObjectTypesService.returnMap(1);
        }
        catch (Exception e) {
            ObjectsOverRemoteServiceTest.assertTrue((boolean)(e instanceof RuntimeException));
            return;
        }
        ObjectsOverRemoteServiceTest.fail((String)"should never get here");
    }

    public void testSendObject() {
        this.testObjectTypesService.sendObject((Object)"Hello");
    }

    public void testSendInvalidObject() {
        try {
            this.testObjectTypesService.sendObject((Object)new TestClientObject());
        }
        catch (Exception e) {
            ObjectsOverRemoteServiceTest.assertTrue((boolean)(e instanceof RuntimeException));
            return;
        }
        ObjectsOverRemoteServiceTest.fail((String)"should never get here");
    }

    public void testSendMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Hello", "world");
        this.testObjectTypesService.sendMap(map);
    }

    public void testSendInvalidMap() {
        try {
            HashMap<String, TestClientObject> map = new HashMap<String, TestClientObject>();
            map.put("Hello", new TestClientObject());
            this.testObjectTypesService.sendMap(map);
        }
        catch (Exception e) {
            ObjectsOverRemoteServiceTest.assertTrue((boolean)(e instanceof RuntimeException));
            return;
        }
        ObjectsOverRemoteServiceTest.fail((String)"should never get here");
    }
}

