/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import org.eclipse.riena.core.injector.extension.IData;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.internal.core.injector.extension.ExtensionPointId;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class ExtensionPointIdTest
extends RienaTestCase {
    public void testCreateEmptyExtensionPoint1() {
        ExtensionPointId id = new ExtensionPointId();
        try {
            id.normalize(IData.class);
        }
        catch (IllegalStateException illegalStateException) {
            Nop.reason((String)"expected");
        }
    }

    public void testCreateEmptyExtensionPoint2() {
        ExtensionPointId id = new ExtensionPointId(null);
        try {
            id.normalize(IData.class);
        }
        catch (IllegalStateException illegalStateException) {
            Nop.reason((String)"expected");
        }
    }

    public void testCreateEmptyExtensionPoint3() {
        ExtensionPointId id = new ExtensionPointId("");
        try {
            id.normalize(IData.class);
        }
        catch (IllegalStateException illegalStateException) {
            Nop.reason((String)"expected");
        }
    }

    public void testExtensionPointWithOneFQId() {
        ExtensionPointId id = new ExtensionPointId("id.one");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        ExtensionPointIdTest.assertEquals((String)"id.one", (String)result);
    }

    public void testExtensionPointWithTwoFQId() {
        ExtensionPointId id = new ExtensionPointId("id.one,id.two");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        ExtensionPointIdTest.assertEquals((String)"id.oneid.two", (String)result);
    }

    public void testExtensionPointWithTthreeFQId() {
        ExtensionPointId id = new ExtensionPointId("id.one,id.two,id.three");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        ExtensionPointIdTest.assertEquals((String)"id.oneid.twoid.three", (String)result);
    }

    public void testExtensionPointWithOneSimpleId() {
        ExtensionPointId id = new ExtensionPointId("one");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        String symbolicName = this.getContext().getBundle().getSymbolicName();
        ExtensionPointIdTest.assertEquals((String)(String.valueOf(symbolicName) + ".one"), (String)result);
    }

    public void testExtensionPointWithTwoSimpleId() {
        ExtensionPointId id = new ExtensionPointId("one,two");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        String symbolicName = this.getContext().getBundle().getSymbolicName();
        ExtensionPointIdTest.assertEquals((String)(String.valueOf(symbolicName) + ".one" + symbolicName + ".two"), (String)result);
    }

    public void testExtensionPointWithThreeSimpleId() {
        ExtensionPointId id = new ExtensionPointId("one,two,three");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        String symbolicName = this.getContext().getBundle().getSymbolicName();
        ExtensionPointIdTest.assertEquals((String)(String.valueOf(symbolicName) + ".one" + symbolicName + ".two" + symbolicName + ".three"), (String)result);
    }

    public void testExtensionPointWithMixedId() {
        ExtensionPointId id = new ExtensionPointId("id.one,two,id.three");
        id.normalize(IData.class);
        String result = "";
        for (String str : id.compatibleIds()) {
            result = String.valueOf(result) + str;
        }
        String symbolicName = this.getContext().getBundle().getSymbolicName();
        ExtensionPointIdTest.assertEquals((String)("id.one" + symbolicName + ".two" + "id.three"), (String)result);
    }

    public void testFailBecauseOfNoNormalize() {
        ExtensionPointId id = new ExtensionPointId("id.one,two,id.three");
        try {
            id.compatibleIds();
        }
        catch (IllegalStateException illegalStateException) {
            Nop.reason((String)"ok");
        }
    }
}

