/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.service.DepOne;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.injector.service.TargetOnceOnlyViaStatic;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class ServiceInjectorOnceOnlyTest
extends RienaTestCase {
    private ServiceRegistration reg;

    protected void setUp() throws Exception {
        super.setUp();
        this.reg = this.getContext().registerService(DepOne.class.getName(), (Object)new DepOne(), null);
    }

    protected void tearDown() throws Exception {
        if (this.reg != null) {
            this.reg.unregister();
        }
        super.tearDown();
    }

    public void testInjectOnceOnlyViaStaticOneTarget() {
        this.printTestName();
        TargetOnceOnlyViaStatic target = new TargetOnceOnlyViaStatic();
        ServiceInjector injector = null;
        try {
            TargetOnceOnlyViaStatic.resetCounters();
            injector = Inject.service((String)DepOne.class.getName()).into((Object)target).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
        }
        finally {
            injector.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
        }
    }

    public void testInjectOnceOnlyViaStaticTwoTargetsFirstGoesFirst() {
        this.printTestName();
        TargetOnceOnlyViaStatic target1 = new TargetOnceOnlyViaStatic();
        TargetOnceOnlyViaStatic target2 = new TargetOnceOnlyViaStatic();
        ServiceInjector injector1 = null;
        ServiceInjector injector2 = null;
        try {
            TargetOnceOnlyViaStatic.resetCounters();
            injector1 = Inject.service((String)DepOne.class.getName()).into((Object)target1).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
            injector2 = Inject.service((String)DepOne.class.getName()).into((Object)target2).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
        }
        finally {
            injector1.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)0, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
            injector2.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
        }
    }

    public void testInjectOnceOnlyViaStaticTwoTargetsFirstGoesLast() {
        this.printTestName();
        TargetOnceOnlyViaStatic target1 = new TargetOnceOnlyViaStatic();
        TargetOnceOnlyViaStatic target2 = new TargetOnceOnlyViaStatic();
        ServiceInjector injector1 = null;
        ServiceInjector injector2 = null;
        try {
            TargetOnceOnlyViaStatic.resetCounters();
            injector1 = Inject.service((String)DepOne.class.getName()).into((Object)target1).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
            injector2 = Inject.service((String)DepOne.class.getName()).into((Object)target2).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
        }
        finally {
            injector2.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)0, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
            injector1.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
        }
    }

    public void testInjectOnceOnlyViaStaticTwoTargetsFirstGoesFirstServiceGoesAndComes() {
        this.printTestName();
        TargetOnceOnlyViaStatic target1 = new TargetOnceOnlyViaStatic();
        TargetOnceOnlyViaStatic target2 = new TargetOnceOnlyViaStatic();
        ServiceInjector injector1 = null;
        ServiceInjector injector2 = null;
        try {
            TargetOnceOnlyViaStatic.resetCounters();
            injector1 = Inject.service((String)DepOne.class.getName()).into((Object)target1).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
            injector2 = Inject.service((String)DepOne.class.getName()).into((Object)target2).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
            this.reg.unregister();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
            this.reg = this.getContext().registerService(DepOne.class.getName(), (Object)new DepOne(), null);
            ServiceInjectorOnceOnlyTest.assertEquals((int)2, (int)TargetOnceOnlyViaStatic.getBindCounter());
        }
        finally {
            injector1.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
            injector2.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)2, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
        }
    }

    public void testInjectOnceOnlyViaStaticTwoTargetsFirstGoesLastGoesAndComes() {
        this.printTestName();
        TargetOnceOnlyViaStatic target1 = new TargetOnceOnlyViaStatic();
        TargetOnceOnlyViaStatic target2 = new TargetOnceOnlyViaStatic();
        ServiceInjector injector1 = null;
        ServiceInjector injector2 = null;
        try {
            TargetOnceOnlyViaStatic.resetCounters();
            injector1 = Inject.service((String)DepOne.class.getName()).into((Object)target1).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
            injector2 = Inject.service((String)DepOne.class.getName()).into((Object)target2).bind("bind").andStart(this.getContext());
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getBindCounter());
            this.reg.unregister();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
            this.reg = this.getContext().registerService(DepOne.class.getName(), (Object)new DepOne(), null);
            ServiceInjectorOnceOnlyTest.assertEquals((int)2, (int)TargetOnceOnlyViaStatic.getBindCounter());
        }
        finally {
            injector2.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)1, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
            injector1.stop();
            ServiceInjectorOnceOnlyTest.assertEquals((int)2, (int)TargetOnceOnlyViaStatic.getUnbindCounter());
        }
    }
}

